// iSDKTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "iSDKTest.h"
#include "iSDKTestDlg.h"
#include "WCSDK2Define.h"
#include "Shlobj.h"
#include "ShFolder.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISDKTestDlg dialog

CISDKTestDlg::CISDKTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CISDKTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CISDKTestDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_dwBtnPress = 0;
	m_dwColorBtnPress = 0;
}

void CISDKTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CISDKTestDlg)
	DDX_Control(pDX, IDC_EDIT_SERIAL, m_edSerial);
	DDX_Control(pDX, IDC_COM_CHINESE_OUTPUT, m_cbChineseOutput);
	DDX_Control(pDX, IDC_EDIT_RESULT, m_edResult);
	DDX_Control(pDX, IDC_COMB_LANGUAGE, m_cbLang);
	DDX_Control(pDX, IDC_EDFILENAME, m_edFileName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CISDKTestDlg, CDialog)
	//{{AFX_MSG_MAP(CISDKTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_START, OnBtnStart)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_END, OnBtnEnd)
	ON_BN_CLICKED(IDC_BTN_SCANONWND, OnBtnScanonwnd)
	ON_BN_CLICKED(IDC_BTN_RECOG, OnBtnRecog)
	ON_BN_CLICKED(IDC_BTN_GETLANG, OnBtnGetlang)
	ON_REGISTERED_MESSAGE(gsdkMsg,OnWCSDKMsg)
	ON_BN_CLICKED(IDC_BTN_SCANCARD, OnBtnScancard)
	ON_BN_CLICKED(IDC_RECTRECOG, OnRectrecog)
	ON_BN_CLICKED(IDC_BTN_START_BYKEYPRO, OnBtnStartBykeypro)
	ON_BN_CLICKED(IDC_CALIBRATE, OnCalibrate)
	ON_BN_CLICKED(IDC_INITIAL_REGGED, OnBtnInitialRegged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISDKTestDlg message handlers

BOOL CISDKTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_edFileName.SetWindowText(L"C:\\AA.JPG");
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CISDKTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CISDKTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CISDKTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
void CISDKTestDlg::OnBtnStartBykeypro() 
{
	if( ActiveWCSDK() )
	{
		SetErrorMsg(-1);
		long nRtn = m_App.InitSDKByKeyPro(L"OEM_SCANX",L"Your Product Name",(long)m_hWnd);
		SetErrorMsg(nRtn);
	}	
}
void CISDKTestDlg::OnBtnInitialRegged() 
{

	if( ActiveWCSDK() )
	{
		SetErrorMsg(-1);
		WCHAR buf[512];
		memset(buf,0x00,512);
		SHGetSpecialFolderPath(0, buf, CSIDL_COMMON_APPDATA, TRUE);
		wcscat(buf,L"\\Penpower\\WCSDK\\WorldCardSync.wreg");
		
		long nRtn = m_App.DoCheckLocalRegisterFileOK(L"OEM_SCANX",L"Your Product Name",(long)m_hWnd,buf);
		SetErrorMsg(nRtn);
	}	

// 	 ActiveWCSDK();
// 	
// 		SetErrorMsg(-1);
// 		WCHAR buf[512];
// 		memset(buf,0x00,512);
// 		SHGetSpecialFolderPath(0, buf, CSIDL_COMMON_APPDATA, TRUE);
// 		wcscat(buf,L"\\Penpower\\WorldSDK\\WorldCardSync.wreg");
//     	
// 		long nRtn = m_App.DoCheckLocalRegisterFileOK(buf);
// 		
// 		if (nRtn == 1)
// 			SetErrorMsg(0); //ܦ\
// 		else
// 			SetErrorMsg(1); //ܥ
// 		
		
}
void CISDKTestDlg::OnBtnStart() 
{
	if( ActiveWCSDK() )
	{
		SetErrorMsg(-1);
		CString csCode;
		m_edSerial.GetWindowText(csCode);
		long nRtn = m_App.InitSDK(csCode,L"OEM_SCANX",L"Your Product Name",(long)m_hWnd);
		SetErrorMsg(nRtn);
	}
}


 void CISDKTestDlg::OnCalibrate() 
{
	 SetErrorMsg(-1);
	long nRtn = m_App.CalibrateScanner();	
	SetErrorMsg(nRtn);	
}

void CISDKTestDlg::OnDestroy() 
{
	CDialog::OnDestroy();

}

void CISDKTestDlg::OnBtnEnd() 
{
	m_App.UnInitSDK();		
	m_App.DetachDispatch();
}

void CISDKTestDlg::OnBtnScancard() 
{
	SetErrorMsg(-1);
	CString csStr;
	m_edFileName.GetWindowText(csStr);
	long nRtn = m_App.ScanCardtoMemory(TRUE,L"C:\\AA.JPG");
//	long nRtn = m_App.ScanCard(L"C:\\AA.JPG");
	SetErrorMsg(nRtn);
}


void CISDKTestDlg::OnBtnScanonwnd() 
{
	SetErrorMsg(-1);
	CString csStr;
	m_edFileName.GetWindowText(csStr);
	CWnd* pWnd = GetDlgItem(IDC_CARD_PIC);
	if( pWnd )
	{
		CRect rcClient;
		pWnd->GetClientRect(&rcClient);
		long nRtn = m_App.ScanCardtoMemoryOnWnd(TRUE,csStr,(long)pWnd->m_hWnd,rcClient.left,rcClient.top,rcClient.right,rcClient.bottom);
//		long nRtn = m_App.ScanCardOnWnd(L"C:\\Users\\Carpe\\Desktop\\CardDB_20140422aa.jpg",(long)pWnd->m_hWnd,rcClient.left,rcClient.top,rcClient.right,rcClient.bottom);
		SetErrorMsg(nRtn);
	}
}
 
void CISDKTestDlg::OnBtnRecog() 
{
	SetErrorMsg(-1);
	CString csStr;
	m_edFileName.GetWindowText(csStr);
	int nSel = m_cbLang.GetCurSel();
	if( nSel >= 0 )
	{
		WORD wLangID = (WORD)m_cbLang.GetItemData(nSel);

		nSel = m_cbChineseOutput.GetCurSel();
		if( nSel >= 0 )
		{
			WORD wChineseOutputID = (WORD)m_cbChineseOutput.GetItemData(nSel);
			m_App.SetFieldLayout(6);
			long nRtn = m_App.RecogCard(csStr,wLangID,FALSE,wChineseOutputID,true);
			if( nRtn == 0 )
			{
				CString csText;
				for( int i = 0 ; i < m_App.GetFieldCount() ; i++)
				{
					long lType = m_App.GetFieldType(i);
					csStr.Format(L"%X=%s\r\n",_GETCATE(lType),m_App.GetFieldString(i));
					csText += csStr;
				}
				m_edResult.SetWindowText(csText);
			}
			SetErrorMsg(nRtn);
		}
	}
}


void CISDKTestDlg::OnBtnGetlang() 
{
	m_cbLang.ResetContent();
	DWORD dwCount = m_App.GetCharSetCount();
	for( DWORD i = 0 ; i < dwCount; i++)
	{
		
		WORD wLangID = m_App.GetCharSetInSeq(i);
		CString csStr = GetLangString(wLangID);
//		csStr.Format(L"%04X",wLangID);
		m_cbLang.AddString(csStr);
		m_cbLang.SetItemData(m_cbLang.GetCount() -1 ,wLangID);
	}
	if( m_cbLang.GetCount() )
		m_cbLang.SetCurSel(0);
	
	m_cbChineseOutput.ResetContent();
//	CString csMsg;
//	csMsg.Format(L"%04X",0x0404);
	m_cbChineseOutput.AddString(L"Traditional Chinese");
	m_cbChineseOutput.SetItemData(0,0x0404);
//	csMsg.Format(L"%04X",0x0804);
	m_cbChineseOutput.AddString(L"Simplified Chinese");
	m_cbChineseOutput.SetItemData(1,0x0804);
	m_cbChineseOutput.SetCurSel(0);
	
}



long CISDKTestDlg::OnWCSDKMsg(WPARAM wParam,LPARAM lParam)
{
	CString csStr;
	if( wParam == SCANNER_STATUS_RTN)
	{
		switch( lParam)
		{
		case(SCANNER_STATUS_PAPER_ON):
			m_stPaper.SetWindowText(L"Detected");
			break;
		case(SCANNER_STATUS_PAPER_OFF):
			m_stPaper.SetWindowText(L"Not Detected");
			break;
		case(SCANNER_STATUS_MACHINE_ON):
			m_stMachine.SetWindowText(L"Connected");
			break;
		case(SCANNER_STATUS_MACHINE_OFF):
			m_stMachine.SetWindowText(L"Disconnected");
			break;
		case(SCANNER_STATUS_BUTTON_ON):
			csStr.Format(L"%d",++m_dwBtnPress);
			m_stBtnPress.SetWindowText(csStr);
			break;
		case(SCANNER_STATUS_COLOR_BUTTON_ON):
			csStr.Format(L"%d",++m_dwColorBtnPress);
			m_stColorBtn.SetWindowText(csStr);
			break;
		default:
			break;
		}
	}
	return 1;
}

void CISDKTestDlg::SetErrorMsg(DWORD dwRtnMsg)
{
	/* Please refercence WCSDK2Define.h*/
	CWnd* pWnd = GetDlgItem(IDC_RTN_MSG);
	if( pWnd) 
	{
	
		CString csStr;
		switch(dwRtnMsg)
		{
		case(WCSDK_RTN_SUCESS):
			csStr = "WCSDK_RTN_SUCESS";
			break;
		case(WCSDK_SCANNER_INIT_ERROR):
			csStr = "WCSDK_SCANNER_INIT_ERROR";
			break;
		case(WCSDK_KERNEL_INIT_ERROR):
			csStr = "WCSDK_KERNEL_INIT_ERROR";
			break;
		case(WCSDK_LICENSE_CODE_ERROR):
			csStr = "WCSDK_LICENSE_CODE_ERROR";
			break;
		case(WCSDK_RTN_LIB_MISS):
			csStr = "WCSDK_RTN_LIB_MISS";
			break;
		case(WCSDK_OVER30DAY):
			csStr = "WCSDK_OVER30DAY";
			break;
		case(WCSDK_OVER_TIME_LIMIT):
			csStr = "WCSDK_OVER_TIME_LIMIT";
			break;
		case(WCSDK_RECOGIN_FAIL):
			csStr = "WCSDK_RECOGIN_FAIL";
			break;
		case(WCSDK_CANCEL_BY_USER):
			csStr = "WCSDK_CANCEL_BY_USER";
			break;
		case(WCSDK_SCANNER_DEVICE_NOT_EXIST):
			csStr = "WCSDK_SCANNER_DEVICE_NOT_EXIST";
			break;
		case(WCSDK_SCANNER_PAPER_NOT_EXIST):
			csStr = "WCSDK_SCANNER_PAPER_NOT_EXIST";
			break;
		case(WCSDK_SCANNER_DEVICE_NOT_FOUND):
			csStr = "WCSDK_SCANNER_DEVICE_NOT_FOUND";
			break;
		case(WCSDK_SCANNER_LIB_LOAD_FAIL):
			csStr = "WCSDK_SCANNER_LIB_LOAD_FAIL";
			break;
		case(WCSDK_SCANNER_DRIVER_NOT_INSTALL):
			csStr = "WCSDK_SCANNER_DRIVER_NOT_INSTALL";
			break;
		case(WCSDK_SCANNER_CALIBRATE_NEEDED):
			csStr = "WCSDK_SCANNER_CALIBRATE_NEEDED";
			break;
		case(WCSDK_SCANNER_MANAGER_NOT_FOUND):
			csStr = "WCSDK_SCANNER_MANAGER_NOT_FOUND";
			break;
		case(WCSDK_SCANNER_MANAGER_COM_ERROR):
			csStr = "WCSDK_SCANNER_MANAGER_COM_ERROR";
			break;
		case(WCSDK_SCANNER_MODULE_INIT_ERROR):
			csStr = "WCSDK_SCANNER_MODULE_INIT_ERROR";
			break;
		case(WCSDK_PRODUCT_NOT_SUPPORT):
			csStr = "WCSDK_PRODUCT_NOT_SUPPORT";
			break;
		case(WCSDK_SCANNER_BUSY):
			csStr = "WCSDK_SCANNER_BUSY";
			break;
		case(WCSDK_SCANNER_SCAN_FINISH):
			csStr = "WCSDK_SCANNER_SCAN_FINISH";
			break;
		case(WCSDK_SCANNER_CALIBRATE_FAIL):
			csStr = "WCSDK_SCANNER_CALIBRATE_FAIL";
			break;
		case(WCSDK_WORLDCARD_NOT_EXIST):
			csStr = "WCSDK_WORLDCARD_NOT_EXIST";
			break;
		case(WCSDK_BUSY):
			csStr = "WCSDK_BUSY";
			break;
		case(WCSDK_PAPER_JAM):
			csStr = "WCSDK_PAPER_JAM";
			break;
		case(WCSDK_INTERNEL_ERROR):
			csStr = "WCSDK_INTERNEL_ERROR";
			break;
		case(WCSDK_CARD_IMAGE_NOT_BE_SCANNED):
			csStr = "WCSDK_CARD_IMAGE_NOT_BE_SCANNED";
			break;
		case(WCSDK_KEYPRO_ERR):
			csStr = "WCSDK_KEYPRO_ERR";
			break;
		case(WCSDK_REGGED_ERR):
			csStr = "WCSDK_REGGED_ERR";
			break;
		default:
			csStr.Format(L"%04X",dwRtnMsg);
			break;
		case(-1):
			break;

		}
		pWnd->SetWindowText(csStr);
	}

}


void CISDKTestDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}


void CISDKTestDlg::OnRectrecog() 
{
	SetErrorMsg(-1);
	CString csStr;
	m_edFileName.GetWindowText(csStr);
	int nSel = m_cbLang.GetCurSel();
	if( nSel >= 0 )
	{
		WORD wLangID = (WORD)m_cbLang.GetItemData(nSel);

		nSel = m_cbChineseOutput.GetCurSel();
		if( nSel >= 0 )
		{
			WORD wChineseOutputID = (WORD)m_cbChineseOutput.GetItemData(nSel);
			long nRtn = m_App.RecogRect(csStr,wLangID,FALSE,wChineseOutputID,400,100,1200,240);
			if( nRtn == 0 )
			{
				CString csText = m_App.GetRectResult();
				m_edResult.SetWindowText(csText);
			}
			SetErrorMsg(nRtn);
		}
	}		
}

bool CISDKTestDlg::ActiveWCSDK()
{
	if( m_App != NULL)
		return true;
	LPDISPATCH		pDisp;
	LPUNKNOWN		pUnk;
	CLSID			clsidVBA;
	if(::CLSIDFromProgID(L"WCSDK2W8_CUSTOM.IApplication", &clsidVBA) != S_OK) 
	{
//		m_dwLastError = ISCAN_CNT_SCAN_MANAGER_COM_ERROR;
//		return ISCAN_CNT_SCAN_MANAGER_COM_ERROR;
		return false;
	}	
	if(::GetActiveObject(clsidVBA, NULL, &pUnk) == S_OK) 
	{
		if(pUnk->QueryInterface(IID_IDispatch, (void**)(&pDisp)) != S_OK) 
		{
//			m_dwLastError = ISCAN_CNT_SCAN_MANAGER_COM_ERROR;
//			return ISCAN_CNT_SCAN_MANAGER_COM_ERROR;
			return  false;
		}
		m_App.AttachDispatch(pDisp);
		pUnk->Release();
	} 
	else 
	{
		if(m_App.CreateDispatch(clsidVBA, NULL) != TRUE )
		{
//			m_dwLastError = ISCAN_CNT_SCAN_MANAGER_COM_ERROR;
//			return ISCAN_CNT_SCAN_MANAGER_COM_ERROR;
			return  false;
		}
	}
	m_App.m_bAutoRelease = true;
	if(!(m_App) )
	{
//		m_dwLastError = ISCAN_CNT_SCAN_MANAGER_COM_ERROR;
//		return ISCAN_CNT_SCAN_MANAGER_COM_ERROR;
		return false;
	}
	return true;
}

CString CISDKTestDlg::GetLangString(WORD wLangID)
{
	CString csLang;
	switch(wLangID)
	{
	default:
		csLang.Format(L"%04X",wLangID);
		break;
	case(0x04):
		csLang =L"CHINESE";
		break;
	case(0x09):
		csLang =L"ENGLISH";
		break;
	case(0x07):
		csLang =L"GERMAN";
		break;
	case(0xc):
		csLang =L"FRENCH";
		break;
	case(0x0a):
		csLang =L"SPANISH";
		break;
	case(0x0411):
		csLang =L"JAPANESE";
		break;
	case(0x0412):
		csLang =L"KOREAN";
		break;
	case(0x10):
		csLang =L"ITALIAN";
		break;
	case(0x14):
		csLang =L"NORWEGIAN";
		break;
	case(0x0E):
		csLang =L"HUNGARIAN";
		break;
	case(0x15):
		csLang =L"POLISH";
		break;
	case(0x1D):
		csLang =L"SWEDISH";
		break;
	case(0x06):
		csLang =L"DANISH";
		break;
	case(0x0B):
		csLang =L"FINNISH";
		break;
	case(0x13):
		csLang =L"DUTCH";
		break;
	case(0x1F):
		csLang =L"TURKISH";
		break;
	case(0X0419):
		csLang =L"RUSSIAN";
		break;
	case(0X16):
		csLang =L"PORTUGUESE";
		break;
	case(0X0408):
		csLang =L"GREEK";
		break;
	case(0X080A):
		csLang =L"SPANISH(MIXCO)";
		break;
	case(0X0416):
		csLang =L"PORTUGUESE(BRAZIL)";
		break;
	case(0X0405):
		csLang =L"CZECH";
		break;
	case(0X041B):
		csLang =L"SLOVAK";
		break;
	case(0X0401):
		csLang =L"ARABIC";
		break;
	case (0X1054):
		csLang =L"THAILAND";
		break;

	}
	return csLang;
}


