//
//  TSMCNoAccountSalesforceContactViewController.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/30.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCTableViewController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
@class TSMCNoAccountSalesforceContactViewController;

@protocol TSMCNoAccountSalesforceContactViewControllerDelegate <NSObject>

/**
 * 用來取得cache中的縮圖
 * @param viewController 委託者
 * @param cardID 要取得的名片圖的名片ID
 * @return UIImage 名片圖縮圖
 */
- (UIImage *)noAccountSalesforceContactViewController:(TSMCNoAccountSalesforceContactViewController *)noAccountSalesforceContactViewController cachedThumbnailImageWithCardID:(NSString *)cardID;

/**
 * 用來取得cell中的縮圖
 * @param viewController 委託者
 * @param cardID 要取得的名片圖的名片ID
 * @return UIImage 名片圖縮圖
 */
- (UIImage *)noAccountSalesforceContactViewController:(TSMCNoAccountSalesforceContactViewController *)noAccountSalesforceContactViewController thumbnailImageWithCardID:(NSString *)cardID;

/**
 * 取得未校正聯絡人列表
 * @param viewController 委託者
 */
- (NSMutableArray *)contactArrayWithNoAccountSalesforceContactViewController:(TSMCNoAccountSalesforceContactViewController *)noAccountSalesforceContactViewController error:(NSError **)error;

@optional
/**
 * 點選多選
 * @param viewController 委託者
 */
- (void)didClickMultiSelectWithNoAccountSalesforceContactViewController:(TSMCNoAccountSalesforceContactViewController *)noAccountSalesforceContactViewController;



/**
 * 要顯示聯絡人資訊
 * @param unverifiedContactsViewController view controlller instance
 * @param superViewcontroller 要從哪一個view controller顯示出來
 * @param cardID 點選到的名片ID
 * @param cardIDArray 要顯示的名片列表
 */
- (void)noAccountSalesforceContactViewController:(TSMCNoAccountSalesforceContactViewController *)noAccountSalesforceContactViewController
           showDetailFromViewController:(PPViewController *)superViewcontroller
                                 cardID:(NSString *)cardID
                          atCardIDArray:(NSArray*)cardIDArray;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface TSMCNoAccountSalesforceContactViewController : WCTableViewController

@property (nonatomic, assign) id<TSMCNoAccountSalesforceContactViewControllerDelegate> delegate;
/// view controller title, 預設為 [@"MLS_UnverifiedContacts" localized]
@property (nonatomic, retain) NSString *titleString;


#pragma mark fucos control
- (void)adjustCurrentSelectedIndexPath;

@end
