//
//  TSMCURLSchemeHandler.m
//  WorldCardTeam_TSMC
//
//  Created by sanhue cheng on 2021/11/22.
//  Copyright © 2021 penpower. All rights reserved.
//

#import "TSMCURLSchemeHandler.h"

@implementation TSMCURLSchemeHandler





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.taskMap = [NSMutableDictionary dictionary];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.taskMap = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - NSURLSessionDelegate


//==============================================================================
//
//==============================================================================
- (void)URLSession:(NSURLSession *)session didReceiveChallenge:(NSURLAuthenticationChallenge *)challenge completionHandler:(void (^)(NSURLSessionAuthChallengeDisposition, NSURLCredential * _Nullable))completionHandler
{
    if([challenge.protectionSpace.host containsString:@"tsmc.com"])
    {
        NSURLCredential *credential = [NSURLCredential credentialForTrust:challenge.protectionSpace.serverTrust];
        
        completionHandler(NSURLSessionAuthChallengeUseCredential, credential);
    }
    else
    {
        if(completionHandler)
        {
            completionHandler(NSURLSessionAuthChallengePerformDefaultHandling, nil);
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WKURLSchemeHandler



//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView startURLSchemeTask:(id<WKURLSchemeTask>)urlSchemeTask
{
    NSURL *url = urlSchemeTask.request.URL;
    NSLog(@"url:%@", url);
    if(url==nil)
    {
        [urlSchemeTask didFailWithError:[NSError errorWithDomain:NSURLErrorDomain code:NSURLErrorBadURL userInfo:nil]];
        return ;
    }
    
    if([url.absoluteString containsString:TSMCURLSchemeHandler_CustomScheme])
    {
        NSString *realUrlString = [url.absoluteString stringByReplacingOccurrencesOfString:TSMCURLSchemeHandler_CustomScheme withString:@"https"];
        NSURL *properURL = [NSURL URLWithString:realUrlString];
        
        NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:properURL cachePolicy:NSURLRequestReloadIgnoringCacheData timeoutInterval:30];
        urlRequest.HTTPMethod = urlSchemeTask.request.HTTPMethod;
        urlRequest.HTTPBody = urlSchemeTask.request.HTTPBody;
        urlRequest.allHTTPHeaderFields =urlSchemeTask.request.allHTTPHeaderFields;
        
        NSURLSessionDataTask *task = [[NSURLSession sharedSession] dataTaskWithRequest:urlRequest completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
            
            [self webView:webView stopURLSchemeTask:urlSchemeTask];
            
            if(error)
            {
                [urlSchemeTask didFailWithError:error];
                return ;
            }
            
            if(response)
            {
                [urlSchemeTask didReceiveResponse:response];
            }
            
            if(data)
            {
                [urlSchemeTask didReceiveData:data];
            }
            
            [urlSchemeTask didFinish];
        }];
        if (@available(iOS 15.0, *)) {
            task.delegate = self;
        } else {
            // Fallback on earlier versions
        }
        [task resume];
    }
    else
    {
        [urlSchemeTask didFinish];
    }
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView stopURLSchemeTask:(id<WKURLSchemeTask>)urlSchemeTask
{
    NSURL *url = urlSchemeTask.request.URL;
    if(url==nil)
    {
        [urlSchemeTask didFailWithError:[NSError errorWithDomain:NSURLErrorDomain code:NSURLErrorBadURL userInfo:nil]];
        return ;
    }
    
    NSURLSessionDataTask *task = [self.taskMap objectForKey:url];
    if(task)
    {
        [self.taskMap removeObjectForKey:url];
        [task cancel];
    }
    
}



//==============================================================================
//
//==============================================================================
+ (instancetype)sharedInstance
{
    static TSMCURLSchemeHandler *staticTSMCURLSchemeHandler = nil;
    
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        staticTSMCURLSchemeHandler = [[TSMCURLSchemeHandler alloc] init];
    });
    
    return staticTSMCURLSchemeHandler;
}
@end
