//
//  NSError+CustomMessage.m
//  WorldCardSF
//
//  Created by sanhue on 2019/3/11.
//  Copyright © 2019 penpower. All rights reserved.
//

#import "NSError+CustomMessage.h"

#import "ResourceDefine.h"
#import "NSError+Custom.h"
#import "PPNetworkReachabilityController.h"

@implementation NSError (CustomMessage)

- (NSString *)customErrorMessageWithDefaultError:(BOOL)defaultError
{
    NSError *networkError = [self findNetworkError];
    NSString *errorMessage = nil;
    if (networkError)
    {
        errorMessage = Common_FailedToConnectInternet;
    }
    else
    {
        if (defaultError)
        {
            errorMessage = [self alertMessage];
        }
    }
    
    return errorMessage;
}

@end
