//
//  NSString+PhoneNumberExtension.m
//  WorldCardHD
//
//  Created by aecho liu on 2011/8/30.
//  Copyright (c) 2011年 Penpower. All rights reserved.
//

#import "NSString+PhoneNumberExtension.h"
#import "CutPhoneNumber.h"
// need libcutPhoneNumber.a
enum {
    CCODE_NO_COUNTRY = 0,   ///< 沒對應的countryCode時，就用這個參數。
    CCODE_TW,   //1
    CCODE_US,   //2
    CCODE_CN,   //3
    CCODE_HK,   //4
    
    CCODE_CA,   //5
    CCODE_UK,   //6     ///< 英國 (gb)
    CCODE_IND,  //7     ///< 印度 (in)
    CCODE_SG,   //8
    CCODE_MY,   //9
    
    CCODE_INA,  //10    ///< 印尼 (id)
    CCODE_JP,   //11
    CCODE_KR,   //12
    CCODE_AU,   //13
    CCODE_DE,   //14
    
    CCODE_FR,   //15
    CCODE_IT,   //16
    CCODE_ES,   //17
    CCODE_PT,   //18
    CCODE_NL,   //19
    
    CCODE_BR,   //20
    CCODE_AT,   //21
    CCODE_BE,   //22
    CCODE_CH,   //23
    CCODE_NO,   //24
    
    CCODE_HU,   //25
    CCODE_PL,   //26
    CCODE_SE,   //27
    CCODE_DK,   //28
    CCODE_FI,   //29
    
    CCODE_TR,   //30
    CCODE_RU,   //31
    CCODE_GR,   //32
    CCODE_MX,   //33
    CCODE_CZ,   //34
    
    CCODE_SK,   //35
    CCODE_NZ,             //36
    CCODE_PH,             //37
    CCODE_TH,             //38
    CCODE_VN,             //39
    CCODE_BG,             //40
    CCODE_CY,             //41
    CCODE_SI,             //42
    CCODE_RO,             //43
    CCODE_HR,             //44
    
    CCODE_IE,             //45
    CCODE_LI,             //46
    CCODE_LU,             //47
    CCODE_BY,             //48
    CCODE_UA,             //49
    CCODE_EE,             //50
    CCODE_KZ,             //51
    CCODE_LV,             //52
    CCODE_LT,             //53
};

extern void CutPhoneNumber(unsigned short *pcInput, unsigned short *pcOutput, unsigned char byCountry);


typedef struct {
    NSString *countryCode;
    unsigned short countryID;
} _CCITEM;

static const _CCITEM g_ccode_map[] = {
    {@"tw", CCODE_TW },
    {@"us", CCODE_US },
    {@"cn", CCODE_CN },
    {@"hk", CCODE_HK },

    {@"ca", CCODE_CA },
    {@"uk", CCODE_UK },
    {@"in", CCODE_CA },
    {@"sg", CCODE_SG },
    {@"my", CCODE_MY },

    {@"id", CCODE_INA},
    {@"jp", CCODE_JP },
    {@"kr", CCODE_KR },
    {@"au", CCODE_AU },
    {@"de", CCODE_DE },

    {@"fr", CCODE_FR },
    {@"it", CCODE_IT },
    {@"es", CCODE_ES },
    {@"pt", CCODE_PT },
    {@"nl", CCODE_NL },
    
    {@"br", CCODE_BR },
    {@"at", CCODE_AT },
    {@"be", CCODE_BE },
    {@"ch", CCODE_CH },
    {@"no", CCODE_NO },

    {@"hu", CCODE_HU },
    {@"pl", CCODE_PL },
    {@"se", CCODE_SE },
    {@"dk", CCODE_DK },
    {@"fi", CCODE_FI },
    
    {@"tr", CCODE_TR },
    {@"ru", CCODE_RU },
    {@"gr", CCODE_GR },
    {@"mx", CCODE_MX },
    {@"cz", CCODE_CZ },
    
    {@"sk", CCODE_SK },
    {@"nz", CCODE_NZ },
    {@"ph", CCODE_PH },
    {@"th", CCODE_TH },
    {@"vn", CCODE_VN },
    
    {@"bg", CCODE_BG },
    {@"cy", CCODE_CY },
    {@"si", CCODE_SI },
    {@"ro", CCODE_RO },
    {@"hr", CCODE_HR },
    
    {@"ie", CCODE_IE },
    {@"li", CCODE_LI },
    {@"lu", CCODE_LU },
    {@"by", CCODE_BY },
    {@"ua", CCODE_UA },
    
    {@"ee", CCODE_EE },
    {@"kz", CCODE_KZ },
    {@"lv", CCODE_LV },
    {@"lt", CCODE_LT },
    
};


static const int g_ccode_map_count = sizeof(g_ccode_map) / sizeof(g_ccode_map[0]);

NS_INLINE
NSNumber *__NUM(unsigned short num) {
    return [NSNumber numberWithUnsignedShort:num];
}

#define     _kMAXLENGTH     256
#define     _kMAXBUFFER     512

@implementation NSString (PhoneNumberExtension)

- (NSString *)localizedPhonenumber
{
    // 字串長度防護，避免不必要的問題。
    if ([self length] >= _kMAXLENGTH) return self;
    
    static NSMutableDictionary *map = nil;
    if (!map) {
        map = [[NSMutableDictionary alloc] init];
        
        for (int i = 0 ; i < g_ccode_map_count; ++i) {
            _CCITEM ccItm = g_ccode_map[i];
            [map setObject:__NUM(ccItm.countryID) forKey:ccItm.countryCode];
        }
    }

    // query map
    NSString *ccode = [[[NSLocale currentLocale] objectForKey:NSLocaleCountryCode] lowercaseString];
    NSNumber *ccIDNum = [map objectForKey:ccode];
    
    unsigned short byCountry = CCODE_NO_COUNTRY;
    if (ccIDNum != nil) 
        byCountry = [ccIDNum unsignedShortValue];
    
    unsigned short input[_kMAXBUFFER] = {0}, output[_kMAXBUFFER] = {0};
    
    [self getCharacters:input];
    CutPhoneNumber(input, output, byCountry);
    
    int len = 0;
    for (; output[len]; ++len) { /*no-op*/ }
    NSString *outPhone = [[NSString alloc] initWithCharacters:output length:len];
    
    //NSLog(@"%s ccode:%@ byCountryCode:%d inputPhone:%@ outputPhone:%@",__FUNCTION__, ccode, byCountry, self, outPhone);
    return [outPhone autorelease];
}

- (NSString *)localizedPhonenumberExt
{
    // 字串長度防護，避免不必要的問題。
    if ([self length] >= _kMAXLENGTH) return self;
    
    static NSMutableDictionary *map = nil;
    if (!map) {
        map = [[NSMutableDictionary alloc] init];
        
        for (int i = 0 ; i < g_ccode_map_count; ++i) {
            _CCITEM ccItm = g_ccode_map[i];
            [map setObject:__NUM(ccItm.countryID) forKey:ccItm.countryCode];
        }
    }
    
    // query map    
    unsigned short input[_kMAXBUFFER] = {0}, output[_kMAXBUFFER] = {0}, output2[_kMAXBUFFER] = {0};
    
    [self getCharacters:input];
    CutExtension(input, output, output2);
    
    int len = 0;
    for (; output[len]; ++len) { /*no-op*/ }
    NSString *outPhone = [[NSString alloc] initWithCharacters:output length:len];
    len = 0;
    for (; output2[len]; ++len) { /*no-op*/ }
    NSString *outExt = [[NSString alloc] initWithCharacters:output2 length:len];
    NSString *outputString;
    if(len>0)
        outputString = [outPhone stringByAppendingFormat:@",%@",outExt];
    else
        outputString = [outPhone stringByAppendingFormat:@""];
    [outExt release];
    [outPhone release];
    //NSLog(@"%s ccode:%@ byCountryCode:%d inputPhone:%@ outputPhone:%@",__FUNCTION__, ccode, byCountry, self, outPhone);
    return outputString;
}

- (NSString *)localizedPhonenumberExtWithCountryCode:(NSString *)CountryCode
{
    // 字串長度防護，避免不必要的問題。
    if ([self length] >= _kMAXLENGTH) return self;
    
    static NSMutableDictionary *map = nil;
    if (!map) {
        map = [[NSMutableDictionary alloc] init];
        
        for (int i = 0 ; i < g_ccode_map_count; ++i) {
            _CCITEM ccItm = g_ccode_map[i];
            [map setObject:__NUM(ccItm.countryID) forKey:ccItm.countryCode];
        }
    }
    
    // query map
    //NSString *ccode = [[[NSLocale currentLocale] objectForKey:NSLocaleCountryCode] lowercaseString];
    NSNumber *ccIDNum = [map objectForKey:CountryCode];
    
    unsigned short byCountry = CCODE_NO_COUNTRY;
    if (ccIDNum != nil)
        byCountry = [ccIDNum unsignedShortValue];
    
    unsigned short input[_kMAXBUFFER] = {0}, output[_kMAXBUFFER] = {0};
    
    [self getCharacters:input];
    CutPhoneNumber_Plus(input, output, byCountry,YES);
    
    int len = 0;
    for (; output[len]; ++len) { /*no-op*/ }
    NSString *outPhone = [[NSString alloc] initWithCharacters:output length:len];
    
    //NSLog(@"%s ccode:%@ byCountryCode:%d inputPhone:%@ outputPhone:%@",__FUNCTION__, ccode, byCountry, self, outPhone);
    return [outPhone autorelease];
}


@end
