//
//  WCWLSXDataController.m
//  Pods
//
//  Created by sanhue on 2016/5/20.
//
//

#import "WCXLSXDataController.h"

#import "NSError+Custom.h"
#import "WCFieldLabelString.h"
#import "NSDate+Format.h"
#import "xlsxwriter.h"
#import "NSString+Additions.h"
#import "WCFieldLabelString.h"

// Define
#import "WCXLSXDataController+ParameterDefine.h"
#import "WCXLSXDataController+ResourceDefine.h"

// Controller
#import "PPCountryCodeConvert.h"
#import "PPSystemInfoController.h"
#import "PPWorldcardAddressController.h"
#import "WCDisplayNameController.h"

static BOOL g_ShouldShowNamePhonetic = NO;
static BOOL g_ShouldShowCompanyPhonetic = NO;
static BOOL g_ExportFullAddressOnly = YES;

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString * const WCXLSXDC_GoogleGroupName_MyContact = @"My Contacts(Gmail)";
NSString * const WCXLSXDC_GoogleGroupName_Friends = @"Friends(Gmail)";
NSString * const WCXLSXDC_GoogleGroupName_Family = @"Family(Gmail)";
NSString * const WCXLSXDC_GoogleGroupName_Coworkers = @"Coworkers(Gmail)";

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCXLSXDataController ()
@property (nonatomic, assign) id<WCXLSXDataControllerDelegate> delegate;
@property (nonatomic, assign) NSInteger writtenCount;
@property (nonatomic, retain) NSArray *writeCardIDs;
@property (nonatomic, retain) NSArray *csvDatas;

@property (nonatomic, retain) NSMutableDictionary *columnMaxLength;

#pragma mark property
@property (nonatomic, assign) double maxColumnWidth;

@property (nonatomic, assign) BOOL showNamePhonetic;
@property (nonatomic, assign) BOOL showCompanyPhonetic;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCXLSXDataController


//==============================================================================
//
//==============================================================================
- (instancetype)initWithDelegate:(id<WCXLSXDataControllerDelegate>)delegate
{
    if(self = [super init])
    {
        // 最大欄位寬度，約等於字數
        self.maxColumnWidth =  100.0;
        //////////////////////////////////////////////////
        self.delegate = delegate;
        
        self.columnMaxLength = [NSMutableDictionary dictionary];
        
        //////////////////////////////////////////////////
        self.showNamePhonetic = g_ShouldShowNamePhonetic;
        self.showCompanyPhonetic = g_ShouldShowCompanyPhonetic;
        
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.delegate = nil;
    self.writeCardIDs = nil;
    self.csvDatas = nil;
    self.columnMaxLength = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare data

//================================================================================
//
//================================================================================
- (NSArray *)copyGroupNamesWithCardModel:(WCCardModel *)cardModel
{
    NSMutableArray *groupNames = [[NSMutableArray alloc] init];
    
    for(NSString *groupIDString in cardModel.groupIDArray)
    {
        WC_GroupID groupID = [groupIDString integerValue];
        NSString *groupName = nil;
        
        switch (groupID)
        {
            case WC_GID_Unfiled:
                // 未分類不處理
                break;
                
            case WC_GID_Google_MyContacts:
            {
                groupName = WCXLSXDC_GoogleGroupName_MyContact;
                [groupNames addObject:groupName];
                break;
            }
                
            case WC_GID_Google_Friends:
            {
                groupName = WCXLSXDC_GoogleGroupName_Friends;
                [groupNames addObject:groupName];
                break;
            }
                
            case WC_GID_Google_Family:
            {
                groupName = WCXLSXDC_GoogleGroupName_Family;
                [groupNames addObject:groupName];
                break;
            }
                
            case WC_GID_Google_Coworkers:
            {
                groupName = WCXLSXDC_GoogleGroupName_Coworkers;
                [groupNames addObject:groupName];
                break;
            }
                
            default:
            {
                groupName = [self.delegate xlsxDataContrller:self groupNameToWriteWithGroupID:groupID];
                
                if([groupName length] > 0)
                {
                    [groupNames addObject:groupName];
                }
                
                break;
            }
        }
    }
    
    if([groupNames count] == 0)
    {
        [groupNames release];
        groupNames = nil;
    }
    
    return groupNames;
}

//==============================================================================
//
//==============================================================================
- (NSArray *)copyTitleArrayForWriter
{
    NSMutableArray *resultArray = [NSMutableArray array];
    [resultArray addObject:[WCFieldLabelString labelStringWithType:WC_FT_Name]];
    if(self.showNamePhonetic)
    {
        [resultArray addObject:[WCFieldLabelString labelStringWithType:WC_FST2_Name_FirstPhonetic]];
    }
    
    [resultArray addObject:[[WCFieldLabelString labelStringWithType:WC_FT_Name] stringByAppendingString:@" 2"]];
    if(self.showNamePhonetic)
    {
        [resultArray addObject:[[WCFieldLabelString labelStringWithType:WC_FST2_Name_FirstPhonetic] stringByAppendingString:@" 2"]];
    }
    
    //////////////////////////////////////////////////
    
    [resultArray addObject:[WCFieldLabelString labelStringWithType:WC_FST2_Company_Name]];
    if(self.showCompanyPhonetic)
    {
        [resultArray addObject:[WCFieldLabelString labelStringWithType:WC_FST2_Company_Phonetic]];
    }
    
    [resultArray addObject:[[WCFieldLabelString labelStringWithType:WC_FST2_Company_Name] stringByAppendingString:@" 2"]];
    if(self.showCompanyPhonetic)
    {
        [resultArray addObject:[[WCFieldLabelString labelStringWithType:WC_FST2_Company_Phonetic] stringByAppendingString:@" 2"]];
    }
    
    //////////////////////////////////////////////////
    
    if(g_ExportFullAddressOnly==YES)
    {
        [resultArray addObjectsFromArray:@[[WCFieldLabelString labelStringWithType:WC_FST2_Company_Department],
                                           [[WCFieldLabelString labelStringWithType:WC_FST2_Company_Department] stringByAppendingString:@" 2"],
                                           [WCFieldLabelString labelStringWithType:WC_FST2_Company_JobTitle],
                                           [[WCFieldLabelString labelStringWithType:WC_FST2_Company_JobTitle] stringByAppendingString:@" 2"],
                                           [WCFieldLabelString labelStringWithType:WC_FST1_Phone_Work],
                                           [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_Work] stringByAppendingString:@" 2"],
                                           [WCFieldLabelString labelStringWithType:WC_FST1_Phone_WorkFax],
                                           [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_WorkFax] stringByAppendingString:@" 2"],
                                           [WCFieldLabelString labelStringWithType:WC_FST1_Phone_Mobile],
                                           [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_Mobile] stringByAppendingString:@" 2"],
                                       
                                           [[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]],
                                           
                                           [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:@" 2"],
                                           
                                           [[WCFieldLabelString labelStringWithType:WC_FST1_Email_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Email]],
                                           [[WCFieldLabelString labelStringWithType:WC_FST1_URL_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_URL]],
                                           WCXLSXDC_MLS_Group]];
    }
    else
    {
        // 語系為簡中，要分出6個
        if([PPSystemInfoController language]==PPSystemInfoLanguage_ChineseSimplified)
        {
            [resultArray addObjectsFromArray:@[[WCFieldLabelString labelStringWithType:WC_FST2_Company_Department],
                                               [[WCFieldLabelString labelStringWithType:WC_FST2_Company_Department] stringByAppendingString:@" 2"],
                                               [WCFieldLabelString labelStringWithType:WC_FST2_Company_JobTitle],
                                               [[WCFieldLabelString labelStringWithType:WC_FST2_Company_JobTitle] stringByAppendingString:@" 2"],
                                               [WCFieldLabelString labelStringWithType:WC_FST1_Phone_Work],
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_Work] stringByAppendingString:@" 2"],
                                               [WCFieldLabelString labelStringWithType:WC_FST1_Phone_WorkFax],
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_WorkFax] stringByAppendingString:@" 2"],
                                               [WCFieldLabelString labelStringWithType:WC_FST1_Phone_Mobile],
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_Mobile] stringByAppendingString:@" 2"],
                                               
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_Street]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",WCXLSXDC_MLS_District]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_City]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_State]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_ZIP]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_Country]]],
                                               
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:@" 2"],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_Street]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",WCXLSXDC_MLS_District]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_City]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_State]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_ZIP]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_Country]]],

                                               
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Email_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Email]],
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_URL_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_URL]],
                                               WCXLSXDC_MLS_Group]];
        }
        else
        {
            [resultArray addObjectsFromArray:@[[WCFieldLabelString labelStringWithType:WC_FST2_Company_Department],
                                               [[WCFieldLabelString labelStringWithType:WC_FST2_Company_Department] stringByAppendingString:@" 2"],
                                               [WCFieldLabelString labelStringWithType:WC_FST2_Company_JobTitle],
                                               [[WCFieldLabelString labelStringWithType:WC_FST2_Company_JobTitle] stringByAppendingString:@" 2"],
                                               [WCFieldLabelString labelStringWithType:WC_FST1_Phone_Work],
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_Work] stringByAppendingString:@" 2"],
                                               [WCFieldLabelString labelStringWithType:WC_FST1_Phone_WorkFax],
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_WorkFax] stringByAppendingString:@" 2"],
                                               [WCFieldLabelString labelStringWithType:WC_FST1_Phone_Mobile],
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Phone_Mobile] stringByAppendingString:@" 2"],
                                               
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_Street]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_City]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_State]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_ZIP]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@"-(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_Country]]],
                                               
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:@" 2"],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_Street]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_City]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_State]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_ZIP]]],
                                               [[[WCFieldLabelString labelStringWithType:WC_FST1_Address_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Address]] stringByAppendingString:[NSString stringWithFormat:@" 2 -(%@)",[WCFieldLabelString labelStringWithType:WC_FST2_Address_Country]]],
                                               
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_Email_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_Email]],
                                               [[WCFieldLabelString labelStringWithType:WC_FST1_URL_Work] stringByAppendingString:[WCFieldLabelString labelStringWithType:WC_FT_URL]],
                                               WCXLSXDC_MLS_Group]];
        }
    }
    
    return [resultArray retain];
}


//==============================================================================
//
//==============================================================================
- (void)addEmptyWithCount:(NSInteger)emptyCount toArray:(NSMutableArray *)array
{
    for (NSInteger count = 0; count < emptyCount; count++)
    {
        [array addObject:@""];
    }
}


//==============================================================================
//
//==============================================================================
- (NSString *)fieldTypeDataFromArray:(NSArray *)array withObject:(NSObject *)object index:(NSInteger)index addEmptyIfNotFound:(BOOL)addEmptyIfNotFound
{
    NSString *result = nil;
    
    if ([object isKindOfClass:[NSNumber class]])
    {
        BOOL match = NO;
        NSInteger currentIndex = 0;
        
        if ([array count]<=index)
        {
            if (addEmptyIfNotFound)
            {
                result = @"";
            }
            return result;
        }
        
        // 找到符合的第一個
        for (WCFieldModel *fieldModel in array)
        {
            if(currentIndex==index)
            {
                match = YES;
                result = [NSString stringWithString:fieldModel.value];
                break;
            }
            currentIndex++;
        }
        
        if (match==NO)
        {
            if (addEmptyIfNotFound)
            {
                result = @"";
            }
        }
    }
    else
    {
        // 直接回傳
        result = (NSString *)object;
    }
    return result;
}


//================================================================================
// 從array中找到第一個符合指定的subtype1的資料，如果都沒有也要回傳空字串
// 如果是字串格式，直接回傳
// 如果都沒有符合，回傳nil
// @param array array of WCFieldModel
// @param object NSNumber of WCSubType1, or string
// @param index index of target at array
// @param addEmptyIfNotFound YES, return @"" when not found, else return nil
//================================================================================
- (NSString *)subType1DataFromArray:(NSArray *)array withObject:(NSObject *)object index:(NSInteger)index addEmptyIfNotFound:(BOOL)addEmptyIfNotFound
{
    NSString *result = nil;
    
    if ([object isKindOfClass:[NSNumber class]])
    {
        BOOL match = NO;
        NSInteger currentIndex = 0;
        
        if ([array count]<=index)
        {
            if (addEmptyIfNotFound)
            {
                result = @"";
            }
            return result;
        }
        
        // 找到符合的第一個
        for (WCFieldModel *fieldModel in array)
        {
            if (fieldModel.subType1==[(NSNumber *)object integerValue])
            {
                if(currentIndex==index)
                {
                    match = YES;
                    
                    NSString *valueString = nil;
                    if ([fieldModel.value isKindOfClass:[NSDate class]])
                    {
                        valueString = [(NSDate *)fieldModel.value stringWithFormat:NSDateFormat_Day timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0]];
                    }
                    else
                    {
                        valueString = [NSString stringWithString:fieldModel.value];
                    }
                    result = valueString;
                    break;
                }
                currentIndex++;
            }
        }
        
        if (match==NO)
        {
            if (addEmptyIfNotFound)
            {
                result = @"";
            }
        }
    }
    else
    {
        // 直接回傳
        result = (NSString *)object;
    }
    return result;
}


//================================================================================
// 從fieldModel中找到第一個符合指定的subtype2的資料，如果都沒有也要回傳空字串
// 如果是字串格式，直接回傳object
// 如果都沒有符合，回傳nil
//================================================================================
- (NSString *)subType2DataFromArray:(NSArray *)array withObject:(NSObject *)object index:(NSInteger)index addEmptyIfNotFound:(BOOL)addEmptyIfNotFound
{
    NSString *result = nil;
    
    if ([object isKindOfClass:[NSNumber class]])
    {
        BOOL match = NO;
        NSInteger currentIndex = 0;
        
        if ([array count]<=index)
        {
            if (addEmptyIfNotFound)
            {
                result = @"";
            }
            return result;
        }
        
        // 找到符合的第一個
        for (WCFieldModel *fieldModel in array)
        {
            WC_FieldSubType2 fieldSubType2 = (WC_FieldSubType2)[(NSNumber*)object integerValue];
            
            if ([fieldModel hasFieldWithSubType2:fieldSubType2])
            {
                if(currentIndex==index)
                {
                    match = YES;
                    WCFieldModel * subFieldModel = [fieldModel fieldWithSubType2:fieldSubType2];
                    
                    NSString *valueString = nil;
                    if ([subFieldModel.value isKindOfClass:[NSDate class]])
                    {
                        valueString = [(NSDate *)subFieldModel.value stringWithFormat:NSDateFormat_Day timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0]];
                    }
                    else
                    {
                        valueString = [NSString stringWithString:subFieldModel.value];
                    }
                    result = valueString;
                    break;
                }
                currentIndex++;
            }
        }
        
        if (match==NO)
        {
            if (addEmptyIfNotFound)
            {
                result = @"";
            }
        }
    }
    else
    {
        // 直接回傳
        result = (NSString *)object;
    }
    return result;
}


//==============================================================================
// 加入登定subtyp1的地址資料，如果沒找到要補5個空字串
// 加果是字串，直接加入
//==============================================================================
- (BOOL)addAddressDataFromArray:(NSArray *)array withSubtype1:(NSObject *)subtype1 index:(NSInteger)index addEmptyIfNotFound:(BOOL)addEmptyIfNotFound reusltArray:(NSMutableArray *)resultArray fullAddressOnly:(BOOL)fullAddressOnly cardModel:(WCCardModel *)cardModel
{
    BOOL result = NO;
    
    if ([subtype1 isKindOfClass:[NSNumber class]])
    {
        BOOL match = NO;
        NSInteger currentIndex = 0;
        // 找到符合的第一個
        for (WCFieldModel *fieldModel in array)
        {
            if (fieldModel.subType1==[(NSNumber *)subtype1 integerValue])
            {
                if(currentIndex==index)
                {
                    match = YES;
                    result = YES;
                    
                    //////////////////////////////////////////////////
                    // 先加入完整地址
                    NSInteger bcrLanguage = [cardModel recognitionlanguageWithFieldSource:fieldModel.source];
                    NSString *fullAddress = [fieldModel stringDisplayAddressWithBCRLanguage:bcrLanguage];
                    
                    if ([fullAddress length])
                    {
                        [resultArray addObject:fullAddress];
                    }
                    
                    // 如果只要完整地址
                    if (fullAddressOnly)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    NSArray *subtype2Numbers = @[@(WC_FST2_Address_Street),
                                                 @(WC_FST2_Address_City),
                                                 @(WC_FST2_Address_State),
                                                 @(WC_FST2_Address_ZIP),
                                                 @(WC_FST2_Address_Country)];
                    
                    if([PPSystemInfoController language]==PPSystemInfoLanguage_ChineseSimplified)
                    {
                        subtype2Numbers = @[@(WC_FST2_Address_Street),
                                            @(WCXLSXDataControllerFieldType_AddressDistrict),
                                            @(WC_FST2_Address_City),
                                            @(WC_FST2_Address_State),
                                            @(WC_FST2_Address_ZIP),
                                            @(WC_FST2_Address_Country)];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    for (NSNumber *subtype2Number in subtype2Numbers)
                    {
                        WC_FieldSubType2 fieldSubType2 = (WC_FieldSubType2)[(NSNumber*)subtype2Number integerValue];
                        
                        if ([fieldModel hasFieldWithSubType2:fieldSubType2])
                        {
                            WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:fieldSubType2];
                            NSString *valueString = [NSString stringWithString:subFieldModel.value];
                            if ([valueString length]>0)
                            {
                                [resultArray addObject:valueString];
                            }
                            else
                            {
                                [resultArray addObject:@""];
                            }
                        }
                        else if(fieldSubType2==WCXLSXDataControllerFieldType_AddressDistrict)
                        {
                            // 區，拿街道名稱來爬
                            NSString *district = nil;
                            
                            WCFieldModel *streetFieldModel = [fieldModel fieldWithSubType2:WC_FST2_Address_Street];
                            
                            if([[streetFieldModel value] length]>0)
                            {
                                district = [[[streetFieldModel value] componentsSeparatedByString:WCXLSXDC_MLS_District] firstObject];
                                
                                district = [district stringByAppendingString:WCXLSXDC_MLS_District];
                            }
                            
                            //////////////////////////////////////////////////
                            
                            // 移除 City
                            
                            WCFieldModel *cityFieldModel = [fieldModel fieldWithSubType2:WC_FST2_Address_City];
                            
                            if([[cityFieldModel value] length]>0)
                            {
                                district =  [district stringByReplacingOccurrencesOfString:[cityFieldModel value]
                                                                                withString:@""];
                            }
                            
                            //////////////////////////////////////////////////
                            
                            if([district length]>0)
                            {
                                [resultArray addObject:district];
                            }
                            else
                            {
                                [resultArray addObject:@""];
                            }
                        }
                        // 國家欄位找不到，改用國別碼
                        else if(fieldSubType2==WC_FST2_Address_Country)
                        {
                            if ([fieldModel hasFieldWithSubType2:WC_FST2_Address_CountryCode])
                            {
                                WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:WC_FST2_Address_CountryCode];
                                
                                NSString *countryCode = subFieldModel.value;
                                NSString *countryLanguage = [fieldModel fieldWithSubType2:WC_FST2_Address_LanguageCode].value;
                                
                                NSString *valueString = ([countryLanguage length]>0)?[PPCountryCodeConvert localizeStringFromCountryCode:countryCode withLanguageCode:countryLanguage]:[PPCountryCodeConvert localizeStringFromCountryCode:countryCode];
                                
                                if ([valueString length]>0)
                                {
                                    [resultArray addObject:valueString];
                                }
                                else
                                {
                                    [resultArray addObject:@""];
                                }
                            }
                        }
                        else
                        {
                            [resultArray addObject:@""];
                        }
                    }
                    break;
                }
                
                currentIndex ++;
            }
        }
        
        if (match==NO)
        {
            if (addEmptyIfNotFound)
            {
                NSInteger emptyCount = 6;
                
                //////////////////////////////////////////////////
             
                if(fullAddressOnly)
                {
                    emptyCount= 1;
                }
                // 簡中地址會多一個欄位，所以這邊是7個空值
                else if([PPSystemInfoController language]==PPSystemInfoLanguage_ChineseSimplified)
                {
                    emptyCount = 7;
                }
                
                //////////////////////////////////////////////////

             
                [self addEmptyWithCount:emptyCount toArray:resultArray];
            }
        }
    }
    else
    {
        // 直接回傳
        [resultArray addObject:subtype1];
    }
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare title for note content


//==============================================================================
//
//==============================================================================
+ (NSString*)labelStringWithType:(NSInteger)fieldType
{
    switch (fieldType)
    {
        case WC_FT_Address:
        {
            return @"Address";
        }
        case WC_FT_Phone:
        {
            return @"Phone";
        }
        case WC_FT_Email:
        {
            return @"Email";
        }
        case WC_FT_URL:
        {
            return @"URL";
        }
        case WC_FT_InstantMessage:
        {
            return @"InstantMessage";
        }
        case WC_FT_Date:
        {
            return @"Date";
        }
        case WC_FT_Note:
        {
            return @"Note";
        }
        case WC_FT_Nickname:
        {
            return @"Nickname";
        }
        case WC_FT_UnifiedBusinessNo:
        {
            return @"UnifiledBusinessNo";
        }
            //////////////////////////////////////////////////
            // subType1
        case WC_FST1_Address_Work:
        {
            return @"Work";
        }
        case WC_FST1_Address_Home:
        {
            return @"Home";
        }
        case WC_FST1_Address_Other:
        {
            return @"Other";
        }
        case WC_FST1_Phone_Work:
        {
            return @"Work";
        }
        case WC_FST1_Phone_Home:
        {
            return @"Home";
        }
        case WC_FST1_Phone_Mobile:
        {
            return @"Mobile";
        }
        case WC_FST1_Phone_Main:
        {
            return @"Main";
        }
        case WC_FST1_Phone_WorkFax:
        {
            return @"WorkFax";
        }
        case WC_FST1_Phone_HomeFax:
        {
            return @"HomeFax";
        }
        case WC_FST1_Phone_Pager:
        {
            return @"Pager";
        }
        case WC_FST1_Phone_GoogleVoice:
        {
            return @"GoogleVoice";
        }
        case WC_FST1_Phone_iPhone:
        {
            return @"iPhone";
        }
        case WC_FST1_Phone_Other:
        {
            return @"Other";
        }
        case WC_FST1_Email_Work:
        {
            return @"Work";
        }
        case WC_FST1_Email_Home:
        {
            return @"Home";
        }
        case WC_FST1_Email_Other:
        {
            return @"Other";
        }
            
        case WC_FST1_URL_HomePage:
        {
            return @"HomePage";
        }
        case WC_FST1_URL_Work:
        {
            return @"Work";
        }
        case WC_FST1_URL_Home:
        {
            return @"Home";
        }
        case WC_FST1_URL_Profile:
        {
            return @"Profile";
        }
        case WC_FST1_URL_Blog:
        {
            return @"Blog";
        }
        case WC_FST1_URL_Other:
        {
            return @"Other";
        }
            
        case WC_FST1_IM_MSN:
        {
            return @"MSN";
        }
        case WC_FST1_IM_Skype:
        {
            return @"Skype";
        }
        case WC_FST1_IM_QQ:
        {
            return @"QQ";
        }
        case WC_FST1_IM_Yahoo:
        {
            return @"Yahoo";
        }
        case WC_FST1_IM_ICQ:
        {
            return @"ICQ";
        }
        case WC_FST1_IM_GoogleTalk:
        {
            return @"GoogleTalk";
        }
        case WC_FST1_IM_Jabber:
        {
            return @"Jabber";
        }
        case WC_FST1_IM_AIM:
        {
            return @"AIM";
        }
        case WC_FST1_IM_Other:
        {
            return @"Other";
        }
            
        case WC_FST1_SN_Twitter:
        {
            return @"Twitter";
        }
        case WC_FST1_SN_Facebook:
        {
            return @"Facebook";
        }
        case WC_FST1_SN_Flicker:
        {
            return @"Flicker";
        }
        case WC_FST1_SN_LinkedIn:
        {
            return @"LinkedIn";
        }
        case WC_FST1_SN_MySpace:
        {
            return @"MySpace";
        }
        case WC_FST1_SN_SinaWebo:
        {
            return @"SinaWebo";
        }
        case WC_FST1_SN_Other:
        {
            return @"Other";
        }
            
        case WC_FST1_Date_Birthday:
        {
            return @"Birthday";
        }
        case WC_FST1_Date_Anniversary:
        {
            return @"Anniversary";
        }
        case WC_FST1_Date_Other:
        {
            return @"Other";
        }
            
            //////////////////////////////////////////////////
            // subtype2
        case WC_FST2_Name_First:
        {
            return @"First";
        }
        case WC_FST2_Name_FirstPhonetic:
        {
            return @"First Phonetic";
        }
        case WC_FST2_Name_Last:
        {
            return @"Last";
        }
        case WC_FST2_Name_LastPhonetic:
        {
            return @"Last Phonetic";
        }
        case WC_FST2_Name_Middle:
        {
            return @"Middle";
        }
        case WC_FST2_Name_Prefix:
        {
            return @"Prefix";
        }
        case WC_FST2_Name_Suffix:
        {
            return @"Suffix";
        }
            
        case WC_FST2_Company_Name:
        {
            return @"Company";
        }
        case WC_FST2_Company_Phonetic:
        {
            return @"Company Phonetic";
        }
        case WC_FST2_Company_Department:
        {
            return @"Department";
        }
        case WC_FST2_Company_JobTitle:
        {
            return @"Job Title";
        }
        case WC_FST2_Address_Street:
        {
            return @" - Street";
        }
        case WC_FST2_Address_City:
        {
            return @" - City";
        }
        case WC_FST2_Address_State:
        {
            return @" - State";
        }
        case WC_FST2_Address_ZIP:
        {
            return @" - ZIP";
        }
        case WC_FST2_Address_Country:
        {
            return @" - Country";
        }
            
            
            
        default:
            break;
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSString *)fieldDisplayTitleWithFieldModel:(WCFieldModel *)fieldModel
{
    NSMutableString *fieldDisplayTitle = [NSMutableString string];
    
    NSString *labelString = [WCXLSXDataController labelStringWithType:fieldModel.type];
    if([labelString length])
    {
        [fieldDisplayTitle appendString:labelString];
    }
    
    labelString = [WCXLSXDataController labelStringWithType:fieldModel.subType2];
    if([labelString length])
    {
        [fieldDisplayTitle appendString:labelString];
    }
    
    labelString = [WCXLSXDataController labelStringWithType:fieldModel.subType1];
    if([labelString length])
    {
        [fieldDisplayTitle appendFormat:@" (%@)",labelString];
    }
    
    
    return fieldDisplayTitle;
}


//================================================================================
//
//================================================================================
- (NSString *)fieldTypeNoteStringFromArray:(NSArray *)array withObject:(NSNumber *)object startIndex:(NSInteger)startIndex
{
    NSString *result = nil;
    NSMutableString *tempString = [NSMutableString string];
    
    NSInteger currentIndex = 0;
    
    if ([array count]<=startIndex)
    {
        return result;
    }
    
    // 找到符合的第一個
    for (WCFieldModel *fieldModel in array)
    {
        if(currentIndex>=startIndex)
        {
            NSString *fieldDisplayTitle = [self fieldDisplayTitleWithFieldModel:fieldModel];
            NSString *fieldValue = fieldModel.value;
            
            if([fieldDisplayTitle length] &&
               [fieldValue length])
            {
                if([tempString length])
                {
                    [tempString appendString:@"\n"];
                }
                
                [tempString appendFormat:@"%@ : %@", fieldDisplayTitle, fieldValue];
            }
        }
        currentIndex++;
        
    }
    
    
    return [tempString length]>0?[NSString stringWithString:tempString]:nil;
}


//================================================================================
//
//================================================================================
- (NSString *)subType1NoteStringFromArray:(NSArray *)array withObject:(NSNumber *)object startIndex:(NSInteger)startIndex
{
    NSString *result = nil;
    NSMutableString *tempString = [NSMutableString string];
    
    NSInteger currentIndex = 0;
    
    if ([array count]<=startIndex)
    {
        return result;
    }
    
    // 找到符合的第一個
    for (WCFieldModel *fieldModel in array)
    {
        if (fieldModel.subType1==[(NSNumber *)object integerValue])
        {
            if(currentIndex>=startIndex)
            {
                NSString *fieldDisplayTitle = [self fieldDisplayTitleWithFieldModel:fieldModel];
                NSString *fieldValue = fieldModel.value;
                
                if([fieldDisplayTitle length] &&
                   [fieldValue length])
                {
                    if([tempString length])
                    {
                        [tempString appendString:@"\n"];
                    }
                    
                    [tempString appendFormat:@"%@ : %@", fieldDisplayTitle, fieldValue];
                }
            }
            currentIndex++;
        }
    }
    
    
    return [tempString length]>0?[NSString stringWithString:tempString]:nil;
}


//================================================================================
// 回傳在note中的顯示title
// 如果都沒有符合，回傳nil
//================================================================================
- (NSString *)subType2NoteStringFromArray:(NSArray *)array withObject:(NSNumber *)object startIndex:(NSInteger)startIndex
{
    NSString *result = nil;
    NSMutableString *tempString = [NSMutableString string];
    
    NSInteger currentIndex = 0;
    
    if ([array count]<=startIndex)
    {
        return result;
    }
    
    // 找到符合的第一個
    for (WCFieldModel *fieldModel in array)
    {
        WC_FieldSubType2 fieldSubType2 = (WC_FieldSubType2)[(NSNumber*)object integerValue];
        if ([fieldModel hasFieldWithSubType2:fieldSubType2])
        {
            if(currentIndex>=startIndex)
            {
                WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:fieldSubType2];
                
                NSString *fieldDisplayTitle = [self fieldDisplayTitleWithFieldModel:subFieldModel];
                NSString *fieldValue = subFieldModel.value;
                
                if([fieldDisplayTitle length] &&
                   [fieldValue length])
                {
                    if([tempString length])
                    {
                        [tempString appendString:@"\n"];
                    }
                    
                    [tempString appendFormat:@"%@ : %@", fieldDisplayTitle, fieldValue];
                }
            }
            currentIndex++;
        }
    }
    
    
    return [tempString length]>0?[NSString stringWithString:tempString]:nil;
}


//================================================================================

//================================================================================
- (NSString *)addressNoteStringFromArray:(NSArray *)array withObject:(NSNumber *)object startIndex:(NSInteger)startIndex fullAddressOnly:(BOOL)fullAddressOnly cardModel:(WCCardModel *)cardModel
{
    NSString *result = nil;
    NSMutableString *tempString = [NSMutableString string];
    NSInteger currentIndex = 0;
    
    if ([array count]<=startIndex)
    {
        return result;
    }
    
    // 找到符合的第一個
    for (WCFieldModel *fieldModel in array)
    {
        if (fieldModel.subType1==[(NSNumber *)object integerValue])
        {
            if(currentIndex>=startIndex)
            {
                //////////////////////////////////////////////////
                // 先加入完整地址
                NSInteger bcrLanguage = [cardModel recognitionlanguageWithFieldSource:fieldModel.source];
                NSString *fullAddress = [fieldModel stringDisplayAddressWithBCRLanguage:bcrLanguage];
                
                if ([fullAddress length])
                {
                    if([tempString length])
                    {
                        [tempString appendString:@"\n"];
                    }
                    [tempString appendFormat:@"%@ : %@", [self fieldDisplayTitleWithFieldModel:fieldModel], fullAddress];
                }
                
                if(fullAddressOnly)
                {
                    continue;
                }
                //////////////////////////////////////////////////
                NSArray *subtype2Numbers = @[@(WC_FST2_Address_Street),
                                             @(WC_FST2_Address_City),
                                             @(WC_FST2_Address_State),
                                             @(WC_FST2_Address_ZIP),
                                             @(WC_FST2_Address_Country)];
                
                for (NSNumber *subtype2Number in subtype2Numbers)
                {
                    WC_FieldSubType2 fieldSubType2 = (WC_FieldSubType2)[(NSNumber*)subtype2Number integerValue];
                    if ([fieldModel hasFieldWithSubType2:fieldSubType2])
                    {
                        WCFieldModel *subFieldModel = [fieldModel fieldWithSubType2:fieldSubType2];
                        NSString *fieldDisplayTitle = [self fieldDisplayTitleWithFieldModel:subFieldModel];
                        NSString *fieldValue = subFieldModel.value;
                        
                        if([fieldDisplayTitle length] &&
                           [fieldValue length])
                        {
                            if([tempString length])
                            {
                                [tempString appendString:@"\n"];
                            }
                            
                            [tempString appendFormat:@"%@ : %@", fieldDisplayTitle, fieldValue];
                        }
                    }
                }
            }
            currentIndex++;
        }
    }
    
    return [tempString length]>0?[NSString stringWithString:tempString]:nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare dataArray methods


//==============================================================================
// 沒有 subtype1, subtype2的人用的
//==============================================================================
- (void)addFieldTypeDataFromArray:(NSArray *)array orderFieldArray:(NSArray *)orderFieldArray reusltArrar:(NSMutableArray *)resultArray additionalNote:(NSMutableString *)additionalNote
{
    NSInteger index = 0;
    NSInteger fieldArrayIndex = 0;
    NSNumber *lastFieldNumber = nil;
    
    for (NSNumber *fieldOrderNumber in orderFieldArray)
    {
        // 與上次不一樣
        if([fieldOrderNumber isEqual:lastFieldNumber]==NO)
        {
            lastFieldNumber = fieldOrderNumber;
            index = 0;
        }
        else
        {
            index ++;
        }
        
        [resultArray addObject:[self fieldTypeDataFromArray:array withObject:fieldOrderNumber index:index addEmptyIfNotFound:YES]];
        //////////////////////////////////////////////////
        // 沒有 additionalNote 就不用處理
        if (additionalNote==nil)
        {
            continue;
        }
        
        // 預讀下一個，如果不同，，先把原本的type的內容先記錄完
        NSString *nextOrderNumber = nil;
        if (fieldArrayIndex+1<[orderFieldArray count])
        {
            nextOrderNumber = [orderFieldArray objectAtIndex:fieldArrayIndex+1];
        }
        
        if([fieldOrderNumber isEqual:nextOrderNumber]==NO)
        {
            // 從下一個開始
            index ++;
            
            NSString * noteString = [self fieldTypeNoteStringFromArray:array withObject:lastFieldNumber startIndex:index];
            if([noteString length])
            {
                if ([additionalNote length]>0)
                {
                    [additionalNote appendString:@"\n"];
                }
                
                [additionalNote appendString:noteString];
            }
        }
        
        fieldArrayIndex ++;
    }
}



//==============================================================================
// phone, url, email, im, date,
//==============================================================================
- (void)addSubType1DataFromArray:(NSArray *)array orderFieldArray:(NSArray *)orderFieldArray reusltArrar:(NSMutableArray *)resultArray additionalNote:(NSMutableString *)additionalNote
{
    NSInteger index = 0;
    NSInteger fieldArrayIndex = 0;
    NSNumber *lastFieldNumber = nil;
    
    for (NSNumber *fieldOrderNumber in orderFieldArray)
    {
        // 與上次不一樣
        if([fieldOrderNumber isEqual:lastFieldNumber]==NO)
        {
            lastFieldNumber = fieldOrderNumber;
            index = 0;
        }
        else
        {
            index ++;
        }
        
        [resultArray addObject:[self subType1DataFromArray:array withObject:fieldOrderNumber index:index addEmptyIfNotFound:YES]];
        
        //////////////////////////////////////////////////
        // 沒有 additionalNote 就不用處理
        if (additionalNote==nil)
        {
            continue;
        }
        
        // 預讀下一個，如果不同，，先把原本的type的內容先記錄完
        NSString *nextOrderNumber = nil;
        if (fieldArrayIndex+1<[orderFieldArray count])
        {
            nextOrderNumber = [orderFieldArray objectAtIndex:fieldArrayIndex+1];
        }
        
        if([fieldOrderNumber isEqual:nextOrderNumber]==NO)
        {
            // 從下一個開始
            index ++;
            
            NSString * noteString = [self subType1NoteStringFromArray:array withObject:lastFieldNumber startIndex:index];
            if([noteString length])
            {
                if ([additionalNote length]>0)
                {
                    [additionalNote appendString:@"\n"];
                }
                
                [additionalNote appendString:noteString];
            }
        }
        
        fieldArrayIndex ++;
    }
}


//==============================================================================
// name, company使用
//==============================================================================
- (void)addSubType2DataFromArray:(NSArray *)array orderFieldArray:(NSArray *)orderFieldArray reusltArrar:(NSMutableArray *)resultArray additionalNote:(NSMutableString *)additionalNote
{
    NSInteger index = 0;
    NSInteger fieldArrayIndex = 0;
    NSNumber *lastFieldNumber = nil;
    
    for (NSNumber *fieldOrderNumber in orderFieldArray)
    {
        // 與上次不一樣
        if([fieldOrderNumber isEqual:lastFieldNumber]==NO)
        {
            lastFieldNumber = fieldOrderNumber;
            index = 0;
        }
        else
        {
            index ++;
        }
        
        [resultArray addObject:[self subType2DataFromArray:array withObject:fieldOrderNumber index:index addEmptyIfNotFound:YES]];
        
        // 如果要包含姓名讀音
        if(self.showNamePhonetic)
        {
            if ([fieldOrderNumber integerValue]==WC_FT_Name)
            {
                NSString *firstNamePhonetic = [self subType2DataFromArray:array withObject:@(WC_FST2_Name_FirstPhonetic) index:index addEmptyIfNotFound:YES];
                NSString *lastNamePhonetic = [self subType2DataFromArray:array withObject:@(WC_FST2_Name_LastPhonetic) index:index addEmptyIfNotFound:YES];
                
                // 有讀音一定是日韓
                [resultArray addObject:[WCDisplayNameController displayNameWithFirstName:firstNamePhonetic lastName:lastNamePhonetic isEasternName:YES eastOrder:WCDisplayNameOrder_LastFirst westOrder:WCDisplayNameOrder_LastFirst]];
            }
            else if ([fieldOrderNumber integerValue]==WC_FST2_Name_First)
            {
                [resultArray addObject:[self subType2DataFromArray:array withObject:@(WC_FST2_Name_FirstPhonetic) index:index addEmptyIfNotFound:YES]];
            }
            else if ([fieldOrderNumber integerValue]==WC_FST2_Name_Last)
            {
                [resultArray addObject:[self subType2DataFromArray:array withObject:@(WC_FST2_Name_LastPhonetic) index:index addEmptyIfNotFound:YES]];
            }
        }
        
        // 如果要包含公司
        if (self.showCompanyPhonetic && [fieldOrderNumber integerValue]==WC_FST2_Company_Name)
        {
            [resultArray addObject:[self subType2DataFromArray:array withObject:@(WC_FST2_Company_Phonetic) index:index addEmptyIfNotFound:YES]];
        }
        
        //////////////////////////////////////////////////
        // 沒有 additionalNote 就不用處理
        if (additionalNote==nil)
        {
            continue;
        }
        
        // 預讀下一個，如果不同，，先把原本的type的內容先記錄完
        NSString *nextOrderNumber = nil;
        if (fieldArrayIndex+1<[orderFieldArray count])
        {
            nextOrderNumber = [orderFieldArray objectAtIndex:fieldArrayIndex+1];
        }
        
        if([fieldOrderNumber isEqual:nextOrderNumber]==NO)
        {
            // 從下一個開始
            index ++;
            
            NSString * noteString = [self subType2NoteStringFromArray:array withObject:lastFieldNumber startIndex:index];
            if([noteString length])
            {
                if ([additionalNote length]>0)
                {
                    [additionalNote appendString:@"\n"];
                }
                
                [additionalNote appendString:noteString];
            }
        }
        
        fieldArrayIndex ++;
    }
}


//==============================================================================
// 加入登定subtyp1的地址資料，如果沒找到要補5個空字串
// 加果是字串，直接加入
//==============================================================================
- (void)addAddressDataFromArray:(NSArray *)array orderFieldArray:(NSArray *)orderFieldArray reusltArray:(NSMutableArray *)resultArray additionalNote:(NSMutableString *)additionalNote fullAddressOnly:(BOOL)fullAddressOnly cardModel:(WCCardModel *)cardModel
{
    NSInteger index = 0;
    NSInteger fieldArrayIndex = 0;
    NSNumber *lastFieldNumber = nil;
    
    for (NSNumber *fieldOrderNumber in orderFieldArray)
    {
        // 與上次不一樣
        if([fieldOrderNumber isEqual:lastFieldNumber]==NO)
        {
            lastFieldNumber = fieldOrderNumber;
            index = 0;
        }
        else
        {
            index ++;
        }
        
        [self addAddressDataFromArray:array withSubtype1:fieldOrderNumber index:index addEmptyIfNotFound:YES reusltArray:resultArray fullAddressOnly:fullAddressOnly cardModel:cardModel];
        
        //////////////////////////////////////////////////
        // 沒有 additionalNote 就不用處理
        if (additionalNote==nil)
        {
            continue;
        }
        
        // 預讀下一個，如果不同，，先把原本的type的內容先記錄完
        NSString *nextOrderNumber = nil;
        if (fieldArrayIndex+1<[orderFieldArray count])
        {
            nextOrderNumber = [orderFieldArray objectAtIndex:fieldArrayIndex+1];
        }
        
        if([fieldOrderNumber isEqual:nextOrderNumber]==NO)
        {
            // 從下一個開始
            index ++;
            
            NSString * noteString = [self addressNoteStringFromArray:array withObject:lastFieldNumber startIndex:index fullAddressOnly:fullAddressOnly cardModel:cardModel];
            if([noteString length])
            {
                if ([additionalNote length]>0)
                {
                    [additionalNote appendString:@"\n"];
                }
                
                [additionalNote appendString:noteString];
            }
        }
        
        fieldArrayIndex ++;
    }
}


//==============================================================================
// 順序要跟title array一致
//==============================================================================
- (NSArray *)dataArrayFromCardModel:(WCCardModel *)cardModel
{
    if (cardModel==nil)
    {
        return nil;
    }
    
    NSArray *fieldArray = nil;
    NSMutableString *additionalNote = nil;
    
    NSMutableArray *dataArray = [NSMutableArray array];
    
    //////////////////////////////////////////////////
    // Name (2) - @"Full Name", @"Full Name 2"
    
    fieldArray = @[@(WC_FT_Name),
                   @(WC_FT_Name)];
    
    NSArray *nameFieldArray = [cardModel fieldArrayWithType:WC_FT_Name];
    [self addSubType2DataFromArray:nameFieldArray orderFieldArray:fieldArray reusltArrar:dataArray additionalNote:additionalNote];
    
    //////////////////////////////////////////////////
    // Company (6) - @"Company", @"Company 2", @"Department", @"Department 2",  @"Job Title",  @"Job Title 2",
    
    fieldArray = @[@(WC_FST2_Company_Name),
                   @(WC_FST2_Company_Name),
                   @(WC_FST2_Company_Department),
                   @(WC_FST2_Company_Department),
                   @(WC_FST2_Company_JobTitle),
                   @(WC_FST2_Company_JobTitle)];
    
    NSArray *companyFieldArray = [cardModel fieldArrayWithType:WC_FT_Company];
    [self addSubType2DataFromArray:companyFieldArray orderFieldArray:fieldArray reusltArrar:dataArray additionalNote:additionalNote];
    
    //////////////////////////////////////////////////
    // Phone (6) - @"Office TEL", @"Office TEL 2", @"Office FAX", @"Office FAX 2", @"Mobile TEL", @"Mobile TEL 2",
    fieldArray = @[@(WC_FST1_Phone_Work),
                   @(WC_FST1_Phone_Work),
                   @(WC_FST1_Phone_WorkFax),
                   @(WC_FST1_Phone_WorkFax),
                   @(WC_FST1_Phone_Mobile),
                   @(WC_FST1_Phone_Mobile)];
    
    NSArray *phoneArray = [cardModel fieldArrayWithType:WC_FT_Phone];
    
    [self addSubType1DataFromArray:phoneArray orderFieldArray:fieldArray reusltArrar:dataArray additionalNote:additionalNote];
    
    //////////////////////////////////////////////////
    // Address (2) -   @"Office Address", @"Office Address 2",
    
    fieldArray = @[@(WC_FST1_Address_Work),
                   @(WC_FST1_Address_Work)];
    
    NSArray *addressFieldModels = [cardModel fieldArrayWithType:WC_FT_Address];
    
    [self addAddressDataFromArray:addressFieldModels orderFieldArray:fieldArray reusltArray:dataArray additionalNote:additionalNote fullAddressOnly:g_ExportFullAddressOnly cardModel:cardModel];
    
    //////////////////////////////////////////////////
    // Email (1) - @"Office Email",
    fieldArray = @[@(WC_FST1_Email_Work)];
    
    NSArray *mailArray = [cardModel fieldArrayWithType:WC_FT_Email];
    [self addSubType1DataFromArray:mailArray orderFieldArray:fieldArray reusltArrar:dataArray additionalNote:additionalNote];
    
    //////////////////////////////////////////////////
    // Web Page (1) - @"Office Website",
    
    fieldArray = @[@(WC_FST1_URL_Work)];
    
    NSArray *urlArray = [cardModel fieldArrayWithType:WC_FT_URL];
    [self addSubType1DataFromArray:urlArray orderFieldArray:fieldArray reusltArrar:dataArray additionalNote:additionalNote];
    
    //////////////////////////////////////////////////
    // Group (1)
    NSArray *groupNames = [self copyGroupNamesWithCardModel:cardModel];
    NSMutableString *fullGroupName = [NSMutableString string];
    for (NSString *groupName in groupNames)
    {
        if([fullGroupName length]>0)
        {
            [fullGroupName appendString:@","];
        }
        
        [fullGroupName appendString:groupName];
    }
    
    if([fullGroupName length]!=0)
    {
        [dataArray addObject:fullGroupName];
    }
    else
    {
        [self addEmptyWithCount:1 toArray:dataArray];
    }
    [groupNames release];
    
    return dataArray;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (private) write methods


//==============================================================================
//
//==============================================================================
- (void)worksheet:(lxw_worksheet *)worksheet writeToRowIndex:(uint32_t)rowIndex withDataArray:(NSArray *)dataArray format:(lxw_format *)format
{
    uint32_t columnIndex = 0;
    
    for (NSString *cellString in dataArray)
    {
        if ([cellString length]>0)
        {
            
            // 處理欄位寬度
            double stringLength = [cellString length] + 1;
            
            // 如果是中文字要乘2倍
            if([cellString isCJK])
            {
                stringLength *= 2;
            }
            
            // 寬度最大值
            if (stringLength>self.maxColumnWidth)
            {
                stringLength = self.maxColumnWidth;
            }
            
            
            NSNumber *currentWidth = [self.columnMaxLength objectForKey:@(columnIndex)];
            
            // 如果有要取大的
            if(stringLength>[currentWidth doubleValue])
            {
                currentWidth = @(stringLength);
                [self.columnMaxLength setObject:@(stringLength) forKey:@(columnIndex)];
            }
            
            worksheet_set_column(worksheet, columnIndex, columnIndex, [currentWidth doubleValue], format);
            
            //////////////////////////////////////////////////
            // 寫入欄位內容
            worksheet_write_string(worksheet, rowIndex, columnIndex, [cellString cStringUsingEncoding:NSUTF8StringEncoding], NULL);
        }
        columnIndex ++;
    }
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//================================================================================
//
//================================================================================
- (BOOL)writeFileWithPath:(NSString *)filePath
                  cardIDs:(NSArray *)cardIDs
                    error:(NSError **)error
{
    BOOL result = NO;
    NSError *returnError = nil;
    NSInteger cardCount = [cardIDs count];
    
    do
    {
        //////////////////////////////////////////////////
        
        if(cardCount == 0)
        {
            returnError = [PPErrorMake(WCXLSXDataController_Error_NoCardToWrite, nil, nil) retain];
            break;
        }
        //////////////////////////////////////////////////
        
        self.writeCardIDs = cardIDs;
        self.writtenCount = 0;
        
        //////////////////////////////////////////////////
        // 一開始先檢查delegate的目的是減少檢查次數，同時提示此流程會使用的delegate method。
        
        if([self.delegate respondsToSelector:@selector(xlsxDataContrller:cardModelToWriteWithCardID:)] == NO ||
           [self.delegate respondsToSelector:@selector(xlsxDataContrller:groupNameToWriteWithGroupID:)] == NO ||
           [self.delegate respondsToSelector:@selector(xlsxDataContrller:shouldWriteCardWithIndex:totalCount:)] == NO ||
           [self.delegate respondsToSelector:@selector(xlsxDataContrller:didWriteCardWithIndex:totalCount:)] == NO)
        {
            returnError = [PPErrorMake(WCXLSXDataController_Error_MustHaveDelegateMethod, nil, nil) retain];
            break;
        }
        
        //////////////////////////////////////////////////
        // 建立workbook
        lxw_workbook  *workbook  = workbook_new([filePath cStringUsingEncoding:NSUTF8StringEncoding]);
        
        if (workbook==NULL)
        {
            returnError = [PPErrorMake(WCXLSXDataController_Error_CreateWorkbookFailed, nil, nil) retain];
            break;
        }
        
        // 建立 format
        lxw_format *textFormat   = workbook_add_format(workbook);
        format_set_num_format(textFormat, "@");
        
        // 建立 worksheet
        lxw_worksheet *worksheet = workbook_add_worksheet(workbook, NULL);
        
        if (worksheet==NULL)
        {
            returnError = [PPErrorMake(WCXLSXDataController_Error_CreateWorksheetFailed, nil, nil) retain];
            break;
        }
        
        uint32_t rowIndex = 0;
        //////////////////////////////////////////////////
        // 寫入title
        NSArray *titleArray = [self copyTitleArrayForWriter];
        [self worksheet:worksheet writeToRowIndex:rowIndex++ withDataArray:titleArray format:textFormat];
        [titleArray release];
        
        //////////////////////////////////////////////////
        // data
        NSInteger contactIndex = 0;
        for (NSString *cardID in self.writeCardIDs)
        {
            
            @autoreleasepool
            {
                NSArray *dataArray = nil;
                
                if([self.delegate xlsxDataContrller:self shouldWriteCardWithIndex:contactIndex totalCount:cardCount]==NO)
                {
                    returnError = PPErrorMake(WCXLSXDataController_Error_CancelWriteCard, @"CancelWriteCard", nil);
                    
                    [returnError retain];
                    break;
                }
                
                //////////////////////////////////////////////////
                
                WCCardModel *cardModel = [self.delegate xlsxDataContrller:self cardModelToWriteWithCardID:cardID];
                if (cardModel)
                {
                    dataArray = [self dataArrayFromCardModel:cardModel];
                    [self worksheet:worksheet writeToRowIndex:rowIndex++ withDataArray:dataArray format:textFormat];
                }
                
                //////////////////////////////////////////////////
                // 回報完成一筆
                [self.delegate xlsxDataContrller:self didWriteCardWithIndex:contactIndex totalCount:cardCount];
                contactIndex++;
            }
        }
        
        //////////////////////////////////////////////////
        // 關閉workbook
        workbook_close(workbook);
        
        if(returnError==nil)
        {
            result = YES;
        }
        
        //////////////////////////////////////////////////
    }
    while (0);
    
    //////////////////////////////////////////////////
    
    if(error != nil)
    {
        *error = returnError;
    }
    [returnError autorelease];

    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (void)setShouldShowNamePhonetic:(BOOL)shouldShowNamePhonetic
{
    g_ShouldShowNamePhonetic = shouldShowNamePhonetic;
}


//==============================================================================
//
//==============================================================================
+ (void)setShouldShowCompanyPhonetic:(BOOL)shouldShowPhonetic
{
    g_ShouldShowCompanyPhonetic = shouldShowPhonetic;
}


//==============================================================================
//
//==============================================================================
+ (void)setExportFullAddressOnly:(BOOL)fullAddressOnly
{
    g_ExportFullAddressOnly = fullAddressOnly;
}
@end
