//
//  WCToolController.m
//  WorldCard series
//
//  Created by  Eddie on 2011/1/5.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <sys/sysctl.h>
#import <QuartzCore/QuartzCore.h>

#import "WCToolController.h"
#import "NSString+Additions.h"
#import "PPSystemInfoController.h"

static BOOL g_isSetRandomSeed = NO;

@implementation WCToolController

//===============================================================================
// 檢查並建立路徑中的目錄
// PARAMETERS: <in>dirPath => 路徑
// RETURNED: return YES if path is created
//===============================================================================
+ (BOOL)createDirPath:(NSString *)dirPath
{
    NSFileManager *fileManager = [NSFileManager defaultManager];
    
    if(![fileManager fileExistsAtPath:dirPath])
    {
        NSArray *pathArray = [dirPath componentsSeparatedByString:@"/"];
        NSString *currentPath = @"";
        NSString *temp;
        
        for(int i=0; i<[pathArray count]; i++)
        {
            temp = [pathArray objectAtIndex:i];
            
            if(![temp length])
                continue;
            
            currentPath = [currentPath stringByAppendingFormat:@"/%@", temp];
            
            //test : createDirPath
            //NSLog(@"currentPath : %@", currentPath);
            
            if(![fileManager fileExistsAtPath:dirPath])
            {
                if(![fileManager createDirectoryAtPath:currentPath
                           withIntermediateDirectories:YES
                                            attributes:nil
                                                 error:nil])
                {
                    return NO;
                }
            }
        }
    }
    
    return YES;
}


//===============================================================================
// get Share Folder Path
//===============================================================================
+ (NSString *)shareFolderPath
{
    NSArray	*paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    return [paths objectAtIndex:0];
}


//===============================================================================
// get Temp Folder Path  (Library/Caches)
//===============================================================================
+ (NSString *)tempFolderPath
{
#if TARGET_OS_IPHONE
    
    // !! this path is only for mobile app
    NSArray	*paths = NSSearchPathForDirectoriesInDomains(NSCachesDirectory, NSUserDomainMask, YES);
    return [paths objectAtIndex:0];
    
#elif TARGET_OS_MAC
    
    return [self baseStorePathWithDirName:@"Temp"];
    
#endif
}


//===============================================================================
// 建立/取得資料儲存的根目錄
// PARAMETERS: 目錄名稱
// RETURNED: 完整路徑
//===============================================================================
+ (NSString *)baseStorePathWithDirName:(NSString *)dirName
{
    return [WCToolController baseStorePathWithDirName:dirName isCreatDirPath:YES];
}


//===============================================================================
// 建立/取得資料儲存的根目錄
// PARAMETERS: 目錄名稱
// RETURNED: 完整路徑
//===============================================================================
+ (NSString *)baseStorePathWithDirName:(NSString *)dirName isCreatDirPath:(BOOL)isCreatDirPath
{
    NSString *baseStorePath;

#if TARGET_OS_IPHONE
    
    // !! iOS檔案放在Library目錄下是為了避免在iTunes被看到
    NSString *firstLevelFolder = @"WCM";
    NSArray	*paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
    baseStorePath = [NSString stringWithFormat:@"%@/%@/", [paths firstObject], firstLevelFolder];

#elif TARGET_OS_MAC
    
    NSArray	*paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    baseStorePath = [NSString stringWithFormat:@"%@/", [paths firstObject]];

#endif
    
    //////////////////////////////////////////////////
    
    if([dirName length])
    {
        baseStorePath = [baseStorePath stringByAppendingString:dirName];
    }
    
    if(isCreatDirPath)
    {
        [WCToolController createDirPath:baseStorePath];
    }
    
    return baseStorePath;
}


//===============================================================================
// 取得系統language設定
// RETURNED: WC_SystemLanguage
//===============================================================================
+ (WC_SystemLanguage)systemLanguage
{
    PPSystemInfoLanguage language = [PPSystemInfoController language];

    switch (language)
    {
        case PPSystemInfoLanguage_ChineseSimplified:
        {
            return WC_SL_SC;
        }
        case PPSystemInfoLanguage_ChineseTraditional:
        {
            return WC_SL_TC;
        }
        case PPSystemInfoLanguage_Japanese:
        {
            return WC_SL_JA;
        }
        case PPSystemInfoLanguage_Korean:
        {
            return WC_SL_KO;
        }
        case PPSystemInfoLanguage_French:
        {
            return WC_SL_FR;
        }
        case PPSystemInfoLanguage_German:
        {
            return WC_SL_DE;
        }
        case PPSystemInfoLanguage_Italian:
        {
            return WC_SL_IT;
        }
        case PPSystemInfoLanguage_Spanish:
        {
            return WC_SL_ES;
        }
        case PPSystemInfoLanguage_Dutch:
        {
            return WC_SL_NL;
        }
        case PPSystemInfoLanguage_Portuguese:
        {
             return WC_SL_PT;
        }
        case PPSystemInfoLanguage_Thai:
        {
            return WC_SL_TH;
        }
        case PPSystemInfoLanguage_Swedish:
        {
            return WC_SL_SW;
        }
        case PPSystemInfoLanguage_English:
        default:
            return WC_SL_EN;
    }
}


//===============================================================================
// 取得系統region設定
// RETURNED: region string
//===============================================================================
+ (NSString *)systemRegion
{
    NSString* region = [[NSLocale currentLocale] objectForKey:NSLocaleCountryCode];
    
    //	NSLog(@"region: %@", region);
    
    return region;
}


//===============================================================================
// get application version
//===============================================================================
+ (NSString *)appVersion
{
    NSString *version = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleShortVersionString"];
    //    NSString *version = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleShortVersionString"];
    
    return version;
}


//===============================================================================
// get application name
//===============================================================================
+ (NSString *)appBundleID
{
    NSString *bundleID = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleIdentifier"];
    
    return bundleID;
}


//===============================================================================
// 判斷是否為中日韓字串
// PARAMETERS: <in> string
// RETURNED: return YES if is CJK string
//===============================================================================
+ (BOOL)isCJKString:(NSString *)string
{
    return [string isCJK];
}


//===============================================================================
// isEngString
// PARAMETERS:	<in> string
// RETURNED: return YES if is english string
//===============================================================================
+ (BOOL)isEngString:(NSString *)string
{
    if(![string length])
        return NO;
    
    NSCharacterSet	*trimCharSet = [NSCharacterSet characterSetWithCharactersInString:@" -/:;()$&@\".,?!'[]{}#%^*+=_\\|~<>€£¥•1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"];
    NSString *trimString = [string stringByTrimmingCharactersInSet:trimCharSet];
    
    return ([trimString length] == 0);
}


//===============================================================================
// 判斷是否為漢字姓名
// RETURNED: return YES if is eastern name
//===============================================================================
+ (BOOL)isEasternNameWithFirstName:(NSString *)firstName lastName:(NSString *)lastName
{
    return ([self isCJKString:firstName] || [self isCJKString:lastName]);
}


//===============================================================================
// 濾除株式會社等無用名稱
//===============================================================================
+ (NSString *)trimCompanyPrefix:(NSString *)oriCompanyName
{
    if(![oriCompanyName length])
        return nil;
    
    if(![self isCJKString:oriCompanyName])
        return oriCompanyName;
    
    
    //-------------------------
    // 濾除不需要的字串
    //-------------------------
    NSString *newCompanyName = nil;
    NSString *allTitles = @"株式会社/有限会社/財団法人/社団法人/学校法人/宗教法人/合資会社/合名会社/相互会社/医療法人/独立行政法人/社団法人/農業協同組合/農事組合法人/(株)/(有)/(財)/(資)/(名)/(社)/(協)/(農)/（株）/（有）/（財）/（資）/（名）/（社）/（協）/（農）/㈱/㈲/㈶/㈾/㈴/㈳/㈿";
    NSArray *titleArray = [allTitles componentsSeparatedByString:@"/"];
    
    for(NSString *title in titleArray)
    {
        if([oriCompanyName hasPrefix:title])
        {
            newCompanyName = [oriCompanyName substringFromIndex:[title length]];
            break;
        }
        else if([oriCompanyName hasSuffix:title])
        {
            newCompanyName = [oriCompanyName substringToIndex:[oriCompanyName length]-[title length]];
            break;
        }
    }
    
    if(!newCompanyName)
        newCompanyName = [NSString stringWithString:oriCompanyName];
    
    return newCompanyName;
}


//===============================================================================
// generate cardID of 20 char
//===============================================================================
+ (NSString *)generateCardID
{
    NSMutableString		*cardID = [[NSMutableString alloc] initWithString:@""];
    const int           length = 10;
    unsigned char       tmpUUID[10] = {0};
    unsigned int        checkSum = 0;
    NSTimeInterval      timeInterval = [[NSDate date] timeIntervalSince1970];
    uint                timeSeed = ((int64_t)(timeInterval * 1000000))%1000000; // !!取出小數點後的數字
    
    
    // 取得時間作為random seed (設定一次就可以)
    if(g_isSetRandomSeed == NO)
    {
        srand(timeSeed);
        g_isSetRandomSeed = YES;
    }
    
    // 建立CardID
    tmpUUID[0] = (timeSeed >> 8) % 0xFF;
    tmpUUID[1] = timeSeed % 0xFF;
    tmpUUID[2] = rand() % 0xFF;
    tmpUUID[3] = rand() % 0xFF;
    tmpUUID[4] = rand() % 0xFF;
    tmpUUID[5] = rand() % 0xFF;
    tmpUUID[6] = rand() % 0xFF;
    tmpUUID[7] = rand() % 0xFF;
    
    // check sum
    for(int i=0; i<length-2; i++)
        checkSum += tmpUUID[i];
    
    tmpUUID[8] = (checkSum >> 8) % 0xFF;
    tmpUUID[9] = checkSum % 0xFF;
    
    for(int i=0; i<length; i++)
        [cardID appendFormat:@"%02x", tmpUUID[i]];
    
    return [cardID autorelease];
}


//===============================================================================
// !! 統一過場動畫
// use following method to receive finish delegate
// - (void)animationDidStop:(CAAnimation *)theAnimation finished:(BOOL)flag
//===============================================================================
+ (void)addCommonFadeAnimationWithLayer:(CALayer *)layer delegate:(id)delegate
{
    CATransition *anime = [CATransition animation];
    anime.duration = 0.2;
    anime.type = kCATransitionFade;
    anime.delegate = delegate;
    [layer addAnimation:anime forKey:@"fadeOut"];
}







/*
//===============================================================================
// iPhone1,1 -> iPhone 2G
// iPhone1,2 -> iPhone 3G
// iPhone3,1 -> iPhone4
// iPhone5,2 -> iPhone5
// iPod1,1   -> iPod touch 1G
// iPod2,1   -> iPod touch 2G
//===============================================================================
+ (NSString *)phoneModel
{
    size_t size;
    sysctlbyname("hw.machine", NULL, &size, NULL, 0);
    char *machine = malloc(size);
    sysctlbyname("hw.machine", machine, &size, NULL, 0);
    NSString *model = [NSString stringWithCString:machine encoding: NSUTF8StringEncoding];
    free(machine);
    return model;
}


//===============================================================================
//
//===============================================================================
+ (BOOL)isRetinaDisplay
{
    BOOL isRetinaDisplay = NO;
    
    if([UIScreen instancesRespondToSelector:@selector(scale)])
    {
        CGFloat scale = [[UIScreen mainScreen] scale];
        
        if(scale > 1.0)
            isRetinaDisplay = YES;
    }
    
    return isRetinaDisplay;
}


//===============================================================================
// get os main version
//===============================================================================
+ (CGFloat)OSMainVersion
{
    NSString *version = [[UIDevice currentDevice] systemVersion];
    
    return [[version substringToIndex:3] floatValue];
}


//===============================================================================
// get transform value by device orientation
// PARAMETERS: <in>orientation => device orientation
// RETURNED: transform value
//===============================================================================
+ (CGAffineTransform)transformFromOrientation:(UIInterfaceOrientation)orientation
{
    CGAffineTransform transRotate;
    
    switch (orientation)
    {
        case UIInterfaceOrientationPortrait:
            transRotate = CGAffineTransformMakeRotation(0);
            break;
            
        case UIInterfaceOrientationPortraitUpsideDown:
            transRotate = CGAffineTransformMakeRotation(M_PI);
            break;
            
        case UIInterfaceOrientationLandscapeLeft:
            transRotate = CGAffineTransformMakeRotation(M_PI*3/2);
            break;
            
        case UIInterfaceOrientationLandscapeRight:
            transRotate = CGAffineTransformMakeRotation(M_PI/2);
            break;
            
        default: transRotate = CGAffineTransformMakeRotation(0);
    }
    
    return transRotate;
}


//===============================================================================
// 強制介面以指定方向顯示
//===============================================================================
+ (void)forceDisplayWithOrientation:(UIInterfaceOrientation)orientation contentView:(UIView *)contentView
{
    [[UIApplication sharedApplication] setStatusBarOrientation:orientation animated:NO];
    
    UIWindow *curWnd = [UIApplication sharedApplication].keyWindow;
    CGRect rtContent = curWnd.bounds;
    
    if (UIInterfaceOrientationIsLandscape(orientation))
    {
        rtContent.size.width = curWnd.bounds.size.height;
        rtContent.size.height = curWnd.bounds.size.width;
    }
    
    contentView.bounds = rtContent;
    contentView.center = curWnd.center;
    contentView.transform = [WCToolController transformFromOrientation:orientation];
}


//===============================================================================
//
//===============================================================================
+ (NSInteger)adjustNavBarHeight:(UINavigationController *)navController
{
    UINavigationBar *navBar = navController.navigationBar;
    CGSize curSize = [navBar sizeThatFits:[UIScreen mainScreen].applicationFrame.size];
    
    //test
    //    navBar.tintColor = [UIColor blueColor];
    //    NSLog(@"curSize:%@", NSStringFromCGSize(curSize));
    
    navBar.frame = CGRectMake(0, 0, curSize.width, 44);
    
    NSInteger adjustedHeight = 44-curSize.height;
    
    return adjustedHeight;
}

//===============================================================================
//
//===============================================================================
+ (unsigned long long)systemCanUseSpace
{
    unsigned long long totalFreeSpace = 0;
    NSError *error = nil;
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSDictionary *dictionary = [[NSFileManager defaultManager] attributesOfFileSystemForPath:[paths lastObject] error: &error];
    
    if (dictionary)
    {
        NSNumber *freeFileSystemSizeInBytes = [dictionary objectForKey:NSFileSystemFreeSize];
        totalFreeSpace = [freeFileSystemSizeInBytes unsignedLongLongValue];
    }
    
    return totalFreeSpace;
}
//===============================================================================
//
//===============================================================================
+ (unsigned long long)folderSize:(NSString *)folderPath
{
    NSDirectoryEnumerator *dirEnum;
    NSString *fileName;
    NSError *error = nil;
    dirEnum = [[NSFileManager defaultManager]enumeratorAtPath:folderPath];
    unsigned long long fileSize = 0;
    
    while (fileName = [dirEnum nextObject]) {
        NSDictionary* fileAttributes = [[NSFileManager defaultManager] attributesOfItemAtPath:[folderPath stringByAppendingPathComponent:fileName] error:&error];
        fileSize += [fileAttributes fileSize];
    }
    
    return fileSize;
}
*/

@end
