//
//  WCToastView.m
//  WorldCardMobile7
//
//  Created by sanhue on 2015/9/13.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCToastController.h"
#import "UIView+Appearance.h"
#import "WCAppearanceDefine.h"
#import "PPAutoResizedLabel+Factory.h"

static UIView *SectionIndexToastView = nil;


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCToastController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - private class methods


//==============================================================================
//
//==============================================================================
+ (void)hideToast:(UIView *)toast {
    [UIView animateWithDuration:0.2
                          delay:0.0
                        options:(UIViewAnimationOptionCurveEaseIn | UIViewAnimationOptionBeginFromCurrentState)
                     animations:^{
                         toast.alpha = 0.0;
                     } completion:^(BOOL finished) {
                         [toast removeFromSuperview];
                     }];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (void)showSectionIndexToastFromSuperView:(UIView*)superView withTitle:(NSString *)title
{
    if (superView==nil)
    {
        return ;
    }
    

    //////////////////////////////////////////////////
    UILabel *toastLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 75, 75)];
    if (toastLabel)
    {
        [toastLabel setCornerRadius:10];

        toastLabel.font = [UIFont boldSystemFontOfSize:WCAppearanceDefine_SectionIndexToastTitleFontSize];
        toastLabel.backgroundColor = WCAppearanceDefine_SectionIndexToastBGColor;
        toastLabel.textColor = WCAppearanceDefine_SectionIndexToastTitleColor;
        toastLabel.textAlignment = NSTextAlignmentCenter;
        toastLabel.text = title;

        [PPToastController showToastFromSuperView:superView
                                   withCustomView:toastLabel
                                         duration:0.0
                                         position:PPToastPositionCenter];

        SectionIndexToastView = [toastLabel retain];

        [toastLabel release];
    }
}


//==============================================================================
//
//==============================================================================
+ (void)hideSectionIndexViewToast
{
    [PPToastController hideMessageToast];
//    [self hideToast:SectionIndexToastView];
    [SectionIndexToastView release];
    SectionIndexToastView = nil;
}


//================================================================================
//
//================================================================================
+ (void)showMessageToastFromSuperView:(UIView*)superView
                          withMessage:(NSString*)message
                 messageTextAlignment:(NSTextAlignment)messageTextAlignment
                             duration:(CGFloat)duration
                             position:(PPToastPosition)position
{
    [PPToastController showMessageToastFromSuperView:superView
                                         withMessage:message
                                            fontSize:WCAppearanceDefine_AlertToastTitleFontSize
                                           textColor:WCAppearanceDefine_AlertToastTitleColor
                                     backgroundColor:WCAppearanceDefine_AlertToastBGColor
                                       textAlignment:messageTextAlignment
                                            duration:duration
                                            position:position];
}



//==============================================================================
//
//==============================================================================
+ (void)showMessageToastFromSuperView:(UIView*)superView
                          withMessage:(NSString*)message
                             duration:(CGFloat)duration
                             position:(PPToastPosition)position
{
    [self showMessageToastFromSuperView:superView
                            withMessage:message
                   messageTextAlignment:NSTextAlignmentCenter
                               duration:duration
                               position:position];
}

//================================================================================
//
//================================================================================
+ (void)showMessageToastFromSuperView:(UIView*)superView
                          withMessage:(NSString*)message
                 messageTextAlignment:(NSTextAlignment)messageTextAlignment
                             position:(PPToastPosition)position
{
    [self showMessageToastFromSuperView:superView
                            withMessage:message
                   messageTextAlignment:messageTextAlignment
                               duration:0.0
                               position:position];
}


//==============================================================================
//
//==============================================================================
+ (void)showMessageToastFromSuperView:(UIView*)superView
                          withMessage:(NSString*)message
                             position:(PPToastPosition)position
{
    [self showMessageToastFromSuperView:superView
                            withMessage:message
                   messageTextAlignment:NSTextAlignmentCenter
                               duration:0.0
                               position:position];
}


//==============================================================================
//
//==============================================================================
+ (void)hideMessageToast
{
    [PPToastController hideMessageToast];
}

@end
