//
//  WCTRestClientController+Password.m
//  
//
//  Created by Howard on 2016/11/25.
//
//

#import "WCTRestClientController+Password.h"

// Define
#import "WCTRestClientController+SettingsKey.h"
#import "WCTRestClientController+ParameterDefine.h"

// Controller
#import "PPSettingsController.h"

// Category
#import "NSData+AES256.h"

@implementation WCTRestClientController (Password)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (NSString *)decryptAccountPassword
{
    NSString *accountPassword = nil;
    
    do
    {
        NSData *accountPasswordData = [PPSettingsController dataValueWithKey:WCTRestClientController_SettingsKey_Password];
        if(accountPasswordData==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        accountPasswordData = [accountPasswordData AES256DecryptDataWithKey:WCTClientControllerAES256Key];
        if(accountPasswordData==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        accountPassword = [[[NSString alloc] initWithData:accountPasswordData encoding:NSUTF8StringEncoding] autorelease];
        
    }while(0);
    
    return accountPassword;
}


//================================================================================
//
//================================================================================
+ (void)encryptAccountPasswordToUserDefault:(NSString *)accountPassword
{
    if(accountPassword!=nil)
    {
        do
        {
            NSData *accountPasswordData = [accountPassword dataUsingEncoding:NSUTF8StringEncoding];
            if(accountPasswordData==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            accountPasswordData = [accountPasswordData AES256EncryptDataWithKey:WCTClientControllerAES256Key];
            if(accountPasswordData==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            [PPSettingsController setDataValue:accountPasswordData withKey:WCTRestClientController_SettingsKey_Password];
            
        }while(0);
    }
    else
    {
        [PPSettingsController removeValueWithKey:WCTRestClientController_SettingsKey_Password];
    }
}


@end
