//
//  WCTRestClientController+Common.m
//
//
//  Created by Howard on 2017/4/7.
//
//

#import "WCTRestClientController+Common.h"

// Define
#import "WCTRestClientController+SettingsKey.h"
#import "WCTRestClientController+ParameterDefine.h"

// Controller
#import "PPSettingsController.h"

@implementation WCTRestClientController (Common)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


//==============================================================================
// 應該只有登入，登出，不需要做這個檢查
//==============================================================================
- (BOOL)checkNeedLogoutAndSendNotificationWithError:(NSError *)error
{
    if (error==nil)
    {
        return NO;
    }
    

    // !! Token失效, 不允許IP或裝置，要登出
    NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];

    if(statusCode!=WCTServer_Common_ErrorCode_AuthenticationFailed &&
       statusCode!=WCTServer_Common_ErrorCode_NotAllowedIP&&
       statusCode!=WCTServer_Common_ErrorCode_UnbindingDevice)
    {
        return NO;
    }
    
    
    //////////////////////////////////////////////////
    // 送出通知

    [error retain];
    dispatch_async(dispatch_get_main_queue(), ^{
        
        [[NSNotificationCenter defaultCenter] postNotificationName:WCTRestClientController_LogoutNotification
                                                            object:self
                                                          userInfo:@{WCTRestClientController_LogoutErrorKey:error}];
        [error release];
    });
    
    return YES;
}



//================================================================================
//
//================================================================================
- (NSString *)errorDomainMessageForError:(NSError *)error
{
    NSString *errorDomainMessage = error.domain;
    
    do
    {
        if(error==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id url = [error.userInfo objectForKey:@"NSErrorFailingURLKey"];
        
        if(url==nil ||
           [url isKindOfClass:[NSURL class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *baseURL = [[PPSettingsController stringValueWithKey:WCTRestClientController_SettingsKey_URLAddress] stringByAppendingString:@"/"];
        errorDomainMessage = [[url absoluteString] stringByReplacingOccurrencesOfString:baseURL withString:@""];
        
        //////////////////////////////////////////////////
        
        if([errorDomainMessage length]>0)
        {
            // 當GETAPI時,會將?後面的參數帶進來,所以要移掉
            errorDomainMessage = [[errorDomainMessage componentsSeparatedByString:@"?"] firstObject];
        }
    }
    while (0);
    
    return errorDomainMessage;
}


@end
