//
//  WCTRCCategoryToggleUsualVo.m
//  
//
//  Created by Howard on 2018/2/21.
//

#import "WCTRCCategoryToggleUsualVo.h"

@implementation WCTRCCategoryToggleUsualVo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dealloc Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_list release];
    _list = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{list:%@, setAsToggled:%d}",
            [super description],
            self.list,
            self.setAsToggled];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCategoryToggleUsualVo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.list = [[self.list copyWithZone:zone] autorelease];
            object.setAsToggled = object.setAsToggled;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"list":@"list",
                                                              @"setAsToggled":@"setAsToggled"
                                                              }];
    }
    
    return responseMapping;
}


@end
