//
//  WCTRCBasicResponseResult.m
//  
//
//  Created by Howard on 2016/3/23.
//
//

#import "WCTRCBasicResponseResult.h"

@implementation WCTRCBasicResponseResult

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_exceptionMessage release];
    _exceptionMessage = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{ErrorCode:%td, exception:%@}",
            [super description],
            self.errorCode,
            self.exceptionMessage];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCBasicResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.errorCode = self.errorCode;
            object.exceptionMessage = [[self.exceptionMessage copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"errorCode":@"errorCode",
                                                              @"exceptionMessage":@"exceptionMessage"}];
    }
    
    return responseMapping;
}
@end
