//
//  WCTRCLicense.m
//  ADAL
//
//  Created by sanhue on 2018/5/30.
//

#import "WCTRCLicense.h"

@implementation WCTRCLicense



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_licenseMode release];
    _licenseMode = nil;
    
    [_serverRegisterStatus release];
    _serverRegisterStatus = nil;
    
    [_subscriptionStatus release];
    _subscriptionStatus = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{licenseMode:%@, serverRegisterStatus:%@, subscriptionStatus:%@}",
            [super description],
            self.licenseMode,
            self.serverRegisterStatus,
            self.subscriptionStatus];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCLicense *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.licenseMode = [[self.licenseMode copyWithZone:zone] autorelease];
            object.serverRegisterStatus = [[self.serverRegisterStatus copyWithZone:zone] autorelease];
            object.subscriptionStatus = [[self.subscriptionStatus copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"licenseMode":@"licenseMode",
                                                              @"serverRegisterStatus":@"serverRegisterStatus",
                                                              @"subscriptionStatus":@"subscriptionStatus"}];
        
    }
    
    return responseMapping;
}

@end
