//
//  WCTRCSyncContactInfo.m
//  Pods
//
//  Created by sanhue on 2016/4/8.
//
//

#import "WCTRCDetailContactInfo.h"

@implementation WCTRCDetailContactInfo


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_sharedAccountSha1 release];
    _sharedAccountSha1 = nil;
    
    [_categorySha1 release];
    _categorySha1 = nil;
    
    [_contentSha1 release];
    _contentSha1 = nil;
    
    [_syncModifyTime release];
    _syncModifyTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{sharedAccountSha1:%@, categorySha1:%@, contentSha1:%@, syncModifyTime:%@}",
            [super description],
            self.sharedAccountSha1,
            self.categorySha1,
            self.contentSha1,
            self.syncModifyTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCDetailContactInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.sharedAccountSha1 = [[self.sharedAccountSha1 copyWithZone:zone] autorelease];
            object.categorySha1 = [[self.categorySha1 copyWithZone:zone] autorelease];
            object.contentSha1 = [[self.contentSha1 copyWithZone:zone] autorelease];
            object.syncModifyTime = [[self.syncModifyTime copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountscanviewSha1":@"sharedAccountSha1",
                                                              @"categorySha1":@"categorySha1",
                                                              @"contentSha1":@"contentSha1",
                                                              @"syncModifyTime":@"syncModifyTime"}];
    }
    
    return responseMapping;
}

@end
