//
//  WCTRCContactUpdateCheckResult.m
//  Pods
//
//  Created by sanhue on 2016/8/31.
//
//

#import "WCTRCContactUpdateCheckResult.h"

@implementation WCTRCContactUpdateCheckResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.contactStatus = nil;
    self.updateComponents = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{contactStatus:%@, updateComponents:%@}",
            [super description],
            self.contactStatus,
            self.updateComponents];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactUpdateCheckResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.contactStatus = [[self.contactStatus copyWithZone:zone] autorelease];
            object.updateComponents = [[self.updateComponents copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"contactStatus":@"contactStatus",
                                                              @"updateComponents":@"updateComponents"}];
        
    }
    
    return responseMapping;
}

@end
