//
//  WCTRCContactSyncInfo.m
//  Pods
//
//  Created by sanhue on 2016/4/8.
//
//

#import "WCTRCContactSyncInfo.h"

@implementation WCTRCContactSyncInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_action release];
    _action = nil;
   
    [_contactGuid release];
    _contactGuid = nil;
    
    [_lastModifyTime release];
    _lastModifyTime = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{action:%@, contactGuid:%@, lastModifyTime:%@}",
            [super description],
            self.action,
            self.contactGuid,
            self.lastModifyTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactSyncInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.action = [[self.action copyWithZone:zone] autorelease];
            object.contactGuid = [[self.contactGuid copyWithZone:zone] autorelease];
            object.lastModifyTime = [[self.lastModifyTime copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"action":@"action",
                                                              @"contactGuid":@"contactGuid",
                                                              @"lastModifyTime":@"lastModifyTime"}];
        
    }
    
    return responseMapping;
}
@end
