//
//  WCTRCContactProfile.m
//  Pods
//
//  Created by sanhue on 2016/4/6.
//
//

#import "WCTRCContactProfile.h"

@implementation WCTRCContactProfile





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuidsBeShared release];
    _accountGuidsBeShared = nil;

    [_categoryGuids release];
    _categoryGuids = nil;

    [_categorySha1 release];
    _categorySha1 = nil;

    [_createTime release];
    _createTime = nil;

    [_creatorGuid release];
    _creatorGuid = nil;

    [_frontImageSha1 release];
    _frontImageSha1 = nil;

    [_guid release];
    _guid = nil;

    [_logoImageSha1 release];
    _logoImageSha1 = nil;

    [_modifyTime release];
    _modifyTime = nil;

    [_rearImageSha1 release];
    _rearImageSha1 = nil;

    [_sharedAccountSha1 release];
    _sharedAccountSha1 = nil;
    
    [_textSha1 release];
    _textSha1 = nil;

    [_syncModifyTime release];
    _syncModifyTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{GUID:%@, creatorGuid:%@, accountGuidsBeShared:%@, categoryGuids:%@, isDelete:%@, categorySha1:%@, sharedAccountSha1:%@, textSha1:%@}, logoImageSha1:%@, frontImageSha1:%@, rearImageSha1:%@, createTime:%@, modifyTime:%@, syncModifyTime:%@",
            [super description],
            self.guid,
            self.creatorGuid,
            self.accountGuidsBeShared,
            self.categoryGuids,
            (self.deleted?@"YES":@"NO"),
            self.categorySha1,
            self.sharedAccountSha1,
            self.textSha1,
            self.logoImageSha1,
            self.frontImageSha1,
            self.rearImageSha1,
            self.createTime,
            self.modifyTime,
            self.syncModifyTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactProfile *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.creatorGuid = [[self.creatorGuid copyWithZone:zone] autorelease];
            object.accountGuidsBeShared = [[self.accountGuidsBeShared copyWithZone:zone] autorelease];
            object.categoryGuids = [[self.categoryGuids copyWithZone:zone] autorelease];
            object.deleted = self.deleted;
            object.categorySha1 = [[self.categorySha1 copyWithZone:zone] autorelease];
            object.sharedAccountSha1 = [[self.sharedAccountSha1 copyWithZone:zone] autorelease];
            object.textSha1 = [[self.textSha1 copyWithZone:zone] autorelease];
            object.logoImageSha1 = [[self.logoImageSha1 copyWithZone:zone] autorelease];
            object.frontImageSha1 = [[self.frontImageSha1 copyWithZone:zone] autorelease];
            object.rearImageSha1 = [[self.rearImageSha1 copyWithZone:zone] autorelease];
            object.createTime = [[self.createTime copyWithZone:zone] autorelease];
            object.modifyTime = [[self.modifyTime copyWithZone:zone] autorelease];
            object.syncModifyTime = [[self.syncModifyTime copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"guid" : @"guid",
                                                              @"creatorGuid" : @"creatorGuid",
                                                              @"accountGuidsBeShared" : @"accountGuidsBeShared",
                                                              @"categoryGuids" : @"categoryGuids",
                                                              @"deleted" : @"deleted",
                                                              @"categorySha1" : @"categorySha1",
                                                              @"accountcanviewSha1" : @"sharedAccountSha1",
                                                              @"textSha1" : @"textSha1",
                                                              @"logoImageSha1" : @"logoImageSha1",
                                                              @"frontImageSha1" : @"frontImageSha1",
                                                              @"rearImageSha1" : @"rearImageSha1",
                                                              @"createTime" : @"createTime",
                                                              @"modifyTime" : @"modifyTime",
                                                              @"syncModifyTime" : @"syncModifyTime"}];
    }
    
    return responseMapping;
}

@end
