//
//  WCTRCDateTime.m
//  
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRCDateTime.h"

@implementation WCTRCDateTime

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{afterNow:%d, beforeNow:%d, equalNow:%d}",
            [super description],
            self.afterNow,
            self.beforeNow,
            self.equalNow];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCDateTime *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.afterNow = self.afterNow;
            object.beforeNow = self.beforeNow;
            object.equalNow = self.equalNow;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"afterNow":@"afterNow",
                                                              @"beforeNow":@"beforeNow",
                                                              @"equalNow":@"equalNow"}];
    }
    
    return responseMapping;
}
@end
