//
//  WCTRCSearchPublicContactsByKeywordSortedResponseResult.m
//
//
//  Created by Howard on 2016/5/30.
//
//

#import "WCTRCSearchPublicContactsByKeywordSortedResponseResult.h"

@implementation WCTRCSearchPublicContactsByKeywordSortedResponseResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{totalCount:%ld, totalPages:%ld}",
            [super description],
            (long)self.totalCount,
            (long)self.totalPages];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCSearchPublicContactsByKeywordSortedResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.totalCount = self.totalCount;
            object.totalPages = self.totalPages;
        }
    }
    
    return object;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"totalCount":@"totalCount",
                                                              @"totalPages":@"totalPages"}];
        
    }
    
    return responseMapping;
}


@end
