//
//  WCTRCAdvancedSearchInfo.h
//  ADAL
//
//  Created by sanhue on 2018/4/26.
//

#import "WCTRestObject.h"
#import "WCTRCAdvancedSearchAccountCondition.h"
#import "WCTRCAdvancedSearchCategoryCondition.h"
#import "WCTRCAdvancedSearchContactInfoCondition.h"
#import "WCTRCAdvancedSearchCustomFieldCondition.h"
#import "WCTRCAdvancedSearchTimeCondition.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTRCAdvancedSearchInfo : WCTRestObject

// 以下的property 如果要加的條件，就用nil
#pragma mark property
@property (nonatomic, retain) WCTRCAdvancedSearchAccountCondition *accountCondition;
@property (nonatomic, retain) WCTRCAdvancedSearchCategoryCondition *categoryCondition;
@property (nonatomic, retain) WCTRCAdvancedSearchContactInfoCondition *contactInfoCondition;
@property (nonatomic, retain) WCTRCAdvancedSearchCustomFieldCondition *customFieldCondition;
@property (nonatomic, retain) WCTRCAdvancedSearchTimeCondition *timeCondition;


#pragma mark utility methods

/// 新增帳號條件
/// fieldString Value: WCTRC_AccountSearchField_Creator, WCTRC_AccountSearchField_Editor, WCTRC_AccountSearchField_Owner
/// accountGuids array of account guid
- (void)addConditionWithFieldString:(NSString*)fieldString accountGuids:(NSArray *)accountGuids;

/// 新增類別條件, (共享聯絡人目前沒有類別條件)
- (void)addConditionWithCategoryGuids:(NSArray *)categoryGuids;

/// 新增聯絡人欄位條件
- (void)addConditionWithContactSearchInfo:(WCTRCAdvancedSearchContactSearchInfo *)contactSearchInfo;

/// 新增自訂欄位條件
- (void)addConditionWithCustomFieldSearchInfo:(WCTRCAdvancedSearchCustomFieldSearchInfo *)customFieldSearchInfo;

/// 新增時間條件
/// fieldString Value: WCTRC_TimeSearchField_CreateTime, WCTRC_TimeSearchField_ModifyTime
- (void)addConditionWithFieldString:(NSString*)fieldString beginTime:(NSString *)beginTime endTime:(NSString *)endTime;

@end
