//
//  WCTRCAdvancedSearchCustomFieldSearchInfo.m
//  ADAL
//
//  Created by sanhue on 2018/4/27.
//

#import "WCTRCAdvancedSearchCustomFieldSearchInfo.h"

@implementation WCTRCAdvancedSearchCustomFieldSearchInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_customFieldGuid release];
    _customFieldGuid = nil;
    
    [_keyword release];
    _keyword = nil;
    
    [_logicWithPreviousAllResults release];
    _logicWithPreviousAllResults = nil;
    
    [_numberInterval release];
    _numberInterval = nil;
    
    [_picklistContentGuids release];
    _picklistContentGuids = nil;
    
    [_timeInterval release];
    _timeInterval = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{customFieldGuid:%@, keyword:%@, logicWithPreviousAllResults:%@, numberInterval:%@, picklistContentGuids:%@, timeInterval:%@}",
            [super description],
            self.customFieldGuid,
            self.keyword,
            self.logicWithPreviousAllResults,
            self.numberInterval,
            self.picklistContentGuids,
            self.timeInterval];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchCustomFieldSearchInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.customFieldGuid = [[self.customFieldGuid copyWithZone:zone] autorelease];
            object.keyword = [[self.keyword copyWithZone:zone] autorelease];
            object.logicWithPreviousAllResults = [[self.logicWithPreviousAllResults copyWithZone:zone] autorelease];
            object.numberInterval = [[self.numberInterval copyWithZone:zone] autorelease];
            object.picklistContentGuids = [[self.picklistContentGuids copyWithZone:zone] autorelease];
            object.timeInterval = [[self.timeInterval copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"customFieldGuid":@"customFieldGuid",
                                                              @"keyword":@"keyword",
                                                              @"logicWithPreviousAllResults":@"logicWithPreviousAllResults",
                                                              @"picklistContentGuids":@"picklistContentGuids"
                                                              }];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"numberInterval"
                                                                                        toKeyPath:@"numberInterval"
                                                                                      withMapping:[WCTRCAdvancedSearchCustomFieldNumberInterval responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"timeInterval"
                                                                                        toKeyPath:@"timeInterval"
                                                                                      withMapping:[WCTRCAdvancedSearchCustomFieldTimeInterval responseMapping]]];
        
    }
    
    return responseMapping;
}
@end
