//
//  WCTRCContactShareAccountRequest.m
//  
//
//  Created by Howard on 2016/3/28.
//
//

#import "WCTRCContactShareAccountRequest.h"

@implementation WCTRCContactShareAccountRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuids release];
    _accountGuids = nil;
    
    [_contactGuids release];
    _contactGuids = nil;
    
    [_shareBehavior release];
    _shareBehavior = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountGuids:%@, contactGuids:%@, shareBehavior:%@}",
            [super description],
            self.accountGuids,
            self.contactGuids,
            self.shareBehavior];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactShareAccountRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountGuids = [[self.accountGuids copyWithZone:zone] autorelease];
            object.contactGuids = [[self.contactGuids copyWithZone:zone] autorelease];
            object.shareBehavior = [[self.shareBehavior copyWithZone:zone] autorelease];
        }
    }
    
    return object;

}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuids":@"accountGuids",
                                                              @"contactGuids":@"contactGuids",
                                                              @"shareBehavior":@"shareBehavior"}];
    }
    
    return responseMapping;
}

@end
