//
//  PPVersionInfo.m
//  Pods
//
//  Created by sanhue on 2017/5/24.
//
//

#import "PPVersionInfo.h"

@implementation PPVersionInfo





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithVersionString:(NSString *)versionString
{
    self = [super init];
    if (self)
    {
        // 預設 1.0.0
        self.majorVersion = 1;
        
        //////////////////////////////////////////////////
        NSArray *versionArray = [versionString componentsSeparatedByString:@"."];
        
        if ([versionArray count]>=1)
        {
            NSInteger versionValue = [versionArray[0] integerValue];
            if(versionValue!=0)
            {
                self.majorVersion = versionValue;
            }
        }
        
        if ([versionArray count]>=2)
        {
            self.minorVersion = [versionArray[1] integerValue];
        }
        
        if ([versionArray count]>=3)
        {
            self.patchVersion = [versionArray[2] integerValue];
        }

    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    //////////////////////////////////////////////////
    [super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - ovreride methods


//==============================================================================
//
//==============================================================================
- (BOOL)isEqual:(id)object
{
    if ([object isKindOfClass:[PPVersionInfo class]]==NO)
    {
        return NO;
    }
    
    PPVersionInfo *inputVersionInfo = (PPVersionInfo*)object;
    
    if (inputVersionInfo.majorVersion==self.majorVersion&&
        inputVersionInfo.minorVersion==self.minorVersion&&
        inputVersionInfo.patchVersion==self.patchVersion)
    {
        return YES;
    }
    
    return NO;
}


//==============================================================================
//
//==============================================================================
- (id)copyWithZone:(nullable NSZone *)zone
{
    return [[PPVersionInfo alloc] initWithVersionString:[self versionString]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (PPComparisonResult)compare:(PPVersionInfo *)versionInfo
{
    if (self.majorVersion>versionInfo.majorVersion)
    {
        return PPComparisonResult_GreatThan;
    }
    else if (self.majorVersion<versionInfo.majorVersion)
    {
        return PPComparisonResult_LessThan;
    }
    else
    {
        if (self.minorVersion>versionInfo.minorVersion)
        {
            return PPComparisonResult_GreatThan;
        }
        else if (self.minorVersion<versionInfo.minorVersion)
        {
            return PPComparisonResult_LessThan;
        }
        else
        {
            if (self.patchVersion>versionInfo.patchVersion)
            {
                return PPComparisonResult_GreatThan;
            }
            else if (self.patchVersion<versionInfo.patchVersion)
            {
                return PPComparisonResult_LessThan;
            }
            else
            {
                return PPComparisonResult_Equal;
            }
        }
    }
}


//==============================================================================
//
//==============================================================================
- (NSString *)versionString
{
    return [NSString stringWithFormat:@"%ld.%ld.%ld",
            (long)self.majorVersion,
            (long)self.minorVersion,
            (long)self.patchVersion];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods


//==============================================================================
//
//==============================================================================
+ (instancetype)versionInfoWithVersionString:(NSString*)versionString
{
    return [[[PPVersionInfo alloc] initWithVersionString:versionString] autorelease];
}



@end
