//
//  WCTRCCRMFailureReasonInfo.m
//  Pods
//
//  Created by sanhue on 2016/12/22.
//
//

#import "WCTRCExportFailureReasonInfo.h"
#import "WCTRCExportFailureReasonInfo_ErrorCodeDefine.h"
#import "NSString+Additions.h"

// resource define
#define WCTRCExportFailureReason_RequiredCompanyMissing [@"MLS_FailureReason_RequiredCompanyMissing" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_RequestLimitExceeded [@"MLS_FailureReason_RequestLimitExceeded" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_RequiredFieldMissing [@"MLS_FailureReason_RequiredFieldMissing" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_InvalidEmailAddress [@"MLS_FailureReason_InvalidEmailAddress" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_APIDisabledForOrg [@"MLS_FailureReason_APIDisabledForOrg" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_SalesforceSpaceNotEnough [@"MLS_FailureReason_SalesforceSpaceNotEnough" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_InternalServerError [@"MLS_FailureReason_InternalServerError" localizedFromTable:@"WCTRestClientController"]

#define WCTRCExportFailureReason_StringTooLong [@"MLS_FailureReason_StringTooLong" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_InvalidOperationWithExpiredPassword [@"MLS_FailureReason_InvalidOperationWithExpiredPassword" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_FieldIntegrityException [@"MLS_FailureReason_FieldIntegrityException" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_CannotInsertUpdateActivateEntity [@"MLS_FailureReason_CannotInsertUpdateActivateEntity" localizedFromTable:@"WCTRestClientController"]
// 與上面用同一個訊息
#define WCTRCExportFailureReason_InsufficientAccessOrReadOnly [@"MLS_FailureReason_CannotInsertUpdateActivateEntity" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_InvalidField [@"MLS_FailureReason_InvalidField" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_DuplicatesDetected [@"MLS_FailureReason_DuplicatesDetected" localizedFromTable:@"WCTRestClientController"]

#define WCTRCExportFailureReason_MaxContactNumberInDBReached [@"MLS_FailureReason_MaxContactNumberInDBReached" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_MaxContactNumberOwningReached [@"MLS_FailureReason_MaxContactNumberOwningReached" localizedFromTable:@"WCTRestClientController"]
#define WCTRCExportFailureReason_MaxContactNumberInPrivateReached [@"MLS_FailureReason_MaxContactNumberInPrivateReached" localizedFromTable:@"WCTRestClientController"]



////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTRCExportFailureReasonInfo ()

@property (nonatomic, retain) NSDictionary *errorCodeMapping;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTRCExportFailureReasonInfo





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    
    if (self)
    {
        self.errorCodeMapping = @{WCTRCExportFailureReasonDefine_RequiredCompanyMissing:WCTRCExportFailureReason_RequiredCompanyMissing,
                                  WCTRCExportFailureReasonDefine_RequestLimitExceeded:WCTRCExportFailureReason_RequestLimitExceeded,
                                  WCTRCExportFailureReasonDefine_RequiredFieldMissing:WCTRCExportFailureReason_RequiredFieldMissing,
                                  WCTRCExportFailureReasonDefine_InvalidEmailAddress:WCTRCExportFailureReason_InvalidEmailAddress,
                                  WCTRCExportFailureReasonDefine_APIDisableForOrg:WCTRCExportFailureReason_APIDisabledForOrg,
                                  WCTRCExportFailureReasonDefine_StorageSpaceLimit:WCTRCExportFailureReason_SalesforceSpaceNotEnough,
                                  WCTRCExportFailureReasonDefine_StringTooLong:WCTRCExportFailureReason_StringTooLong,
                                  WCTRCExportFailureReasonDefine_InvaildOperationWithExpiredPassword:WCTRCExportFailureReason_InvalidOperationWithExpiredPassword,
                                  WCTRCExportFailureReasonDefine_FieldIntegityException:WCTRCExportFailureReason_FieldIntegrityException,
                                  WCTRCExportFailureReasonDefine_CannotInsertUpdateActivateEntity:WCTRCExportFailureReason_InsufficientAccessOrReadOnly,
                                  WCTRCExportFailureReasonDefine_InsufficientAccessOrReadOnly:WCTRCExportFailureReason_CannotInsertUpdateActivateEntity,
                                  WCTRCExportFailureReasonDefine_InvalidField:WCTRCExportFailureReason_InvalidField,
                                  WCTRCExportFailureReasonDefine_DuplicatesDetected:WCTRCExportFailureReason_DuplicatesDetected
        };
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_errorCodeMapping release];
    _errorCodeMapping = nil;
    
    [_guid release];
    _guid = nil;

    [_data release];
    _data = nil;
    
    [_company release];
    _company = nil;
    
    [_fullName release];
    _fullName = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guid:%@, data:%@, company:%@, fullName:%@",
            [super description],
            self.guid,
            self.data,
            self.company,
            self.fullName];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCExportFailureReasonInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.data = [[self.data copyWithZone:zone] autorelease];
            object.company = [[self.company copyWithZone:zone] autorelease];
            object.fullName = [[self.fullName copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//==============================================================================
//
//==============================================================================
- (NSDictionary *)parsedData
{
    return [[NSJSONSerialization JSONObjectWithData:[self.data dataUsingEncoding:NSUTF8StringEncoding]
                                            options:NSJSONReadingMutableLeaves
                                              error:nil] firstObject];
}


//==============================================================================
//
//==============================================================================
- (NSString *)formattedStringWithInvalidFieldReason:(NSString * _Nonnull )invaliedFieldReason pattern:(NSString * _Nonnull)pattern
{
    if([invaliedFieldReason length]==0 || [pattern length]==0)
    {
        return nil;
    }
    
    __block NSString *columnName = nil;
    __block NSString *sObjectType = nil;
    
    NSError *error = NULL;
    NSRegularExpression *regex = [NSRegularExpression
                                  regularExpressionWithPattern:pattern
                                  options:NSRegularExpressionCaseInsensitive
                                  error:&error];
    
    [regex enumerateMatchesInString:invaliedFieldReason
                            options:0
                              range:NSMakeRange(0, [invaliedFieldReason length])
                         usingBlock:^(NSTextCheckingResult *match, NSMatchingFlags flags, BOOL *stop){
        
        NSUInteger numberOfRanges = [match numberOfRanges];
        
        if(numberOfRanges>2)
        {
            NSRange subRange = [match rangeAtIndex:1];
            if(subRange.location!=NSNotFound)
            {
                columnName = [invaliedFieldReason substringWithRange:subRange];
            }
            
            subRange = [match rangeAtIndex:2];
            if(subRange.location!=NSNotFound)
            {
                sObjectType = [invaliedFieldReason substringWithRange:subRange];
            }
        }
        
    }];
    
    if([columnName length]==0||[sObjectType length]==0)
    {
        return nil;
    }
    
    NSString *localizedReason = [self.errorCodeMapping objectForKey:WCTRCExportFailureReasonDefine_InvalidField];
    return [NSString stringWithFormat:localizedReason, columnName, sObjectType];
    
}


//==============================================================================
//
//==============================================================================
- (NSString *)localizedFailureReason
{
//    NSLog(@"self.data:%@", self.data);
    NSDictionary *parsedDict = [self parsedData];

    // !! 如果無法轉換成json格式，就直接顯示字串
    if ([parsedDict count]==0)
    {
        // MARK: 內文分析
        if([self.data isEqualToString:WCTRCExportFailureReasonDefine_MaxContactNumberInDBReached]==YES)
        {
            return WCTRCExportFailureReason_MaxContactNumberInDBReached;
        }
        else if([self.data isEqualToString:WCTRCExportFailureReasonDefine_MaxContactNumberOwningReached]==YES)
        {
            return WCTRCExportFailureReason_MaxContactNumberOwningReached;
        }
        else if([self.data isEqualToString:WCTRCExportFailureReasonDefine_MaxContactNumberInPrivateReached]==YES)
        {
            return WCTRCExportFailureReason_MaxContactNumberInPrivateReached;
        }
        else
        {
            return self.data;
        }
    }
    
    NSString *errorCode = parsedDict[@"errorCode"];
    NSString *localizedReason = [self.errorCodeMapping objectForKey:errorCode];
    
    // !! 如果不在錯誤碼列表中，顯示一般字串+errorCode
    if ([localizedReason length]==0)
    {
        return  [NSString stringWithFormat:WCTRCExportFailureReason_InternalServerError, errorCode];
    }
    

    if ([errorCode isEqualToString:WCTRCExportFailureReasonDefine_RequiredFieldMissing] ||
        [errorCode isEqualToString:WCTRCExportFailureReasonDefine_StringTooLong] ||
        [errorCode isEqualToString:WCTRCExportFailureReasonDefine_FieldIntegityException])
    {
        // 缺少欄位要把field填入
        NSArray *fields = parsedDict[@"fields"];
        NSString *fieldsString = [fields componentsJoinedByString:@", "];
        return [NSString stringWithFormat:localizedReason, fieldsString];
    }
    else if([errorCode isEqualToString:WCTRCExportFailureReasonDefine_InvalidField])
    {
        NSString *message = parsedDict[@"message"];

        if([message length]>0)
        {
            // {\\\"message\\\":\\\"No such column \\u0027Fax\\u0027 on sobject of type Account\\\",\\\"errorCode\\\":\\\"INVALID_FIELD\\\"}
            // 要把columnName, sObjectType parse出來,
            NSString *resultString = [self formattedStringWithInvalidFieldReason:message
                                                                        pattern:@"No such column '([a-zA-Z0-9_]*)' on sobject of type ([a-zA-Z0-9_]*)"];
            
            // 如果沒有符合，再查另一格式
            // {\\\"message\\\":\\\"\\\\nLastName,FirstName,Salutation,OtherStreet,OtherCity,OtherState\\\\n                              ^\\\\nERROR at Row:1:Column:51\\\\nNo such column \\u0027OtherStreet\\u0027 on entity \\u0027Contact\\u0027. If you are attempting to use a custom field, be sure to append the \\u0027__c\\u0027 after the custom field name. Please reference your WSDL or the describe call for the appropriate names.\\\",\\\"errorCode\\\":\\\"INVALID_FIELD\\\"}
            
            if ([resultString length]==0)
            {
                resultString = [self formattedStringWithInvalidFieldReason:message
                                                                  pattern:@"No such column '([a-zA-Z0-9_]*)' on entity '([a-zA-Z0-9_]*)'"];
            }
            
            // 如果還是沒有，與之前一樣顯示interal error
            if ([resultString length]==0)
            {
                return  [NSString stringWithFormat:WCTRCExportFailureReason_InternalServerError, errorCode];
            }
            
            return resultString;
        }
    }

    return localizedReason;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"guid" : @"guid",
                                                              @"data" : @"data",
                                                              @"company" : @"company",
                                                              @"fullname" : @"fullName"}];
    }
    
    return responseMapping;
}


@end
