//
//  WCTRCTokenObject.m
//  WCTRestClientController
//
//  Created by sanhue on 2019/12/5.
//

#import "WCTRCTokenObject.h"

@implementation WCTRCTokenObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_access_token release];
    _access_token = nil;
    
    [_refresh_token release];
    _refresh_token = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{access_token:%@, refresh_token:%@}",
            [super description],
            self.access_token,
            self.refresh_token
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCTokenObject *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.refresh_token = [[self.refresh_token copyWithZone:zone] autorelease];
            object.access_token = [[self.access_token copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"refresh_token":@"refresh_token",
                                                              @"access_token":@"access_token"}];
    }
    
    return responseMapping;
}
@end
