//
//  WCTRCQContactzAuthTokenVo.m
//  WCTRestClientController
//
//  Created by Howard on 2020/9/28.
//

#import "WCTRCQContactzAuthTokenVo.h"

@implementation WCTRCQContactzAuthTokenVo


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.securityType = WCTRCQContactzAuthTokenVo_SecurityType_User;
    }
    
    return self;
}
//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.account = nil;
    self.password = nil;
    self.securityType = nil;
    self.securityValue = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{account:%@, password:%@, securityType:%@, securityValue:%@}",
            [super description],
            self.account,
            self.password,
            self.securityType,
            self.securityValue];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCQContactzAuthTokenVo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.account = [[self.account copyWithZone:zone] autorelease];
            object.password = [[self.password copyWithZone:zone] autorelease];
            object.securityType = [[self.securityType copyWithZone:zone] autorelease];
            object.securityValue = [[self.securityValue copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:
         @{@"account":@"account",
           @"password":@"password",
           @"securityType":@"securityType",
           @"securityValue":@"securityValue"
        }];
    }
    
    return responseMapping;
}
@end
