//
//  WCTRCCRMSystemResponseResult.m
//  WCTRestClientController
//
//  Created by sanhue on 2020/3/16.
//

#import "WCTRCCRMSystemResponseResult.h"

@implementation WCTRCCRMSystemResponseResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_data release];
    _data = nil;
    
    [_message release];
    _message = nil;
    
    [_errorData release];
    _errorData = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{data:%@, errorData:%@, message:%@}",
            [super description],
            self.data,
            self.errorData,
            self.message];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCRMSystemResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.data = [[self.data copyWithZone:zone] autorelease];
            object.message = [[self.message copyWithZone:zone] autorelease];
            object.errorData = [[self.errorData copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"message":@"message",
                                                              @"errorData":@"errorData"
        }];
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"data"
                                                                                        toKeyPath:@"data"
                                                                                      withMapping:[WCTRCCRMSystem responseMapping]]];
        
    }
    
    return responseMapping;
}

@end
