//
//  WCTRCCRMSystem.m
//  WCTRestClientController
//
//  Created by sanhue on 2020/3/16.
//

#import "WCTRCCRMSystem.h"

@implementation WCTRCCRMSystem

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_supportCRM release];
    _supportCRM = nil;
    
    [_url release];
    _url = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{isCustomized:%@, supportCRM:%@, url:%@}",
            [super description],
            self.isCustomized?@"YES":@"NO",
            self.supportCRM,
            self.url
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCRMSystem *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.isCustomized = self.isCustomized;
            object.supportCRM = [[self.supportCRM copyWithZone:zone] autorelease];
            object.url = [[self.url copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"isCustomized":@"isCustomized",
                                                              @"supportCRM":@"supportCRM",
                                                              @"url":@"url"}];
    }
    
    return responseMapping;
}
@end
