//
//  WCTRCAuthInfo.m
//  WCTRestClientController
//
//  Created by Howard on 2020/9/28.
//

#import "WCTRCAuthInfo.h"

@implementation WCTRCAuthInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_account release];
    _account = nil;

    [_password release];
    _password = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{account:%@, password:%@}",
            [super description],
            self.account,
            self.password
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAuthInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.account = [[self.account copyWithZone:zone] autorelease];
            object.password = [[self.password copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"account":@"account",
                                                 @"password":@"password"}];
    }
    
    return responseMapping;
}

@end
