//
//  WCTRCMyCardSetting.m
//  WCTRestClientController
//
//  Created by sanhue cheng on 2020/10/26.
//

#import "WCTRCMyCardSetting.h"

@implementation WCTRCMyCardSetting


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_infoQRBase64 release];
    _infoQRBase64 = nil;
    
    [_infoUrl release];
    _infoUrl = nil;
    
    [_mycardId release];
    _mycardId = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{enable:%@; infoQRBase64:%@, infoUrl:%@, mycardId:%@}",
            [super description],
            self.enable?@"YES":@"NO",
            self.infoQRBase64,
            self.infoUrl,
            self.mycardId];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCMyCardSetting *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.enable = self.enable;
            object.infoQRBase64 = [[self.infoQRBase64 copyWithZone:zone] autorelease];
            object.infoUrl = [[self.infoUrl copyWithZone:zone] autorelease];
            object.mycardId = [[self.mycardId copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"enable":@"enable",
                                                              @"infoQRBase64":@"infoQRBase64",
                                                              @"infoUrl":@"infoUrl",
                                                              @"mycardId":@"mycardId"
        }];
    }
    
    return responseMapping;
}

@end
