//
//  WCTRCMLCategoryCreationRequest.m
//  
//
//  Created by Howard on 2018/2/13.
//

#import "WCTRCMLCategoryCreationRequest.h"

@implementation WCTRCMLCategoryCreationRequest


#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_name release];
    _name = nil;
    
    [_ownerAccountGuid release];
    _ownerAccountGuid = nil;
    
    [_parentCategoryGuid release];
    _parentCategoryGuid = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{name:%@, ownerAccountGuid:%@, parentCategoryGuid:%@}",
            [super description],
            self.name,
            self.ownerAccountGuid,
            self.parentCategoryGuid];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCMLCategoryCreationRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.name = [[self.name copyWithZone:zone] autorelease];
            object.ownerAccountGuid = [[self.ownerAccountGuid copyWithZone:zone] autorelease];
            object.parentCategoryGuid = [[self.parentCategoryGuid copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"name":@"name",
                                                              @"ownerAccountGuid":@"ownerAccountGuid",
                                                              @"parentCategoryGuid":@"parentCategoryGuid"
                                                              }];
        
    }
    
    return responseMapping;
}

@end
