//
//  WCTRCServerStatus.m
//  ADAL
//
//  Created by sanhue on 2018/5/18.
//

#import "WCTRCServerStatus.h"

@implementation WCTRCServerStatus

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountSubscriptionStatus release];
    _accountSubscriptionStatus = nil;
    
    [_expiredDate release];
    _expiredDate = nil;
    
    [_issueStatus release];
    _issueStatus = nil;
    
    [_subscriptionStatus release];
    _subscriptionStatus = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountSubscriptionStatus:%@, subscriptionStatus:%@, expiredDate:%@, isReadOnly:%@, issueStatsu:%@}",
            [super description],
            self.accountSubscriptionStatus,
            self.subscriptionStatus,
            self.expiredDate,
            self.isReadOnly?@"YES":@"NO",
            self.issueStatus];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCServerStatus *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountSubscriptionStatus = [[self.accountSubscriptionStatus copyWithZone:zone] autorelease];
            object.subscriptionStatus = [[self.subscriptionStatus copyWithZone:zone] autorelease];
            object.expiredDate = [[self.expiredDate copyWithZone:zone] autorelease];
            
            object.isReadOnly = self.isReadOnly;
            object.issueStatus = [[self.issueStatus copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountSubscriptionStatus" : @"accountSubscriptionStatus",
                                                              @"subscriptionStatus" : @"subscriptionStatus",
                                                              @"expiredDate" : @"expiredDate",
                                                              @"isReadOnly" : @"isReadOnly",
                                                              @"issueStatus" : @"issueStatus"
                                                              }];
    }
    
    return responseMapping;
}
@end
