//
//  WCTRCLoginResponseResult.m
//  
//
//  Created by Howard on 2016/3/9.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import "WCTRCLoginResponseResult.h"

@implementation WCTRCLoginResponseResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_data release];
    _data = nil;
    
    [_loginCode release];
    _loginCode = nil;
    
    [_message release];
    _message = nil;
    
    [_errorData release];
    _errorData = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{data:%@, loginCode:%@, message:%@, errorData:%@}",
            [super description],
            self.data,
            self.loginCode,
            self.message,
            self.errorData];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCLoginResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.data = [[self.data copyWithZone:zone] autorelease];
            object.loginCode = [[self.loginCode copyWithZone:zone] autorelease];
            object.message = [[self.message copyWithZone:zone] autorelease];
            object.errorData = [[self.errorData copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"message":@"message",
                                                              @"errorData":@"errorData"}];
        
        //////////////////////////////////////////////////

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"data"
                                                                                        toKeyPath:@"data"
                                                                                      withMapping:[WCTRCLoginInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"loginCode"
                                                                                        toKeyPath:@"loginCode"
                                                                                      withMapping:[WCTRCLoginCode responseMapping]]];        
    }
    
    return responseMapping;
}
@end
