//
//  WCTRCContactSetCategoriesRequest.m
//  
//
//  Created by Howard on 2016/3/23.
//
//

#import "WCTRCContactSetCategoriesRequest.h"

@implementation WCTRCContactSetCategoriesRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryGuids release];
    _categoryGuids = nil;
    
    [_contactGuids release];
    _contactGuids = nil;
    
    [_behavior release];
    _behavior = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryGuids:%@, contactGuids:%@, behavior:%@}",
            [super description],
            self.categoryGuids,
            self.contactGuids,
            self.behavior];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactSetCategoriesRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryGuids = [[self.categoryGuids copyWithZone:zone] autorelease];
            object.contactGuids = [[self.contactGuids copyWithZone:zone] autorelease];
            object.behavior = [[self.behavior copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryGuids":@"categoryGuids",
                                                              @"contactGuids":@"contactGuids",
                                                              @"setBehavior":@"behavior"}];
    }
    
    return responseMapping;
}
@end
