//
//  WCTRCContactGetByAccountRequest.m
//  
//
//  Created by Howard on 2016/3/24.
//
//

#import "WCTRCContactPageRequest.h"

@implementation WCTRCContactPageRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_pageInfo release];
    _pageInfo = nil;
    
    [_intervalFilter release];
    _intervalFilter = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{pageInfo:%@, intervalFilter:%@}",
            [super description],
            self.pageInfo,
            self.intervalFilter];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactPageRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.pageInfo = [[self.pageInfo copyWithZone:zone] autorelease];
            object.intervalFilter = [[self.intervalFilter copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        //////////////////////////////////////////////////

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"pageInfo"
                                                                                        toKeyPath:@"pageInfo"
                                                                                      withMapping:[WCTRCPageInfo responseMapping]]];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"intervalFilter"
                                                                                        toKeyPath:@"intervalFilter"
                                                                                      withMapping:[WCTRCTimeIntervalFilter responseMapping]]];
    }
    
    return responseMapping;
}
@end
