//
//  WCTRCContactInfo.m
//  
//
//  Created by Howard on 2016/3/23.
//
//

#import "WCTRCContactInfo.h"

@implementation WCTRCContactInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_addresses release];
    _addresses = nil;
    
    [_beSharedAccounts release];
    _beSharedAccounts = nil;
    
    [_belongCategories release];
    _belongCategories = nil;

    [_createTime release];
    _createTime = nil;
    
    [_birthday release];
    _birthday = nil;
    
    [_creatorGuid release];
    _creatorGuid = nil;
    
    [_creatorName release];
    _creatorName = nil;

    [_customFields release];
    _customFields = nil;
   
    [_dates release];
    _dates = nil;
    
    [_editorGuid release];
    _editorGuid = nil;
    
    [_editorName release];
    _editorName = nil;
    
    [_emails release];
    _emails = nil;
    
    [_guid release];
    _guid = nil;
    
    [_images release];
    _images = nil;

    [_ims release];
    _ims = nil;
    
    [_jobinfos release];
    _jobinfos = nil;
    
    [_modifyTime release];
    _modifyTime = nil;
    
    [_modifyTimeForDisplay release];
    _modifyTimeForDisplay = nil;
    
    [_nickname release];
    _nickname = nil;
    
    [_note release];
    _note = nil;
    
    [_names release];
    _names = nil;
    
    [_ownerGuid release];
    _ownerGuid = nil;
    
    [_ownerName release];
    _ownerName = nil;
    
    [_phones release];
    _phones = nil;
    
    [_socials release];
    _socials = nil;
    
    [_uniformNumber release];
    _uniformNumber = nil;
    
    [_urls release];
    _urls = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{addresses:%@, beCorrected:%d, beFavorite:%d, beSharedAccounts:%@, belongCategories:%@, birthday:%@, createTime:%@, creatorGuid:%@, creatorName:%@, customFields:%@, dates:%@, editorGuid:%@, editorName:%@, emails:%@, guid:%@, images:%@, ims:%@, jobinfos:%@, modifyTime:%@, modifyTimeForDisplay:%@, names:%@, nickname:%@, note:%@, ownerGuid:%@, ownerName:%@, phones:%@, recogLanguageBack:%ld, recogLanguageFront:%ld, socials:%@, uniformNumber:%@, urls:%@}",
            [super description],
            self.addresses,
            self.beCorrected,
            self.beFavorite,
            self.beSharedAccounts,
            self.belongCategories,
            self.birthday,
            self.createTime,
            self.creatorGuid,
            self.creatorName,
            self.customFields,
            self.dates,
            self.editorGuid,
            self.editorName,
            self.emails,
            self.guid,
            self.images,
            self.ims,
            self.jobinfos,
            self.modifyTime,
            self.modifyTimeForDisplay,
            self.names,
            self.nickname,
            self.note,
            self.ownerGuid,
            self.ownerName,
            self.phones,
            (long)self.recogLanguageBack,
            (long)self.recogLanguageFront,
            self.socials,
            self.uniformNumber,
            self.urls];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.addresses = [[self.addresses copyWithZone:zone] autorelease];
            object.beCorrected = self.beCorrected;
            object.beFavorite = self.beFavorite;
            object.beSharedAccounts = [[self.beSharedAccounts copyWithZone:zone] autorelease];
            object.belongCategories = [[self.belongCategories copyWithZone:zone] autorelease];
            object.birthday = [[self.birthday copyWithZone:zone] autorelease];
            object.createTime = [[self.createTime copyWithZone:zone] autorelease];
            object.creatorGuid = [[self.creatorGuid copyWithZone:zone] autorelease];
            object.creatorName = [[self.creatorName copyWithZone:zone] autorelease];
            object.customFields = [[self.customFields copyWithZone:zone] autorelease];
            object.dates = [[self.dates copyWithZone:zone] autorelease];
            object.editorGuid = [[self.editorGuid copyWithZone:zone] autorelease];
            object.editorName = [[self.editorName copyWithZone:zone] autorelease];
            object.emails = [[self.emails copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.images = [[self.images copyWithZone:zone] autorelease];
            object.ims = [[self.ims copyWithZone:zone] autorelease];
            object.jobinfos = [[self.jobinfos copyWithZone:zone] autorelease];
            object.modifyTime = [[self.modifyTime copyWithZone:zone] autorelease];
            object.modifyTimeForDisplay = [[self.modifyTimeForDisplay copyWithZone:zone] autorelease];
            object.names = [[self.names copyWithZone:zone] autorelease];
            object.nickname = [[self.nickname copyWithZone:zone] autorelease];
            object.note = [[self.note copyWithZone:zone] autorelease];
            object.ownerGuid = [[self.ownerGuid copyWithZone:zone] autorelease];
            object.ownerName = [[self.ownerName copyWithZone:zone] autorelease];
            object.phones = [[self.phones copyWithZone:zone] autorelease];
            object.recogLanguageBack = self.recogLanguageBack;
            object.recogLanguageFront = self.recogLanguageFront;
            object.socials = [[self.socials copyWithZone:zone] autorelease];
            object.uniformNumber = [[self.uniformNumber copyWithZone:zone] autorelease];
            object.urls = [[self.urls copyWithZone:zone] autorelease];
        }
    }

    return object;
}




//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"beFavorite":@"beFavorite",
                                                              @"beCorrected":@"beCorrected",
                                                              @"birthday":@"birthday",
                                                              @"createTime":@"createTime",
                                                              @"creatorGuid":@"creatorGuid",
                                                              @"creatorName":@"creatorName",
                                                              @"guid":@"guid",
                                                              @"editorGuid":@"editorGuid",
                                                              @"editorName":@"editorName",
                                                              @"modifyTime":@"modifyTime",
                                                              @"modifyTimeForDisplay":@"modifyTimeForDisplay",
                                                              @"nickname":@"nickname",
                                                              @"note":@"note",
                                                              @"ownerGuid":@"ownerGuid",
                                                              @"ownerName":@"ownerName",
                                                              @"recogLanguageBack":@"recogLanguageBack",
                                                              @"recogLanguageFront":@"recogLanguageFront",
                                                              @"uniformNumber":@"uniformNumber"}];
        
        //////////////////////////////////////////////////

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"addresses"
                                                                                        toKeyPath:@"addresses"
                                                                                      withMapping:[WCTRCContactAddressInfo responseMapping]]];

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"customDataList"
                                                                                        toKeyPath:@"customFields"
                                                                                      withMapping:[WCTRCContactCustomFieldData responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"dates"
                                                                                        toKeyPath:@"dates"
                                                                                      withMapping:[WCTRCContactDateInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"emails"
                                                                                        toKeyPath:@"emails"
                                                                                      withMapping:[WCTRCContactMailInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"images"
                                                                                        toKeyPath:@"images"
                                                                                      withMapping:[WCTRCContactImageInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"ims"
                                                                                        toKeyPath:@"ims"
                                                                                      withMapping:[WCTRCContactIMInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"jobinfos"
                                                                                        toKeyPath:@"jobinfos"
                                                                                      withMapping:[WCTRCContactJobInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"names"
                                                                                        toKeyPath:@"names"
                                                                                      withMapping:[WCTRCContactNameInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"phones"
                                                                                        toKeyPath:@"phones"
                                                                                      withMapping:[WCTRCContactPhoneInfo responseMapping]]];

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"socials"
                                                                                        toKeyPath:@"socials"
                                                                                      withMapping:[WCTRCContactSocialInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"urls"
                                                                                        toKeyPath:@"urls"
                                                                                      withMapping:[WCTRCContactUrlInfo responseMapping]]];
        
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"beSharedAccounts"
                                                                                        toKeyPath:@"beSharedAccounts"
                                                                                      withMapping:[WCTRCAccountLessInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"belongCategories"
                                                                                        toKeyPath:@"belongCategories"
                                                                                      withMapping:[WCTRCCategoryInfo responseMapping]]];
    }
    
    return responseMapping;
}
@end
