//
//  WCTRCSimpleCategoryInfo.m
//  Pods
//
//  Created by sanhue on 2016/10/26.
//
//

#import "WCTRCSimpleCategoryInfo.h"

@implementation WCTRCSimpleCategoryInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_guid release];
    _guid = nil;
    
    [_name release];
    _name = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guid:%@, name:%@}",
            [super description],
            self.guid,
            self.name];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCSimpleCategoryInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.name = [[self.name copyWithZone:zone] autorelease];
        }
    }
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"guid":@"guid",
                                                              @"name":@"name"}];
    }
    
    return responseMapping;
}

@end
