//
//  WCTSalesforceAccountSearchResult.m
//  AppAuth
//
//  Created by Howard on 2020/4/28.
//

#import "WCTSalesforceAccountSearchResult.h"

@implementation WCTSalesforceAccountSearchResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.records = nil;
  
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{records:%@, totalSize:%td}",
            [super description],
            self.records,
            self.totalSize];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTSalesforceAccountSearchResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.records = [[self.records copyWithZone:zone] autorelease];
            object.totalSize = self.totalSize;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"totalSize":@"totalSize"
        }];
    
        //////////////////////////////////////////////////
           
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"records"
                                 toKeyPath:@"records"
                               withMapping:[WCTSalesForceSearchRecord responseMapping]]];
    }
    
    return responseMapping;
}
@end
