//
//  WCTRestClient+Sync.m
//  Pods
//
//  Created by sanhue on 2016/3/29.
//
//

#import "WCTRestClient+Sync.h"
#import "NSDate+Format.h"

@implementation WCTRestClient (Sync)


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncCreateCategoryWithLoginToken:(NSString *)loginToken
                                               categoryRequest:(WCTRCCategoryInfo *)categoryRequest
                                                       success:(void (^)(WCTRCSyncCategoryCreateResponseResult *syncCategoryCreateResponseResult))success
                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           categoryRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCCategoryInfo class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSyncCategoryCreateResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_CategoryCreate]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:categoryRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_Sync_CategoryCreate
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncDeleteCategoryWithLoginToken:(NSString *)loginToken
                                                  categoryGuid:(NSString *)categoryGuid
                                                       success:(void (^)(WCTRCSyncCategoryDeleteResponseResult *syncCategoryCreateResponseResult))success
                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           [categoryGuid length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSyncCategoryCreateResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_CategoryDelete]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        NSString *pathPattern = [WCTClientPath_Sync_CategoryDelete stringByAppendingString:[NSString stringWithFormat:@"?categoryGuid=%@",categoryGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncGetCategoryWithLoginToken:(NSString *)loginToken
                                               categoryGuid:(NSString *)categoryGuid
                                                    success:(void (^)(WCTRCDetailCategoryInfoResponseResult *sycCategoryInfoResponseResult))success
                                                    failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           [categoryGuid length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCDetailCategoryInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_CategoryGet]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        NSString *pathPattern = [WCTClientPath_Sync_CategoryGet stringByAppendingString:[NSString stringWithFormat:@"?categoryGuid=%@", categoryGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
    
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncUpdateCategoryWithLoginToken:(NSString *)loginToken
                                               categoryRequest:(WCTRCCategoryInfo *)categoryRequest
                                                       success:(void (^)(WCTRCSyncCategoryUpdateResponseResult *syncCategoryUpdateResponseResult))success
                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           categoryRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCCategoryInfo class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSyncCategoryUpdateResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_CategoryUpdate]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:categoryRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_Sync_CategoryUpdate
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncCreateContactWithLoginToken:(NSString *)loginToken
                                                      request:(WCTRCContactCreationWithImageRequest *)request
                                                      success:(void (^)(WCTRCContactProfileResponseResult *syncContactResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           request==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactCreationWithImageRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactProfileResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_ContactCreate]==NO)
        {
            error = WCTRestClientErrorMake(@"add addResponseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_Sync_ContactCreate
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncIsExistContactWithLoginToken:(NSString *)loginToken
                                                   contactGuid:(NSString *)contactGuid
                                                   accountGuid:(NSString *)accountGuid
                                                       success:(void (^)(WCTRCBooleanResponseResult *syncIsExistContactResponseReuslt))success
                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           [contactGuid length]==0 ||
           [accountGuid length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCBooleanResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_ContactIsExist]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        NSString *pathPattern = [WCTClientPath_Sync_ContactIsExist stringByAppendingString:[NSString stringWithFormat:@"?contactGuid=%@&AccountID=%@",contactGuid, accountGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncDeleteContactWithLoginToken:(NSString *)loginToken
                                                  contactGuid:(NSString *)contactGuid
                                                  accountGuid:(NSString *)accountGuid
                                                      success:(void (^)(WCTRCSyncContactDeleteResponseResult *syncContactDeleteResponseReuslt))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           [contactGuid length]==0 ||
           [accountGuid length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSyncContactDeleteResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_ContactDelete]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        NSString *pathPattern = [WCTClientPath_Sync_ContactDelete stringByAppendingString:[NSString stringWithFormat:@"?contactGuid=%@&accountGuid=%@",contactGuid, accountGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncGetContactWithLoginToken:(NSString *)loginToken
                                               contactGuid:(NSString *)contactGuid
                                                   success:(void (^)(WCTRCDetailContactInfoResponseResult *sycContactInfoResponseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           [contactGuid length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCDetailContactInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_ContactGet]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        NSString *pathPattern = [WCTClientPath_Sync_ContactGet stringByAppendingString:[NSString stringWithFormat:@"?contactGuid=%@",contactGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
    
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncUpdateContactWithLoginToken:(NSString *)loginToken
                                                      request:(WCTRCContactUpdateInfoRequest *)request
                                                      success:(void (^)(WCTRCContactProfileResponseResult *syncUpdateContactResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           request==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactUpdateInfoRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactProfileResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_ContactUpdate]==NO)
        {
            error = WCTRestClientErrorMake(@"add addResponseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_Sync_ContactUpdate
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncContactUpdateCheckWithLoginToken:(NSString *)loginToken
                                                           request:(WCTRCContactUpdateCheckRequest *)request
                                                           success:(void (^)(WCTRCSyncContactUpdateCheckResponseResult *syncContactUpdateCheckResult))success
                                                           failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           request==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactUpdateCheckRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSyncContactUpdateCheckResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_ContactUpdateCheck]==NO)
        {
            error = WCTRestClientErrorMake(@"add addResponseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_Sync_ContactUpdateCheck
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncContactCheckStatusWithLoginToken:(NSString *)loginToken
                                                           request:(WCTRCSyncContactCheckRequest *)request
                                                           success:(void (^)(WCTRCSyncUpdateActionResponseResult *syncContactUpdateCheckResponseResult))success
                                                           failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           request==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCSyncContactCheckRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSyncUpdateActionResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_ContactCheckStatus]==NO)
        {
            error = WCTRestClientErrorMake(@"add addResponseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_Sync_ContactCheckStatus
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)needForceCompareWithLoginToken:(NSString *)loginToken
                                          contactLastRecTime:(NSDate *)contactLastRecTime
                                                     success:(void (^)(WCTRCSyncNeedForceCompareResponseResult *needForceCompareResponseResult))success
                                                     failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSyncNeedForceCompareResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_IsNeedForceCompare]==NO)
        {
            error = WCTRestClientErrorMake(@"add addResponseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        NSString *contactLastRecTimeString = [[contactLastRecTime stringWithFormat:WCTRestClient_ServerDateFormat] stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
    
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_Sync_IsNeedForceCompare stringByAppendingString:[NSString stringWithFormat:@"?ContactLastRecTime=%@",contactLastRecTimeString]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncStartWithLoginToken:(NSString *)loginToken
                                             syncInfo:(WCTRCSyncInfo *)syncInfo
                                              success:(void (^)(WCTRCStartSyncResponseResult *startSyncResponseResult))success
                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           syncInfo==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCSyncInfo class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        
        if([self addResponseDescriptorForObjectClass:[WCTRCStartSyncResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_Start]==NO)
        {
            error = WCTRestClientErrorMake(@"add addResponseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:syncInfo
                     byObjectManager:objectManager
                                path:WCTClientPath_Sync_Start
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)syncDoneWithLoginToken:(NSString *)loginToken
                                             success:(void (^)(WCTRCMessageResponseResult *syncDoneMessageResponseResult))success
                                             failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Sync_Done]==NO)
        {
            error = WCTRestClientErrorMake(@"add addResponseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Sync_Done
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


@end
