//
//  WCTRestClient+Subscribe.m
//  
//
//  Created by Howard on 2018/9/10.
//

#import "WCTRestClient+Subscribe.h"

@implementation WCTRestClient (Subscribe)

#pragma mark - Instance Subscribe Method

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)subscriptionResponseResultWithLoginToken:(NSString *)loginToken
                                                       success:(void (^)(WCTRCSubscriptionInfoVoResponseResult *subscriptionInfoVoResponseResult))success
                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(loginToken==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSubscriptionInfoVoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Subscribe_GetSubscriptionInfo]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Subscribe_GetSubscriptionInfo
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)refreshSubscriptionInfoVoWithLoginToken:(NSString *)loginToken
                                                              success:(void (^)(WCTRCRefreshSubscriptionInfoToServerResult *refreshSubscriptionInfoToServerResult))success
                                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(loginToken==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCRefreshSubscriptionInfoToServerResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Subscribe_RefreshSubscriptionInfoToServer]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Subscribe_RefreshSubscriptionInfoToServer
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)subscribedAccountLimitWithLoginToken:(NSString *)loginToken
                                                           success:(void (^)(WCTRCGetAccountLimitResult *accountLimitResult))success
                                                           failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(loginToken==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCGetAccountLimitResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Subscribe_GetAccountLimit]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_Subscribe_GetAccountLimit
                         parameters:nil
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)subscriptionURLWithLoginToken:(NSString *)loginToken
                                                    success:(void (^)(WCTRCGetSubscriptionURLResponseResult *subscriptionURLResponseResult))success
                                                    failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(loginToken==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCGetSubscriptionURLResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Subscribe_GetSubscriptionURL]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Subscribe_GetSubscriptionURL
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)upgradeFromRetailWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCBooleanResponseResult *responseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(loginToken==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCBooleanResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Subscribe_UpgradeFromRetail]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Subscribe_UpgradeFromRetail
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}

@end
