//
//  WCTRestClient+Register.m
//  Extension
//
//  Created by Howard on 2018/7/23.
//

#import "WCTRestClient+Register.h"

@implementation WCTRestClient (Register)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serverAllRegistryWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCAllRegistryListResponseResult *allRegistryListResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////

        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAllRegistryListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Register_GetAllRegistry]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_Register_GetAllRegistry
                         parameters:nil
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}






@end
