//
//  WCTRestClient+PrivateContact.m
//
//
//  Created by Howard on 2016/3/16.
//
//

#import "WCTRestClient+PrivateContact.h"

@implementation WCTRestClient (PrivateContact)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactOperateCategoryWithLoginToken:(NSString *)loginToken
                                              contactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                  success:(void (^)(WCTRCPrivateContactOperateCategoryResponseResult *privateContactOperateCategoryResponseResult))success
                                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactSetCategoriesRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactSetCategoriesRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactOperateCategoryResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_OperateCategory]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactSetCategoriesRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_OperateCategory
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)updatePrivateContactWithLoginToken:(NSString *)loginToken
                                        contactUpdateInfoRequest:(WCTRCContactUpdateInfoRequest *)contactUpdateInfoRequest
                                                         success:(void (^)(WCTRCPrivateContactUpdateResponseResult *privateContactUpdateResponseResult))success
                                                         failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactUpdateInfoRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[contactUpdateInfoRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactUpdateResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_Update]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactUpdateInfoRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_Update
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)uploadPrivateContactImageWithLoginToken:(NSString *)loginToken
                                                                image:(CPImage *)image
                                                             fileName:(NSString *)fileName
                                                             mineType:(NSString *)mineType
                                                              success:(void (^)(WCTRCPrivateContactUploadImageResponseResult *privateContactUploadImageResponseResult))success
                                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           image==nil ||
           [fileName length]<=0 ||
           [mineType length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactUploadImageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_UploadImage]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSData *imageData = [self dataForImage:image mineType:mineType];
        
        //////////////////////////////////////////////////
        
        operation = [self multipartFormRequestWithObject:nil
                                         byObjectManager:objectManager
                                                  method:RKRequestMethodPOST
                                                    path:WCTClientPath_PrivateContact_UploadImage
                                                    data:imageData
                                                    name:@"multipartFile"
                                                fileName:fileName
                                                mimeType:mineType
                                              parameters:nil
                                    httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                                                 success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                                                 failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)manualUploadPrivateContactWithLoginToken:(NSString *)loginToken
                                       contactCreationWithImageRequest:(WCTRCContactCreationWithImageRequest *)contactCreationWithImageRequest
                                                               success:(void (^)(WCTRCPrivateContactManualUploadResponseResult *privateContactScanUploadResponseResult))success
                                                               failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactCreationWithImageRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactCreationWithImageRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactManualUploadResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_CreateWithPreUploadImage]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactCreationWithImageRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_CreateWithPreUploadImage
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)scanUploadPrivateContactWithLoginToken:(NSString *)loginToken
                                     contactCreationWithImageRequest:(WCTRCContactCreationWithImageRequest *)contactCreationWithImageRequest
                                          contactReceiverAccountGuid:(NSString *)contactReceiverAccountGuid
                                                             success:(void (^)(WCTRCPrivateContactScanUploadResponseResult *privateContactManualUploadResponseResult))success
                                                             failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactCreationWithImageRequest==nil ||
           [contactReceiverAccountGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactCreationWithImageRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactManualUploadResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_CreateWithPreUploadImageForAccount]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////

        NSString *urlPath = [WCTClientPath_PrivateContact_CreateWithPreUploadImageForAccount stringByAppendingString:[NSString stringWithFormat:@"?contactReceiverAccountGuid=%@",contactReceiverAccountGuid]];
        
        if([urlPath length]<=0)
        {
            error = WCTRestClientErrorMake(@"urlPath lengh is zero", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactCreationWithImageRequest
                     byObjectManager:objectManager
                                path:urlPath
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)deletePrivateContactWithLoginToken:(NSString *)loginToken
                                                    contactGuids:(NSArray *)contactGuids
                                                         success:(void (^)(WCTRCPrivateContactDeleteResponseResult *privateContactDeleteResponseResult))success
                                                         failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuids count]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactDeleteResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_Delete]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_Delete
                          parameters:@{@"list":contactGuids}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactListUnderCategoryWithLoginToken:(NSString *)loginToken
                                                contactGetByCategoryRequest:(WCTRCContactGetByCategoryRequest *)contactGetByCategoryRequest
                                                                    success:(void (^)(WCTRCPrivateContactListResponseResult *privateContactListResponseResult))success
                                                                    failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactGetByCategoryRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactGetByCategoryRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_GetByCategory]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactGetByCategoryRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_GetByCategory
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactListUnderAccountWithLoginToken:(NSString *)loginToken
                                                contactGetByAccountRequest:(WCTRCContactGetByAccountRequest *)contactGetByAccountRequest
                                                                   success:(void (^)(WCTRCPrivateContactListResponseResult *privateContactListResponseResult))success
                                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactGetByAccountRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactGetByAccountRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_GetByAccount]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactGetByAccountRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_GetByAccount
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactNumberUnderAccountWithLoginToken:(NSString *)loginToken
                                                                 accountGuid:(NSString *)accountGuid
                                                                     success:(void (^)(WCTRCPrivateContactNumberResponseResult *privateContactNumberResponseResult))success
                                                                     failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [accountGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactNumberResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_GetNumberByAccount]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_PrivateContact_GetNumberByAccount stringByAppendingString:[NSString stringWithFormat:@"?accountGuid=%@",accountGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)toggleFavoriteContactWithLoginToken:(NSString *)loginToken
                                       contactsSetFavoriteRequest:(WCTRCContactsSetFavoriteRequest *)contactsSetFavoriteRequest
                                                          success:(void (^)(WCTRCPrivateContactToggleFavoriteResponseResult *privateContactToggleFavoriteResponseResult))success
                                                          failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactsSetFavoriteRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactsSetFavoriteRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactToggleFavoriteResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_ToggleFavorite]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactsSetFavoriteRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_ToggleFavorite
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactListSetCorrectedWithLoginToken:(NSString *)loginToken
                                                              contactGuids:(NSArray *)contactGuids
                                                                   success:(void (^)(WCTRCPrivateContactListSetCorrectedResponseResult *privateContactListSetCorrectedResponseResult))success
                                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuids count]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactListSetCorrectedResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_ListAsCorrected]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = WCTClientPath_PrivateContact_ListAsCorrected;
        
        for(NSString *contactGuid in contactGuids)
        {
            if(contactGuid==[contactGuids firstObject])
            {
                pathPattern = [pathPattern stringByAppendingString:@"?contactGuids="];
            }
            
            pathPattern = [pathPattern stringByAppendingString:[NSString stringWithFormat:@"%@",contactGuid]];
            
            if(contactGuid!=[contactGuids lastObject])
            {
                pathPattern = [pathPattern stringByAppendingString:@"&"];
            }
        }
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactsRemoveCategoryWithLoginToken:(NSString *)loginToken
                                        contactsRemoveFromCategoryRequest:(WCTRCContactsRemoveFromCategoryRequest *)contactsRemoveFromCategoryRequest
                                                                  success:(void (^)(WCTRCContactsRemoveFromCategoryResponseResult *contactsRemoveFromCategoryResponseResult))success
                                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactsRemoveFromCategoryRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactsRemoveFromCategoryRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactListSetCorrectedResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_RemoveFromCategory]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactsRemoveFromCategoryRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_RemoveFromCategory
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactWithLoginToken:(NSString *)loginToken
                                               contactGuid:(NSString *)contactGuid
                                                   success:(void (^)(WCTRCPrivateContactResponseResult *privateContactResponseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_GetContact]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_PrivateContact_GetContact
                         parameters:@{@"contactGuid":contactGuid}
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactImageBase64WithLoginToken:(NSString *)loginToken
                                                          contactGuid:(NSString *)contactGuid
                                                            imageType:(NSString *)imageType
                                                              success:(void (^)(WCTRCPrivateContactImageBase64ResponseResult *privateContactImageBase64ResponseResult))success
                                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuid length]<=0 ||
           [imageType length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactImageBase64ResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_ImageBase64]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_PrivateContact_ImageBase64
                         parameters:@{@"contactGuid":contactGuid,
                                      @"imageType":imageType}
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
    
}


//================================================================================
//
//================================================================================
- (AFRKImageRequestOperation *)privateContactImageWithLoginToken:(NSString *)loginToken
                                                     contactGuid:(NSString *)contactGuid
                                                       imageType:(NSString *)imageType
                                                         success:(void (^)(CPImage *image))success
                                                         failure:(void (^)(NSError *error))failure
{
    AFRKImageRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuid length]<=0 ||
           [imageType length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_Image];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getImageWithObject:nil
                               objectManager:objectManager
                                        path:WCTClientPath_PrivateContact_Image
                                  parameters:@{@"contactGuid":contactGuid,
                                               @"imageType":imageType}
                        httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                                     success:^(NSURLRequest *request, NSHTTPURLResponse *response, CPImage *image) {
                                         
                                         self.lastOperationDate = [NSDate date];
                                         
                                         //////////////////////////////////////////////////
                                         
                                         if(success!=NULL)
                                         {
                                             success(image);
                                         }
                                     }
                                     failure:^(NSURLRequest *request, NSHTTPURLResponse *response, NSError *error) {
                                         if(failure!=NULL)
                                         {
                                             failure(error);
                                         }
                                     }];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//================================================================================
//
//================================================================================
- (AFRKHTTPRequestOperation *)privateContactImageDataWithLoginToken:(NSString *)loginToken
                                                        contactGuid:(NSString *)contactGuid
                                                          imageType:(NSString *)imageType
                                                            success:(void (^)(NSData *data))success
                                                            failure:(void (^)(NSError *error))failure
{
    AFRKHTTPRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuid length]<=0 ||
           [imageType length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_Image];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
     
        //////////////////////////////////////////////////
    
        operation = [self getDataWithObject:nil
                              objectManager:objectManager
                                       path:WCTClientPath_PrivateContact_Image
                                 parameters:@{@"contactGuid":contactGuid,
                                              @"imageType":imageType}
                       httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                                    success:^(AFRKHTTPRequestOperation *operation, NSData *responseData) {
                                        
                                        self.lastOperationDate = [NSDate date];
                                        
                                        //////////////////////////////////////////////////
                                        
                                        if(success!=NULL)
                                        {
                                            success(responseData);
                                        }
                                    } failure:^(AFRKHTTPRequestOperation *operation, NSError *error) {
                                        if(failure!=NULL)
                                        {
                                            failure(error);
                                        }
                                    }];
        
        if(operation==nil)
        {
            error = WCTRestClientErrorMake(@"operation = nil", error);
            break;
        }
    
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)privateContactOperateMultiCategoryWithLoginToken:(NSString *)loginToken
                                                   contactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                       success:(void (^)(WCTRCPrivateContactOperateCategoryResponseResult *privateContactOperateCategoryResponseResult))success
                                                                       failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactSetCategoriesRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactSetCategoriesRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactOperateCategoryResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_AddOrSetCategory]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactSetCategoriesRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_AddOrSetCategory
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - TSMC methods


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)privateNoAccountSFContactWithLoginToken:(NSString *)loginToken
                                                   contactPageRequest:(WCTRCContactPageRequest *)contactPageRequest
                                                              success:(void (^)(WCTRCPrivateContactListResponseResult *contactListResponseResult))success
                                                              failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactPageRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[contactPageRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPrivateContactListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PrivateContact_UnexportedToSalesforce]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactPageRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PrivateContact_UnexportedToSalesforce
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


@end
