//
//  WCTRestClient+NormalUserSetting.h
//  
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRestClient.h"

// Model
#import "WCTRCAccountSharedTargetListRequest.h"
#import "WCTRCAccountSharedTargetRequest.h"
#import "WCTRCUpdateCRMTokenRequest.h"
#import "WCTRCAccountSharedTargetsResponseResult.h"
#import "WCTRCAllUserSettingsResponseResult.h"
#import "WCTRCAsianSurnameOrderResult.h"
#import "WCTRCAutoShareResponseResult.h"
#import "WCTRCAutoShareToAllResponseResult.h"
#import "WCTRCChineseRecognizeResultOutputResponseResult.h"
#import "WCTRCCRMSettingsResponseResult.h"
#import "WCTRCNowMapEngineResponseResult.h"
#import "WCTRCSetAutoShareSettingResponseResult.h"
#import "WCTRCSetChineseRecognizeOutputResponseResult.h"
#import "WCTRCSetSortByFieldResponseResult.h"
#import "WCTRCSetSurnameOrderResponseResult.h"
#import "WCTRCSetUserMapEngineResponseResult.h"
#import "WCTRCSetUserShowOwnerFlagSettingResponseResult.h"
#import "WCTRCSetEditAfterRecogResponseResult.h"
#import "WCTRCSetAddNoteInfoAfterRecogResponseResult.h"
#import "WCTRCShareRoleResponseResult.h"
#import "WCTRCSortByFieldResponseResult.h"
#import "WCTRCSupportMapEngineResponseResult.h"
#import "WCTRCUserShowOwnerFlagSettingResponseResult.h"
#import "WCTRCWesternSurnameOrderSettingResult.h"
#import "WCTRCUserExportInfoResponseResult.h"
#import "WCTRCCustomFieldListResponseResult.h"
#import "WCTRCExchangeServerSettings.h"
#import "WCTRCExchangeServerSettingsResponseResult.h"
#import "WCTRCExchangeServerSystemResponseResult.h"
#import "WCTRCExchangeServerTokenSettings.h"
#import "WCTRCCRMSystemResponseResult.h"
#import "WCTRCCRMUserAgentOAuthTokenResponseResult.h"
#import "WCTRCQContactzAuthTokenVo.h"
#import "WCTRCQContactzEmailResponseResult.h"
#import "WCTRCQContactzAuthInfoResponseResult.h"
#import "WCTRCAuthInfo.h"
#import "WCTRCPCSSettingResponseResult.h"
#import "WCTRCTransferQuotaRequest.h"


@interface WCTRestClient (NormalUserSetting)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


/**
 *  取得所有設定值
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)allUserSettingsWithLoginToken:(NSString *)loginToken
                                                    success:(void (^)(WCTRCAllUserSettingsResponseResult *allUserSettingsResponseResult))success
                                                    failure:(void (^)(NSError *error))failure;


/**
 *  支援地圖類型
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)supportMapEnginesWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCSupportMapEngineResponseResult *listResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;



/**
 *  現在使用的地圖類型
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)nowMapEnginesWithLoginToken:(NSString *)loginToken
                                                  success:(void (^)(WCTRCNowMapEngineResponseResult *nowMapEngineResponseResult))success
                                                  failure:(void (^)(NSError *error))failure;


/**
 *  東方姓名顯示順序
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)asianSurnameOrderWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCAsianSurnameOrderResult *asianSurnameOrderResult))success
                                                      failure:(void (^)(NSError *error))failure;


/**
 *  西方姓名顯示順序
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)westernSurnameOrderWithLoginToken:(NSString *)loginToken
                                                        success:(void (^)(WCTRCWesternSurnameOrderSettingResult *westernSurnameOrderSettingResult))success
                                                        failure:(void (^)(NSError *error))failure;


/**
 *  是否開啟自動分享
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)autoShareSettingWithLoginToken:(NSString *)loginToken
                                                     success:(void (^)(WCTRCAutoShareResponseResult *autoShareResponseResult))success
                                                     failure:(void (^)(NSError *error))failure;



/**
 *  分享列表
 *
 *  @param loginToken 登入 Token
 *  @param shareItem 要取得的列表是哪一種分享資料的列表，參考 WCTRestObject+ParameterDefine.h WCTRC_ShareItem
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)accountSharedTargetsWithLoginToken:(NSString *)loginToken
                                                       shareItem:(NSString *)shareItem
                                                         success:(void (^)(WCTRCAccountSharedTargetsResponseResult *accountSharedTargetsResponseResult))success
                                                         failure:(void (^)(NSError *error))failure;


/**
 *  取得全公司共享設定
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)globalShareRoleWithLoginToken:(NSString *)loginToken
                                                    success:(void (^)(WCTRCShareRoleResponseResult *shareRoleResponseResult))success
                                                    failure:(void (^)(NSError *error))failure;


/**
 *  取得中文辨識結果輸出的值
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)chineseRecognizeResultOutputWithLoginToken:(NSString *)loginToken
                                                                 success:(void (^)(WCTRCChineseRecognizeResultOutputResponseResult *chineseRecognizeResultOutputResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure;


/**
 *  取得依欄位排序的值
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)sortByFieldWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCSortByFieldResponseResult *sortByFieldResponseResult))success
                                                failure:(void (^)(NSError *error))failure;



/**
 *  取得所有的自訂欄位內容
 *
 *  @param loginToken 登入 Token
 *  @param customFieldCategory 要取得的自訂欄位類別 (WCTRC_CustomField_Category_Contact，WCTRC_CustomField_Category_Task，WCTRC_CustomField_Category_Activity)
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)customFieldInfosWithLoginToken:(NSString *)loginToken
                                         customFieldCategory:(NSString *)customFieldCategory
                                                     success:(void (^)(WCTRCCustomFieldListResponseResult *customFieldListResponseResult))success
                                                     failure:(void (^)(NSError *error))failure;

/**
 *  取得系統值
 *
 *  @param loginToken 登入 Token
 *  @param propertyType 要取得的值的type
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)propertyWithLoginToken:(NSString *)loginToken
                                        propertyType:(NSString *)propertyType
                                             success:(void (^)(WCTRCMessageResponseResult *maxContactsCountResponseResult))success
                                             failure:(void (^)(NSError *error))failure;

/**
 *  設定東方姓名順序
 *
 *  @param loginToken 登入 Token
 *  @param nameOrder  WCTRC_NameOrder_FirstNameLastName or WCTRC_NameOrder_LastNameFirstName
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setAsianSurnameOrderWithLoginToken:(NSString *)loginToken
                                                       nameOrder:(NSString *)nameOrder
                                                         success:(void (^)(WCTRCSetSurnameOrderResponseResult *setSurnameOrderResponseResult))success
                                                         failure:(void (^)(NSError *error))failure;


/**
 *  設定西方姓名順序
 *
 *  @param loginToken 登入 Token
 *  @param nameOrder  WCTRC_NameOrder_FirstNameLastName or WCTRC_NameOrder_LastNameFirstName
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setWesternSurnameOrderWithLoginToken:(NSString *)loginToken
                                                         nameOrder:(NSString *)nameOrder
                                                           success:(void (^)(WCTRCSetSurnameOrderResponseResult *setSurnameOrderResponseResult))success
                                                           failure:(void (^)(NSError *error))failure;


/**
 *  設定地圖類型
 *
 *  @param loginToken 登入 Token
 *  @param mapEngine  WCTRC_MapEngine_Auto or WCTRC_MapEngine_Google or WCTRC_MapEngine_Baidu
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setMapEngineWithLoginToken:(NSString *)loginToken
                                               mapEngine:(NSString *)mapEngine
                                                 success:(void (^)(WCTRCSetUserMapEngineResponseResult *setUserMapEngineResponseResult))success
                                                 failure:(void (^)(NSError *error))failure;


/**
 *  設定是否自動分享
 *
 *  @param loginToken 登入 Token
 *  @param enable     YES or NO
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setAutoShareSettingWithLoginToken:(NSString *)loginToken
                                                         enable:(BOOL)enable
                                                        success:(void (^)(WCTRCSetAutoShareSettingResponseResult *setAutoShareSettingResponseResult))success
                                                        failure:(void (^)(NSError *error))failure;


/**
 *  新增自動分享對象
 *
 *  @param loginToken 登入 Token
 *  @param request    要新增分享的帳號資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)addAccountShareTargetWithLoginToken:(NSString *)loginToken
                                                          request:(WCTRCAccountSharedTargetRequest *)request
                                                          success:(void (^)(WCTRCMessageResponseResult *addAccountSahreTargetResponseResult))success
                                                          failure:(void (^)(NSError *error))failure;


/**
 *  移除自動分享對象
 *
 *  @param loginToken 登入 Token
 *  @param request    要移除分享的帳號資訊
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)removeAccountShareTargetWithLoginToken:(NSString *)loginToken
                                                             request:(WCTRCAccountSharedTargetRequest *)request
                                                             success:(void (^)(WCTRCMessageResponseResult *removeAccountSahreTargetResponseResult))success
                                                             failure:(void (^)(NSError *error))failure;


/**
 *   更新自動分享對象
 *
 *  @param loginToken 登入 Token
 *  @param request    要更新的內容
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)updateAccountShareTargetWithLoginToken:(NSString *)loginToken
                                                             request:(WCTRCAccountSharedTargetListRequest *)request
                                                             success:(void (^)(WCTRCMessageResponseResult *updateAccountSahreTargetResponseResult))success
                                                             failure:(void (^)(NSError *error))failure;


/**
 *  設定中文辨識結果輸出
 *
 *  @param loginToken 登入 Token
 *  @param output  WCTRC_ChineseRecognizeOutput_ContactContent, WCTRC_ChineseRecognizeOutput_CHT, WCTRC_ChineseRecognizeOutput_CHS
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setChineseRecognizeOutputWithLoginToken:(NSString *)loginToken
                                                               output:(NSString *)output
                                                              success:(void (^)(WCTRCSetChineseRecognizeOutputResponseResult *setChineseRecognizeOutputResponseResult))success
                                                              failure:(void (^)(NSError *error))failure;


/**
 *  設定依欄位排序
 *
 *  @param loginToken 登入 Token
 *  @param field  WCTRC_SortByField_Name, WCTRC_SortByField_Company, WCTRC_SortByField_CreateTime, WCTRC_SortByField_ModifiedTime
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setSortByFieldWithLoginToken:(NSString *)loginToken
                                                     field:(NSString *)field
                                                   success:(void (^)(WCTRCSetSortByFieldResponseResult *setSortByFieldResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;
/**
 *  設定辨識後是否進入編輯
 *
 *  @param loginToken 登入 Token
 *  @param enable YES: 辨識後進入，else NO
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setEditAfterRecogWithLoginToken:(NSString *)loginToken
                                                       enable:(BOOL)enable
                                                      success:(void (^)(WCTRCSetEditAfterRecogResponseResult *setEditAfterRecogResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;


/**
 *  設定辨識後是否進入備註
 *
 *  @param loginToken 登入 Token
 *  @param enable YES: 辨識後進入，else NO
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setAddNoteInfoAfterRecogWithLoginToken:(NSString *)loginToken
                                                              enable:(BOOL)enable
                                                             success:(void (^)(WCTRCSetAddNoteInfoAfterRecogResponseResult *setAddNoteInfoAfterRecogResponseResult))success
                                                             failure:(void (^)(NSError *error))failure;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - CRM settings


/**
 *  設定CRM - 以帳號密碼方式使用
 *
 *  @param loginToken 登入 Token
 *  @param crmSettings CRM Settings
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setCRMSettingsWithLoginToken:(NSString *)loginToken
                                               crmSettings:(WCTRCCRMSettings *)crmSettings
                                                   success:(void (^)(WCTRCMessageResponseResult *setCRMSettingsResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  取得CRM設定
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)CRMSettingsWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCCRMSettingsResponseResult *CRMSettingsResponseResult))success
                                                failure:(void (^)(NSError *error))failure;

/**
 *  取得系統CRM的設定
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)CRMSystemWithLoginToken:(NSString *)loginToken
                                              success:(void (^)(WCTRCMessageResponseResult *CRMSystemResponseResult))success
                                              failure:(void (^)(NSError *error))failure;


/**
 *  取得系統CRM的設定 (server 7.0後新增)
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)CRMSystemV7WithLoginToken:(NSString *)loginToken
                                              success:(void (^)(WCTRCCRMSystemResponseResult *CRMSystemResponseResult))success
                                              failure:(void (^)(NSError *error))failure;

/**
 *  登出CRM
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)logoutCRMWithLoginToken:(NSString *)loginToken
                                              CRMType:(NSString *)CRMType
                                              success:(void (^)(WCTRCMessageResponseResult *logoutCRMResponseResult))success
                                              failure:(void (^)(NSError *error))failure;


/**
 *  取得最後匯出資訊
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)lastCRMExportInfoWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCUserExportInfoResponseResult *lastCRMExportInfoResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;


/**
 *  設定CRM匯出模式
 *
 *  @param loginToken 登入 Token
 *  @param CRMType 要設定的CRMType
 *  @param CRMExportMode 匯出模式
 *  @param CRMCompanyAssignmentOption 匯出公司的指定
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setCRMExportModeWithLoginToken:(NSString *)loginToken
                                                     CTMType:(NSString *)CRMType
                                               CRMExportMode:(NSString *)CRMExportMode
CRMCompanyAssignmentOption:(NSString *)CRMCompanyAssignmentOption
                                                     success:(void (^)(WCTRCMessageResponseResult *setCRMExportModeResponseResult))success
                                                     failure:(void (^)(NSError *error))failure;


/**
 *  設定CRM - 以access token方式使用
 *
 *  @param loginToken 登入 Token
 *  @param CRMTokenRequest 要設定的CRM token 資料
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setCRMAccessTokenWithLoginToken:(NSString *)loginToken
                                              CRMTokenRequest:(WCTRCUpdateCRMTokenRequest *)CRMTokenRequest
                                                      success:(void (^)(WCTRCMessageResponseResult *setCRMAccessTokenResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;

/**
 *  透過Server取得salesforce的OAuth token
 *
 *  @param loginToken 登入 Token
 *  @param code salesforce的approval code
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)salesforceOAuthTokenWithLoginToken:(NSString *)loginToken
                                                            code:(NSString *)code
                                                         success:(void (^)(WCTRCCRMUserAgentOAuthTokenResponseResult *userAgentOAuthTokenResponseResult))success
                                                         failure:(void (^)(NSError *error))failure;




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Contact server settings


/**
 *  設定ContactServer- 以帳號密碼方式使用
 *
 *  @param loginToken 登入 Token
 *  @param settings contact server Settings
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setExchangeServerSettingsWithLoginToken:(NSString *)loginToken
                                                             settings:(WCTRCExchangeServerSettings *)settings
                                                              success:(void (^)(WCTRCMessageResponseResult *setContactServerSettingsResponseResult))success
                                                              failure:(void (^)(NSError *error))failure;


/**
 *  取得ContactServer設定
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)exchangeServerSettingsWithLoginToken:(NSString *)loginToken
                                                           success:(void (^)(WCTRCExchangeServerSettingsResponseResult *contactServerSettingsResponseResult))success
                                                           failure:(void (^)(NSError *error))failure;

/**
 *  取得系統ContactServer的設定
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)exchangeServerInfoWithLoginToken:(NSString *)loginToken
                                                       success:(void (^)(WCTRCExchangeServerSystemResponseResult *contactServerInfoResponseResult))success
                                                       failure:(void (^)(NSError *error))failure;


/**
 *  登出ContactServer
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)logoutExchangeServerWithLoginToken:(NSString *)loginToken
                                                         success:(void (^)(WCTRCMessageResponseResult *logoutContactServerResponseResult))success
                                                         failure:(void (^)(NSError *error))failure;


/**
 *  取得最後匯出資訊
 *
 *  @param loginToken 登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)lastExchangeServerExportInfoWithLoginToken:(NSString *)loginToken
                                                                 success:(void (^)(WCTRCUserExportInfoResponseResult *lastContactServerExportInfoResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure;


/**
 *  設定CRM匯出模式
 *
 *  @param loginToken 登入 Token
 *  @param mode 匯出模式
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)setExchangeServerExportModeWithLoginToken:(NSString *)loginToken
                                                                   mode:(NSString *)mode
                                                                success:(void (^)(WCTRCMessageResponseResult *setContactServerExportModeResponseResult))success
                                                                failure:(void (^)(NSError *error))failure;
/**
*  設定CRM匯出模式
*
*  @param loginToken 登入 Token
*  @param tokenSettings token資訊
*  @param success    成功 回傳
*  @param failure    失敗 回傳
*
*  @return nil, 代表需求沒透過網路傳送出去
*/
- (RKObjectRequestOperation *)setExchangeServerAccessTokenWithLoginToken:(NSString *)loginToken
                                                           tokenSettings:(WCTRCExchangeServerTokenSettings *)tokenSettings
                                                                 success:(void (^)(WCTRCMessageResponseResult *setCRMAccessTokenResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - QContact Method (QNAP)


/// 登入 QContact
/// @param loginToken 登入 Token
/// @param tokenVo 需求物件
/// @param success 成功回傳
/// @param failure 失敗回傳
- (RKObjectRequestOperation *)qContactzLoginWithLoginToken:(NSString *)loginToken
                                                  tokenVo:(WCTRCQContactzAuthTokenVo *)tokenVo
                                                                 success:(void (^)(WCTRCQContactzAuthInfoResponseResult *qContactzAuthInfoResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure;




/// 設定 QContact 匯出模式
/// @param loginToken 登入Token
/// @param exportMode 匯出模式 (MANUAL_EXPORT 手動匯出, AUTO_EXPORT  自動匯出, AUTO_SYNC_CONTACT 自動同步聯絡人)
/// @param success 成功回傳
/// @param failure 失敗回傳
- (RKObjectRequestOperation *)setQContactzExportModeWithLoginToken:(NSString *)loginToken
                                                  exportMode:(NSString *)exportMode
                                                                 success:(void (^)(WCTRCMessageResponseResult *messageResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure;




/// QCONTACTZ 郵件寄送取得兩步驟驗證碼
/// @param loginToken 登入token
/// @param basicInfo 需求物件
/// @param success 成功回傳
/// @param failure 失敗回傳
- (RKObjectRequestOperation *)setQContactzEmailSecurityCodeWithLoginToken:(NSString *)loginToken
                                                               basicInfo:(WCTRCAuthInfo *)basicInfo
                                                                 success:(void (^)(WCTRCQContactzEmailResponseResult *qContactzEmailResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PCS Method (精準校正)


/// 取得PCS設定
/// @param loginToken 登入token
/// @param success 成功回傳
/// @param failure 失敗回傳
- (RKObjectRequestOperation *)getPCSSettingWithLoginToken:(NSString *)loginToken
                                                  success:(void (^)(WCTRCPCSSettingResponseResult *responseResult))success
                                                  failure:(void (^)(NSError *error))failure;

/// 轉移精準校正額度
/// @param loginToken 登入token
/// @param request 轉移資訊
/// @param success 成功回傳
/// @param failure 失敗回傳
- (RKObjectRequestOperation *)transferPCSQuotaWithLoginToken:(NSString *)loginToken
                                                     request:(WCTRCTransferQuotaRequest *)request
                                                  success:(void (^)(WCTRCMessageResponseResult *responseResult))success
                                                  failure:(void (^)(NSError *error))failure;

@end
