//
//  WCTRestClient+MyCard.h
//  WCTRestClientController
//
//  Created by sanhue cheng on 2020/10/26.
//

#import "WCTRestClient.h"
#import "CrossPlatformDefine.h"

#import "WCTRCMyCardInfoResponseResult.h"
#import "WCTRCBooleanResponseResult.h"
#import "WCTRCMyCardSettingResponseResult.h"
#import "WCTRCMessageResponseResult.h"
#import "WCTRCUpdateMyCardInfoRequest.h"



@interface WCTRestClient (MyCard)

/**
 *  取得我的電子名片
 *
 *  @param loginToken   登入 Token
 *  @param myCardID 要取回的我的名片ID
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)getMyCardWithLoginToken:(NSString *)loginToken
                                             myCardID:(NSString *)myCardID
                                              success:(void (^)(WCTRCMyCardInfoResponseResult *myCardResponseResult))success
                                              failure:(void (^)(NSError *error))failure;

/**
 *  取得我的電子名片的圖片
 *
 *  @param loginToken   登入 Token
 *  @param myCardID 要取回的我的名片ID
 *  @param imageType 圖片類型 WCTRC_ImageType_Front, WCTRC_ImageType_Rear, WCTRC_ImageType_Logo
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)getMyCardImageWithLoginToken:(NSString *)loginToken
                                                  myCardID:(NSString *)myCardID
                                                 imageType:(NSString *)imageType
                                                   success:(void (^)(CPImage *image))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  取得電子名片設定資料，包含是否開啟分享，QRCode，分享的URL
 *
 *  @param loginToken   登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)myCardSettingWithLoginToken:(NSString *)loginToken
                                                 success:(void (^)(WCTRCMyCardSettingResponseResult *responseResult))success
                                                 failure:(void (^)(NSError *error))failure;

/**
 *  開啟電子名片分享
 *
 *  @param loginToken   登入 Token
 *  @param myCardID 要取回的我的名片ID
 *  @param enable 開啟還是關閉
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)enableMyCardWithLoginToken:(NSString *)loginToken
                                                myCardID:(NSString *)myCardID
                                                  enable:(BOOL)enable
                                                 success:(void (^)(WCTRCBooleanResponseResult *responseResult))success
                                                 failure:(void (^)(NSError *error))failure;


/**
 *  更新我的電子名片
 *
 *  @param loginToken   登入 Token
 *  @param myCardID 要取回的我的名片ID
 *  @param cardInfo 要更新的我的電子名片內容
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)upsertMyCardWithLoginToken:(NSString *)loginToken
                                                myCardID:(NSString *)myCardID
                                                cardInfo:(WCTRCUpdateMyCardInfoRequest *)cardInfo
                                                 success:(void (^)(WCTRCMessageResponseResult *responseResult))success
                                                 failure:(void (^)(NSError *error))failure;
@end
