//
//  WCTRestClient+Account.m
//
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRestClient+Account.h"

@implementation WCTRestClient (Account)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)accountLogoWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCInLineModel *inLineModel))success
                                                failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(loginToken==nil ||
           [loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCInLineModel class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_Logo]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_User_Account_Logo
                         parameters:nil
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////

                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)resetPasswordWithLoginToken:(NSString *)loginToken
                                                 password:(NSString *)password
                                                  success:(void (^)(WCTRCResetPasswordResponseResult *resetPasswordResponseResult))success
                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0||
           [password length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCResetPasswordResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_ResetPassword]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_User_Account_ResetPassword
                          parameters:@{@"password":password}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)changePasswordWithLoginToken:(NSString *)loginToken
                                               oldPassword:(NSString *)oldPassword
                                               newPassword:(NSString *)newPassword
                                                   success:(void (^)(WCTRCChangePasswordResponseResult *changePasswordResponseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [oldPassword length]<=0 ||
           [newPassword length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCChangePasswordResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_ChangePassword]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_User_Account_ChangePassword
                          parameters:@{@"oldPassword":oldPassword,
                                       @"newPassword":newPassword}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)uploadAccountLogoWithLoginToken:(NSString *)loginToken
                                                        image:(CPImage *)image
                                                     fileName:(NSString *)fileName
                                                     mineType:(NSString *)mineType
                                                      success:(void (^)(WCTRCAccountUploadLogoResponseResult *accountUploadLogoResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           image==nil ||
           [fileName length]<=0 ||
           [mineType length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAccountUploadLogoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_UpLoadLogo]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSData *imageData = [self dataForImage:image mineType:mineType];
        
        //////////////////////////////////////////////////
        
        operation = [self multipartFormRequestWithObject:nil
                                         byObjectManager:objectManager
                                                  method:RKRequestMethodPOST
                                                    path:WCTClientPath_User_Account_UpLoadLogo
                                                    data:imageData
                                                    name:@"logoFile"
                                                fileName:fileName
                                                mimeType:mineType
                                              parameters:nil
                                    httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                                                 success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                                                 failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)accountInfoWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCAccountInfoResponseResult *accountInfoResponseResult))success
                                                failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        if([self addResponseDescriptorForObjectClass:[WCTRCAccountInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_Info]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_User_Account_Info
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)otherAccountsInfoWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCOtherAccountListResponseResult *accountInfoResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAccountInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_OtherAccounts]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_User_Account_OtherAccounts
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)accountBossWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCAccountInfoResponseResult *accountInfoResponseResult))success
                                                failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAccountInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_Boss]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_User_Account_Boss
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)accountSubordinatesWithLoginToken:(NSString *)loginToken
                                                        success:(void (^)(WCTRCAccountInfoResponseResult *accountInfoResponseResult))success
                                                        failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAccountInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_Subordinates]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_User_Account_Subordinates
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)changeDisplayNameWithLoginToken:(NSString *)loginToken
                                                  displayName:(NSString *)displayName
                                                      success:(void (^)(WCTRCMessageResponseResult *changeDisplayNameResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [displayName length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_User_Account_ChangeDisplayName]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_User_Account_ChangeDisplayName
                          parameters:@{@"newDisplayName":displayName}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}
@end
