//
//  WCTPasswordViewController.m
//
//
//  Created by Howard.Lin on 2014/6/5.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCTPasswordViewController.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCTPasswordViewController+ResourceDefine.h"
#import "WCTRestClientController+SettingsKey.h"


// Controller
#import "PPSettingsController.h"
#import "PPNetworkReachabilityController.h"
#import "WCTLoginController.h"
#import "WCTPasswordSectionController.h"
#import "WCTRestClientController.h"
#import "WCToastController.h"

// View
#import "PPBusyView.h"
#import "PPTableView.h"
#import "PPNavigationBarView.h"
#import "PPTextFieldTableViewCell.h"
#import "PPSwitchTableViewCell.h"
#import "WCTPasswordExplanationView.h"

// Category
#import "NSData+AES256.h"
#import "NSString+Additions.h"
#import "UIViewController+ShareApplication.h"
#import "NSError+Custom.h"
#import "PPButton+Factory.h"
#import "WCTRestClientController+Password.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTPasswordViewController ()
<
UIAlertViewDelegate,
PPButtonDelegate,
UITableViewDataSource,
UITableViewDelegate,
PPSwitchTableViewCellDelegate,
PPTextFieldTableViewCellDelegate
>

@property (nonatomic,retain) WCTPasswordSectionController    *passwordSectionConroller;
@property (nonatomic,retain) PPBusyView                      *ppBusyView;
@property (nonatomic,retain) PPButton                        *ppButtonBack;
@property (nonatomic,retain) PPButton                        *ppButtonDone;
@property (nonatomic,retain) PPNavigationBarView             *ppNavigationBarView;
@property (nonatomic,retain) PPTableView                     *ppTableView;
@property (nonatomic,retain) WCTPasswordExplanationView      *passwordExplanationView;
@property (nonatomic,retain) UILabel                         *changePasswordDescriptionLabel;
@property (nonatomic,retain) NSIndexPath                     *currentSelectIndexPath;
@property (nonatomic,retain) NSOperationQueue                *operationQueue;
@property (nonatomic,assign) BOOL                            secureTextEntry;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCTPasswordViewController


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _passwordSectionConroller = [[WCTPasswordSectionController alloc] init];
        
        //////////////////////////////////////////////////
        
        _operationQueue = [[NSOperationQueue alloc] init];
        
        if(_operationQueue!=nil)
        {
            _operationQueue.maxConcurrentOperationCount = 1;
        }
        
        //////////////////////////////////////////////////
        
        _secureTextEntry = YES;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_userInfo release];
    _userInfo = nil;
    
    [_passwordSectionConroller release];
    _passwordSectionConroller = nil;
    
    [_ppBusyView removeFromSuperview];
    [_ppBusyView release];
    _ppBusyView = nil;
    
    [_currentSelectIndexPath release];
    _currentSelectIndexPath = nil;
    
    [_operationQueue cancelAllOperations];
    [_operationQueue release];
    _operationQueue = nil;
    
    [_ppButtonBack release];
    _ppButtonBack = nil;
    
    [_ppButtonDone release];
    _ppButtonDone = nil;
    
    [_ppNavigationBarView release];
    _ppNavigationBarView = nil;
    
    [_ppTableView release];
    _ppTableView = nil;
    
    [_passwordExplanationView release];
    _passwordExplanationView = nil;
    
    [_changePasswordDescriptionLabel release];
    _changePasswordDescriptionLabel = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self.passwordSectionConroller prepareDataWithChangePasswordViewControllerStyle:self.passwordViewControllerStyle];
    
    //////////////////////////////////////////////////
    
    PPTableView *tableView = [[PPTableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
    
    if(tableView!=nil)
    {
        tableView.dataSource = self;
        tableView.delegate   = self;
        
        [self.view addSubview:tableView];
        
        self.ppTableView = tableView;
    }
    
    [tableView release];
    
    //////////////////////////////////////////////////
    
    //使用客製化導航列覆蓋原始整列
    
    if(self.navigationController!=nil)
    {
        PPNavigationBarView *ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        
        if(ppNavigationBarView!=nil)
        {
            ppNavigationBarView.style           = PPBarViewStyle_CenteredAbsolute;
            ppNavigationBarView.tintColor       = self.navigationController.navigationBar.tintColor;
            
            switch (self.passwordViewControllerStyle)
            {

                case WCTPasswordViewControllerStyle_ResetPassword:
                {
                    ppNavigationBarView.titleLabel.text = WCTPVC_MLS_ResetPassword;
                    break;
                }
                case WCTPasswordViewControllerStyle_ResetPasswordBecauseOfExpired:
                {
                    ppNavigationBarView.titleLabel.text = WCTPVC_MLS_ResetPassword;
                    break;
                }
                case WCTPasswordViewControllerStyle_ChangePassword:
                default:
                {
                    ppNavigationBarView.titleLabel.text = WCTPVC_MLS_ChangePassword;
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(self.splitViewController==nil)
            {
                PPButton *ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                                         tag:WCTPVControllerButtonTag_Back
                                                                    delegate:self
                                                       normalBackgroundColor:nil
                                                  highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                             imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
                if(ppButtonBack!=nil)
                {
                    [ppButtonBack addControlEvents:UIControlEventTouchUpInside];
                    
                    self.ppButtonBack = ppButtonBack;
                    
                    [ppNavigationBarView setViews:@[self.ppButtonBack]
                                     forBlockType:PPBarViewBlockType_Left];
                }
            }
            
            //////////////////////////////////////////////////
            
            PPButton *ppButtonDone = [PPButton ppButtonWithIconImageName:ImageNameForWCTPasswordViewControllerButtonDone
                                                                     tag:WCTPVControllerButtonTag_Done
                                                                delegate:self
                                                   normalBackgroundColor:nil
                                              highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                         imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
            
            if(ppButtonDone!=nil)
            {
                ppButtonDone.delegate = self;
                [ppButtonDone addControlEvents:UIControlEventTouchUpInside];
                self.ppButtonDone = ppButtonDone;
                
                //////////////////////////////////////////////////
                
                [ppNavigationBarView setViews:@[self.ppButtonDone]
                                 forBlockType:PPBarViewBlockType_Right];
            }
            
            //////////////////////////////////////////////////
            
            UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:ppNavigationBarView];
            if(leftBarButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
                [leftBarButtonItem release];
            }
            
            self.ppNavigationBarView = ppNavigationBarView;
            [ppNavigationBarView release];
        }
    }
    
    //////////////////////////////////////////////////
    
    self.passwordExplanationView = [[[WCTPasswordExplanationView alloc] initWithV6Server:self.isV6Server] autorelease];
    
    if(self.passwordExplanationView!=nil)
    {
        self.ppTableView.tableFooterView = self.passwordExplanationView;
    }
    
    //////////////////////////////////////////////////
    // 變更密碼有兩個原因
    if(self.passwordViewControllerStyle!=WCTPasswordViewControllerStyle_ChangePassword)
    {
        self.changePasswordDescriptionLabel = [[[UILabel alloc] initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, 100)] autorelease];
        self.changePasswordDescriptionLabel.font = [UIFont systemFontOfSize:20];
        self.changePasswordDescriptionLabel.numberOfLines = 0;
        self.changePasswordDescriptionLabel.textColor = [UIColor blueColor];
        self.changePasswordDescriptionLabel.lineBreakMode = NSLineBreakByWordWrapping;

        NSString *resetPasswordReason = nil;
        switch (self.passwordViewControllerStyle)
        {
            case WCTPasswordViewControllerStyle_ResetPasswordBecauseOfExpired:
            {
                resetPasswordReason = WCTPVC_MLS_ResetPasswordBecauseOfExpired;
                break;
            }
            case WCTPasswordViewControllerStyle_ChangePassword:
            default:
            {
                resetPasswordReason = WCTPVC_MLS_ResetPasswordBecauseOfFirstLogin;
                break;
            }
        }
        
        if(resetPasswordReason)
        {
            NSMutableParagraphStyle *style =  [[NSParagraphStyle defaultParagraphStyle] mutableCopy];
            style.alignment = NSTextAlignmentJustified;
            style.firstLineHeadIndent = 10.0f;
            style.headIndent = 10.0f;
            style.tailIndent = -10.0f;
            style.lineBreakMode = self.changePasswordDescriptionLabel.lineBreakMode;
        
            NSAttributedString *attrText = [[NSAttributedString alloc] initWithString:resetPasswordReason
                                                                           attributes:@{ NSParagraphStyleAttributeName:style,
                                                                                         NSFontAttributeName:self.changePasswordDescriptionLabel.font,
                                                                                         NSForegroundColorAttributeName:self.changePasswordDescriptionLabel.textColor,
                                                                                         }];
            
            self.changePasswordDescriptionLabel.attributedText = attrText;
            
            //////////////////////////////////////////////////
            
            CGRect labelRect = [attrText boundingRectWithSize:CGSizeMake(self.view.frame.size.width, 1000)
                                                      options:NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingTruncatesLastVisibleLine
                                                      context:nil];
            self.changePasswordDescriptionLabel.frame = labelRect;
            
            [style release];
            [attrText release];

        }
        self.ppTableView.tableHeaderView = self.changePasswordDescriptionLabel;
    }
    //////////////////////////////////////////////////
    
    [self registerForKeyboardNotifications];
}



//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    
    //////////////////////////////////////////////////
    
    [self.ppTableView endEditing:YES];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////
    
    [self.ppTableView setDataSource:nil];
    [self.ppTableView setDelegate:nil];
    [self.ppTableView removeFromSuperview];
    self.ppTableView =nil;
    
    [self.ppButtonBack removeControlEvents:UIControlEventAllEvents];
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack = nil;
    
    [self.ppButtonDone removeControlEvents:UIControlEventAllEvents];
    [self.ppButtonDone removeFromSuperview];
    self.ppButtonDone = nil;
    
    [self.passwordExplanationView removeFromSuperview];
    self.passwordExplanationView = nil;
    
    //////////////////////////////////////////////////
    
    [self unRegisterForKeyboardNotifications];
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of SubView


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect visibleFrame = [self layoutFrame];
    
    self.ppTableView.frame = CGRectMake(visibleFrame.origin.x,
                                        visibleFrame.origin.y,
                                        visibleFrame.size.width,
                                        visibleFrame.size.height);
    
    //////////////////////////////////////////////////
    
    CGFloat minimumHeight = [self.passwordExplanationView appropriateHeight];
    
    self.passwordExplanationView.frame = CGRectMake(visibleFrame.origin.x,
                                                    self.ppTableView.frame.origin.x+self.ppTableView.frame.size.height-minimumHeight,
                                                    visibleFrame.size.width,
                                                    minimumHeight);
    
    self.ppTableView.tableFooterView = self.passwordExplanationView;
    self.ppTableView.tableHeaderView = self.changePasswordDescriptionLabel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)clearPasswordData
{
    for(PPSectionModel *sectionModel in self.passwordSectionConroller.sectionModelsForDefault)
    {
        for(PPRowModel *rowModel in sectionModel.rowModels)
        {
            rowModel.text = @"";
        }
    }
}


//================================================================================
//
//================================================================================
- (NSString *)originalPassword
{
    NSString *originalPassword = nil;
    
    if(self.passwordViewControllerStyle==WCTPasswordViewControllerStyle_ResetPassword||
       self.passwordViewControllerStyle==WCTPasswordViewControllerStyle_ResetPasswordBecauseOfExpired)
    {
        originalPassword = [WCTRestClientController decryptAccountPassword];
    }
    else
    {
        PPRowModel *originalPasswordRowModel = [self.passwordSectionConroller rowModelAtIndexPath:[NSIndexPath indexPathForRow:WCTCPSCSectionOriginalPassword_Row_OriginalPassword inSection:WCTCPSControllerSection_OriginalPassword] forSearching:NO];
        
        if(originalPasswordRowModel!=nil)
        {
            originalPassword = originalPasswordRowModel.text;
        }
    }
    
    return originalPassword;
}


//================================================================================
//
//================================================================================
- (NSString *)textNewPassword
{
    NSString *newPassword = nil;
    
    //////////////////////////////////////////////////
    
    PPRowModel *newPasswordRowModel = nil;
    
    if(self.passwordViewControllerStyle==WCTPasswordViewControllerStyle_ResetPassword||
       self.passwordViewControllerStyle==WCTPasswordViewControllerStyle_ResetPasswordBecauseOfExpired)
    {
        newPasswordRowModel = [self.passwordSectionConroller rowModelAtIndexPath:[NSIndexPath indexPathForRow:WCTCPSControllerSectionNewPassword_Row_NewPassword inSection:WCTCPSControllerSection_NewPassword-1]
                                                                    forSearching:NO];
    }
    else
    {
        newPasswordRowModel = [self.passwordSectionConroller rowModelAtIndexPath:[NSIndexPath indexPathForRow:WCTCPSControllerSectionNewPassword_Row_NewPassword inSection:WCTCPSControllerSection_NewPassword]
                                                                    forSearching:NO];
        
    }
    
    if(newPasswordRowModel!=nil)
    {
        newPassword = newPasswordRowModel.text;
    }
    
    return newPassword;
}


//================================================================================
//
//================================================================================
- (NSString *)textNewAgainPassword
{
    NSString *newAgainPassword = nil;
    
    //////////////////////////////////////////////////
    
    PPRowModel *checkNewPasswordRowModel = nil;
    
    if(self.passwordViewControllerStyle==WCTPasswordViewControllerStyle_ResetPassword||
       self.passwordViewControllerStyle==WCTPasswordViewControllerStyle_ResetPasswordBecauseOfExpired)
    {
        checkNewPasswordRowModel = [self.passwordSectionConroller rowModelAtIndexPath:[NSIndexPath indexPathForRow:WCTCPSControllerSectionCheckPassword_Row_CheckPassword inSection:WCTCPSControllerSection_CheckPassword-1] forSearching:NO];
    }
    else
    {
        checkNewPasswordRowModel = [self.passwordSectionConroller rowModelAtIndexPath:[NSIndexPath indexPathForRow:WCTCPSControllerSectionCheckPassword_Row_CheckPassword inSection:WCTCPSControllerSection_CheckPassword] forSearching:NO];
        
    }
    
    if(checkNewPasswordRowModel!=nil)
    {
        newAgainPassword = checkNewPasswordRowModel.text;
    }
    
    return newAgainPassword;
}


//================================================================================
//
//================================================================================
- (void)changePassword
{
    @autoreleasepool
    {
        if(self.ppBusyView!=nil)
        {
            [self.ppBusyView removeFromSuperview];
            self.ppBusyView = nil;
        }
        
        self.ppBusyView = [[[PPBusyView alloc] initWithSuperView:nil] autorelease];
        
        //////////////////////////////////////////////////
        
        __block NSError *blockError = nil;
        __block WCTPasswordViewController *blockSelf = self;
        
        //////////////////////////////////////////////////
        
        do
        {
            if(self.operationQueue==nil)
            {
                blockError = PPErrorOperationFailed(blockError);
                break;
            }
            
            //////////////////////////////////////////////////
            
            __block NSBlockOperation *blockOperation = [[[NSBlockOperation alloc] init] autorelease];
            
            if(blockOperation==nil)
            {
                blockError = PPErrorOperationFailed(blockError);
                break;
            }
            
            //////////////////////////////////////////////////
            
            [blockOperation addExecutionBlock:^{
                
                do
                {
                    if(blockOperation.isCancelled==YES)
                    {
                        blockError = PPErrorOperationCancel(blockError);
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    // MARK: 變更密碼
                    
                    if([[WCTRestClientController shareRestClientController] changePasswordWithOldPassword:[self originalPassword]
                                                                                              newPassword:[self textNewPassword]
                                                                                                    error:&blockError])
                    {
                        
                        [[WCTRestClientController shareRestClientController] autoLoginWithError:nil];
                    }
                } while (0);
                
                [blockSelf performSelectorOnMainThread:@selector(changePasswordFinishedWithError:) withObject:blockError waitUntilDone:NO];
            }];
            
            [self.operationQueue addOperation:blockOperation];
            
        }while(0);
        
        //////////////////////////////////////////////////
        
        if(blockError!=nil)
        {
            [self changePasswordFinishedWithError:blockError];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)changePasswordFinishedWithError:(NSError *)error
{
    if(self.ppBusyView!=nil)
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
    
    //////////////////////////////////////////////////
    
    self.editing = self.editing;
    
    //////////////////////////////////////////////////
    
    if(error!=nil)
    {
        if([error.domain isEqualToString:NSStringFromClass([self class])]==NO || error.code!=NSErrorCustom_Code_OperationCancel)
        {
            NSString *errorMessage = nil;
            
            if([self.delegate respondsToSelector:@selector(passwordViewController:requestErrorMessageWithError:)])
            {
                NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
                
                // !! 沒有status code用原本的Error傳出去
                if(statusCode!=NSNotFound)
                {
                    error = PPErrorMake(statusCode, [error alertMessage], @{@"isV6Server":@(self.isV6Server)});
                }
                errorMessage = [self.delegate passwordViewController:self requestErrorMessageWithError:error];
            }

            if([errorMessage length]>0)
            {
                [WCToastController showMessageToastFromSuperView:self.view
                                                     withMessage:errorMessage
                                            messageTextAlignment:NSTextAlignmentLeft
                                                        position:PPToastPositionCenter];
            }            
        }
    }
    else
    {
        if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            //清空儲存格
            [self clearPasswordData];
            
            [self.ppTableView reloadData];
        }
        
        //////////////////////////////////////////////////
        
        NSString *newPassword = [self textNewPassword];
    
        //////////////////////////////////////////////////
        
        if([self.delegate respondsToSelector:@selector(passwordViewController:didChangeWithNewPassword:)]==YES)
        {
            [self.delegate passwordViewController:self didChangeWithNewPassword:newPassword];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)checkOriginalPasswordWithCompleteHandler:(void(^)(BOOL valid, NSError *error))completeHandler
{
    __block NSError *returnError = nil;
    
    __block BOOL result = NO;
    
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        do
        {
            //　MARK: 檢查原始密碼
            
            NSString *originalPassword = [self originalPassword];
            
            if([WCTLoginController validPassword:originalPassword withError:&returnError]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            //與系統現存密碼不一致
            //        if(originalPassword!=nil && [originalPassword compare:[WCTRestClientController decryptAccountPassword]]!=NSOrderedSame)
            //        {
            //            returnError = PPErrorMake(NSErrorCustom_Code_UserDefine, WCTPVC_MLS_ErrorOldPasswordInvalidStringFormat, returnError);
            //            break;
            //        }
            
            //////////////////////////////////////////////////
            
            NSString *newPassword = [self textNewPassword];
            
            if([WCTLoginController validPassword:newPassword withError:&returnError]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSString *newAgainPassword = [self textNewAgainPassword];
            
            if([WCTLoginController validPassword:newAgainPassword withError:&returnError]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            //兩次密碼輸入不一致
            if(newAgainPassword!=nil &&
               [newPassword compare:newAgainPassword]!=NSOrderedSame)
            {
                returnError = PPErrorMake(NSErrorCustom_Code_UserDefine, WCTPVC_MLS_PasswordNotMatchAndTryAgain, returnError);
                break;
            }
            
            //        //新密碼與舊密碼相同
            //        if(originalPassword!=nil &&
            //           [newPassword compare:originalPassword]==NSOrderedSame)
            //        {
            //            returnError = PPErrorMake(NSErrorCustom_Code_UserDefine, WCTPVC_MLS_CantUseSamePassword, returnError);
            //            break;
            //        }
            //
            result = YES;
            
        } while (0);
        
        [returnError retain];
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(completeHandler)
            {
                completeHandler (result, returnError);
            }
            
            [returnError release];
        });
    });

}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Method

//================================================================================
//
//================================================================================
- (void)keyboardWillShown:(NSNotification *)notification
{
    NSDictionary* info = [notification userInfo];
    CGSize keyboardSize = [[info objectForKey:UIKeyboardFrameEndUserInfoKey] CGRectValue].size;
    
    //////////////////////////////////////////////////
    
    UIEdgeInsets contentInsets;
    UIEdgeInsets scrollIndicatorInsets;
    
    if(keyboardSize.height>keyboardSize.width)
    {
        contentInsets = UIEdgeInsetsMake(0.0, 0.0, keyboardSize.width+self.ppTableView.tableFooterView.frame.size.height, 0.0);
        scrollIndicatorInsets = UIEdgeInsetsMake(0.0, 0.0, keyboardSize.width, 0.0);
    }
    else
    {
        contentInsets = UIEdgeInsetsMake(0.0, 0.0, keyboardSize.height+self.ppTableView.tableFooterView.frame.size.height, 0.0);
        scrollIndicatorInsets = UIEdgeInsetsMake(0.0, 0.0, keyboardSize.height, 0.0);
    }
    
    //////////////////////////////////////////////////
    
    self.ppTableView.contentInset          = contentInsets;
    self.ppTableView.scrollIndicatorInsets = scrollIndicatorInsets;
    
    //////////////////////////////////////////////////
    
    CGRect rect = self.view.frame;
    
    if(keyboardSize.height>keyboardSize.width)
    {
        rect.size.height -= keyboardSize.width;
    }
    else
    {
        rect.size.height -= keyboardSize.height;
    }
    
    UITableViewCell *cell = [self.ppTableView cellForRowAtIndexPath:self.currentSelectIndexPath];
    
    //////////////////////////////////////////////////
    
    CGRect cellFrame = cell.frame;
    
    //////////////////////////////////////////////////
    
    if(cell!=nil)
    {
        if (!CGRectContainsPoint(rect, cellFrame.origin))
        {
            [self.ppTableView scrollRectToVisible:cellFrame animated:YES];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)keyboardWillHidden:(NSNotification *)notification
{
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.ppTableView.contentInset = contentInsets;
    self.ppTableView.scrollIndicatorInsets = contentInsets;
}


//================================================================================
//
//================================================================================
- (void)registerForKeyboardNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillShown:)
                                                 name:UIKeyboardWillShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWillHidden:)
                                                 name:UIKeyboardWillHideNotification object:nil];
    
}


//================================================================================
//
//================================================================================
- (void)unRegisterForKeyboardNotifications
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillHideNotification object:nil];
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTPVControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            
            break;
        }
        case WCTPVControllerButtonTag_Done:
        {
            [self.ppTableView endEditing:YES];
            
            //////////////////////////////////////////////////
//            NSError *returnError = nil;
            [self checkOriginalPasswordWithCompleteHandler:^(BOOL valid, NSError *error) {
                if (valid)
                {
                    [self changePassword];
                }
                else
                {
                    if(error!=nil)
                    {
                        NSString *errorMessage = [error alertMessage];

                        [WCToastController showMessageToastFromSuperView:self.view
                                                             withMessage:errorMessage
                                                    messageTextAlignment:NSTextAlignmentLeft
                                                                position:PPToastPositionCenter];
                    }
                    //新舊密碼一致，不用告訴伺服器是否修改密碼
                    else
                    {
                        [self goBackAnimated:YES];
                    }
                }
            }];
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSwitchTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (void)ppSwitchTableViewCellValueChanged:(PPSwitchTableViewCell *)switchTableViewCell
{
    self.secureTextEntry = !switchTableViewCell.switchControl.on;
    
    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [blockself.ppTableView reloadData];
    });
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldTableViewCellDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldTableViewCellShouldBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    self.currentSelectIndexPath = [NSIndexPath indexPathForRow:[self.ppTableView indexPathForCell:textFieldTableViewCell].row
                                                     inSection:[self.ppTableView  indexPathForCell:textFieldTableViewCell].section];
    
    return YES;
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell
{
    NSIndexPath *tableViewCellIndexPath = [NSIndexPath indexPathForRow:[self.ppTableView indexPathForCell:textFieldTableViewCell].row
                                                             inSection:[self.ppTableView  indexPathForCell:textFieldTableViewCell].section];
    
    PPRowModel *rowModel = [self.passwordSectionConroller rowModelAtIndexPath:tableViewCellIndexPath forSearching:NO];
    
    if(rowModel!=nil)
    {
        rowModel.text = textFieldTableViewCell.textField.text;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIAlertViewDelegate Method

//================================================================================
//
//================================================================================
- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    switch (alertView.tag)
    {
        case WCTPasswordViewControllerAlertViewTag_ChangePasswordSuccessful:
        {
            if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPhone)
            {
                //更改密碼成功，修正暫存account的密碼
                [self goBackAnimated:YES];
            }
            else
            {
                //清空儲存格
                [self clearPasswordData];
                
                [self.ppTableView reloadData];
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource Method

//================================================================================
//
//================================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return [self.passwordSectionConroller titleForHeaderInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.passwordSectionConroller numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.passwordSectionConroller numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    do
    {
        PPSectionModel *sectionModel = [[self.passwordSectionConroller sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
        
        switch (sectionModel.section)
        {
            case WCTCPSControllerSection_OriginalPassword:
            case WCTCPSControllerSection_NewPassword:
            case WCTCPSControllerSection_CheckPassword:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([PPTextFieldTableViewCell class])];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[PPTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([PPTextFieldTableViewCell class])] autorelease];
                }
                
                //////////////////////////////////////////////////
                
                if(sectionModel!=nil)
                {
                    PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:indexPath.row];
                    
                    if(rowModel!=nil)
                    {
                        PPTextFieldTableViewCell *textFieldCell = (PPTextFieldTableViewCell *)cell;
                        
                        textFieldCell.delegate  = self;
                        
                        //////////////////////////////////////////////////
                        
                        textFieldCell.textField.secureTextEntry = self.secureTextEntry;
                        textFieldCell.maxLength = NSUIntegerMax;
                        textFieldCell.textField.text = rowModel.text;
                        
                        //////////////////////////////////////////////////
                        
                        //                        if(rowModel.object!=nil && [rowModel.object isKindOfClass:[NSString class]]==YES)
                        //                        {
                        //                            textFieldCell.textField.placeholder = rowModel.object;
                        //                        }
                    }
                }
                
                break;
            }
            case WCTCPSControllerSection_ShowPassword:
            default:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([PPSwitchTableViewCell class])];
                
                //////////////////////////////////////////////////
                
                if(cell==nil)
                {
                    cell = [[[PPSwitchTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([PPSwitchTableViewCell class])] autorelease];
                }
                
                //////////////////////////////////////////////////
                
                
                if(sectionModel!=nil)
                {
                    PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:indexPath.row];
                    
                    if(rowModel!=nil)
                    {
                        PPSwitchTableViewCell *switchTableViewCell = (PPSwitchTableViewCell *)cell;
                        
                        switchTableViewCell.delegate  = self;
                        
                        //////////////////////////////////////////////////
                        
                        switchTableViewCell.textLabel.text = rowModel.text;
                    }
                }
                
                break;
            }
        }
    } while (0);
    
    return cell;
}

@end
