//
//  WCTSharedContactNoticeViewController.m
//  Pods
//
//  Created by sanhue on 2016/9/12.
//
//

#import "WCTSharedContactNoticeViewController.h"
//define
#import "WCAppearanceDefine.h"
#import "WCTNoticeFlowController+ResourceDefine.h"

//view
#import "PPNavigationBarView.h"
#import "NSObject+PPBusyView.h"
#import "WCTRestClientController.h"
#import "WCCardModel.h"
#import "WCToastController.h"
#import "WCTCompanyCardModel.h"
#import "PPAutoResizedLabel.h"

// controller
#import "PPNetworkReachabilityController.h"


NSString *const WCTSharedContactNoticeViewControllerCellIdentifier = @"NoticeContentCell";

static NSString *const ButtonImageNameNeedDownload = @"WCCompanyContactViewControllerButtonNeedDownload";
static NSString *const ButtonImageNameDownloaded = @"WCCompanyContactViewControllerButtonDownloaded";

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCTSharedContactNoticeViewControllerButtonTag)
{
    WCTSharedContactNoticeViewControllerButtonTag_Back = 0,
    WCTSharedContactNoticeViewControllerButtonTag_SelectAll,
    WCTSharedContactNoticeViewControllerButtonTag_Download,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTSharedContactNoticeViewController () <PPButtonDelegate>

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPButton *ppButtonSelectAll;

@property (nonatomic, retain) PPBarView *bottomBarView;
@property (nonatomic, retain) PPAutoResizedLabel *selectedLabel;
@property (nonatomic, retain) PPButton *ppButtonDownload;

@property (nonatomic, retain) NSArray *layoutConstraints;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTSharedContactNoticeViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithMode:(PPSIC_Mode)mode;
{
    self = [super initWithMode:mode];
    if (self)
    {
        self.enableMultiSelectMode = YES;
        self.reserveBottomToolbarSpace = PPBarViewDefaultHeightForToolBar;
        self.showSectionIndexView = NO;
        self.showSectionTitle = YES;
        self.cellType = WCCardHolderCellType_CompanyContacts;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self removeMainUI];
    
    self.titleString = nil;
    self.noticeInfo = nil;
    self.accountRole = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];
    
    [self loadData];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCTSharedContactNoticeViewControllerButtonTag_Back
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
 
    
    self.ppButtonSelectAll = [PPButton ppButtonWithIconImageName:WCTNoticeFlowControllerIcon_SelectAll
                                                        tag:WCTSharedContactNoticeViewControllerButtonTag_SelectAll
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    
    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        [self.ppNavigationBarView.titleLabel setText:self.titleString];
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.ppButtonSelectAll)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonSelectAll];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Right];
        }
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }

    //////////////////////////////////////////////////
    self.ppButtonDownload = [PPButton ppButtonWithIconImageName:WCTNoticeFlowControllerIcon_Download
                                                             tag:WCTSharedContactNoticeViewControllerButtonTag_Download
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                 imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    
    self.selectedLabel = [[[PPAutoResizedLabel alloc] init] autorelease];
    
    self.selectedLabel.font = [UIFont systemFontOfSize:WCAppearanceDefine_AlertToastTitleFontSize];
    self.selectedLabel.textColor = WCAppearanceDefine_SectionIndexTitleHighlightColor;
    
    //////////////////////////////////////////////////
    _bottomBarView = [[PPBarView alloc] init];
    
    if (self.bottomBarView)
    {
        [self.bottomBarView setTranslatesAutoresizingMaskIntoConstraints:NO];
        
        [self.bottomBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        self.bottomBarView.ignoreEdgeInset = NO;
        
        //////////////////////////////////////////////////
        [self.view addSubview:self.bottomBarView];
    }
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
    
    //////////////////////////////////////////////////
    if (self.ppButtonDownload)
    {
        PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonDownload];
        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        
        [self.bottomBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Right];
    }
    
    //////////////////////////////////////////////////
    if (self.selectedLabel)
    {
        PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.selectedLabel];
        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsMake(0, 5, 0, 5);
        
        [self.bottomBarView setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
    }
    
    [self updateSelectedLabelWithCount:[self.multiSelectCardIDSet count]];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppButtonBack = nil;
    self.ppButtonSelectAll = nil;
    
    self.ppNavigationBarView = nil;
    
    //////////////////////////////////////////////////
    self.ppButtonDownload = nil;
    self.selectedLabel = nil;
    
    [self.bottomBarView removeFromSuperview];
    self.bottomBarView = nil;

}


//==============================================================================
//
//==============================================================================
- (void)updateSelectedLabelWithCount:(NSInteger)count
{
    self.selectedLabel.text = [NSString stringWithFormat:WCTNoticeFlowControllerString_MultiSelectCount, (long)count];
    [self.selectedLabel sizeToFit];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"bottomBarView":self.bottomBarView};
    NSDictionary *metrics = @{@"bottomBarHeight":@(PPBarViewDefaultHeightForNavigationBarNormal)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[bottomBarView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:[bottomBarView(bottomBarHeight)]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override


//==============================================================================
//
//==============================================================================
- (void)onSelectAll
{
    [super onSelectAll];
    
    [self updateSelectedLabelWithCount:[self.multiSelectCardIDSet count]];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare data


//==============================================================================
//
//==============================================================================
- (NSArray *)sharedContacts
{
    NSError *error = nil;
    NSData *jsonData = [self.noticeInfo.notifyContent dataUsingEncoding:NSUTF8StringEncoding];
    NSDictionary *contentDictionary = [NSJSONSerialization JSONObjectWithData:jsonData options:NSJSONReadingAllowFragments error:&error];
    return [contentDictionary objectForKey:@"list"];
}


//==============================================================================
//
//==============================================================================
- (NSArray <WCTRCContactSimpleInfo *> *)contactSimpleInfosWithGuidList:(NSArray <NSString *> *)guidList
                                                             withError:(NSError **)error
                                                       progressHandler:(void(^)(CGFloat progress))progressHandler
{
    NSMutableArray *result = [NSMutableArray array];
    //////////////////////////////////////////////////
    // 取得列表資料
    // 使用正確的API取得分享聯絡人列表資訊
    NSError *returnError = nil;
    NSInteger numberPerPage = 50;

    WCTRCContactGetByGuidListRequest *request = [[WCTRCContactGetByGuidListRequest alloc] init];
    
    request.list = guidList;
    request.pageInfo = [[[WCTRCPageInfo alloc] init] autorelease];
    // !!目前沒做分頁，所以一次取得全部，
    request.pageInfo.numberPerPage = numberPerPage;//[sharedContacts count];
    request.pageInfo.ascendingOrder = YES;
    request.pageInfo.fieldOrderBy = WCTRC_ContactSortField_CreatedTime;
    
    //////////////////////////////////////////////////
    NSInteger maxPageCount = ceilf((CGFloat)[guidList count]/(CGFloat)numberPerPage);
    for (NSInteger pageIndex = 0; pageIndex < maxPageCount; pageIndex++)
    {
        if(progressHandler)
        {
            progressHandler((CGFloat)pageIndex/(CGFloat)maxPageCount);
        }
        
        @autoreleasepool
        {
            request.pageInfo.pageIndex = pageIndex;
            
            WCTRCContactListPageResponseResult *contactListPageResponseResult =
            [[WCTRestClientController shareRestClientController] contactListWithRequest:request
                                                                                  error:&returnError];
            
            if (contactListPageResponseResult!=nil)
            {
                [result addObjectsFromArray:contactListPageResponseResult.data];
            }
            else
            {
                [returnError retain];
                break;
            }
        }

    }
    
    [request release];
    
    if (error)
    {
        *error = [returnError autorelease];
    }
    
    return result;
}


//==============================================================================
//
//==============================================================================
- (WCTCompanyCardModel *)cardModelFromContactSimpleInfo:(WCTRCContactSimpleInfo *)contactSimpleInfo
{
    WCTCompanyCardModel *cardModel = [[WCTCompanyCardModel alloc] init];

    //////////////////////////////////////////////////
    // 不需要section
    cardModel.sectionTitle = @"";
    
    //////////////////////////////////////////////////
    
    cardModel.ID = contactSimpleInfo.contactGuid;
    cardModel.displayCompany = contactSimpleInfo.company;
    cardModel.displayName = contactSimpleInfo.fullname;
    cardModel.createdTime = contactSimpleInfo.createdTime;
    cardModel.displayJobTitle = contactSimpleInfo.jobTitle;
    cardModel.owner = contactSimpleInfo.ownerAccountGuid;
    cardModel.downloadStatus = contactSimpleInfo.isDownloadedToPrivate?WCTCompanyCardModelDownloadStatus_Done:WCTCompanyCardModelDownloadStatus_UnDone;

    return [cardModel autorelease];
}



//==============================================================================
//
//==============================================================================
- (void)loadData
{
    __block typeof(self) blockSelf = self;

    [blockSelf setBusy:@(YES)];
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        NSError *error = nil;
        [[WCTRestClientController shareRestClientController] noticeContentWithGuid:self.noticeInfo.guid error:&error];

        //////////////////////////////////////////////////
        WCCardSectionModel *cardSectionModel = nil;
        
        do {
            cardSectionModel = [[[WCCardSectionModel alloc] init] autorelease];
            
            if(cardSectionModel==nil)
            {
                break;
            }
            
            cardSectionModel.title = [blockSelf.noticeInfo localizedNoticeContent];
            
            //////////////////////////////////////////////////
            NSArray *sharedContacts = [blockSelf sharedContacts];
            
            if([sharedContacts count]==0)
            {
                break;
            }
            
            cardSectionModel.cardArray = [NSMutableArray arrayWithCapacity:[sharedContacts count]];
            
            if(cardSectionModel.cardArray==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            // 取得列表資料
            // 使用正確的API取得分享聯絡人列表資訊
            NSArray *contactSimpleInfoArray = [self contactSimpleInfosWithGuidList:sharedContacts
                                                                         withError:&error
                                                                   progressHandler:^(CGFloat progress) {
                                                                       
                                                                       [PPBusyView postMessage:[NSString stringWithFormat:@"%.02f%%", progress*100.0]];
                                                                   }];

            for(WCTRCContactSimpleInfo *contactSimpleInfo in contactSimpleInfoArray)
            {
                WCTCompanyCardModel *cardModel = [self cardModelFromContactSimpleInfo:contactSimpleInfo];
                [cardSectionModel.cardArray addObject:cardModel];
            }
            
            [error retain];
        } while (0);
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(error)
            {
                NSString *errorMessage = nil;
                NSError *customError = PPErrorMake(1, WCTNoticeFlowControllerString_FailedToConnectInternet, error);
                
                if ([self.delegate respondsToSelector:@selector(sharedContactNoticeViewController:requestErrorMessageWithError:)])
                {
                    errorMessage = [self.delegate sharedContactNoticeViewController:self requestErrorMessageWithError:customError];
                }
                
                if([errorMessage length]>0)
                {
                    [WCToastController showMessageToastFromSuperView:blockSelf.view
                                                         withMessage:errorMessage
                                                            position:PPToastPositionCenter];
                }
            }
            else
            {
                [PPBusyView postMessage:@"100%%"];

                blockSelf.allCardSectionArray = [NSMutableArray arrayWithObject:cardSectionModel];
                
                [blockSelf.tableView reloadData];
            }
            
            [error release];
            [blockSelf setBusy:@(NO)];
        });
    });

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - download status


//================================================================================
//
//================================================================================
- (WCTCompanyCardModel *)companyCardModelWithCardID:(NSString *)cardID
{
    WCTCompanyCardModel *cardModel = nil;
    
    do
    {
        if([cardID length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        cardModel = [self.multiSelectCardModelMapping objectForKey:cardID];
        
        if(cardModel!=nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(WCCardSectionModel *cardSecitonModel in self.allCardSectionArray)
        {
            for(WCTCompanyCardModel *companyCardModel in cardSecitonModel.cardArray)
            {
                if([companyCardModel.ID compare:cardID]==NSOrderedSame)
                {
                    cardModel = companyCardModel;
                    
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(cardModel!=nil)
            {
                break;
            }
        }
        
    }
    while (0);
    
    return cardModel;
}


//================================================================================
//
//================================================================================
- (WCTCompanyCardModelDownloadStatus)contactDownloadStatusWithCardID:(NSString *)cardID
{
    WCTCompanyCardModelDownloadStatus downloadStatus = WCTCompanyCardModelDownloadStatus_UnDone;
    
    do
    {
        if([cardID length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        downloadStatus = [self companyCardModelWithCardID:cardID].downloadStatus;
        
    }
    while (0);
    
    return downloadStatus;
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
//        case WCTSharedContactNoticeViewControllerButtonTag_Back:
//        {
//            [self goBackAnimated:YES];
//            break;
//        }
//        case WCTSharedContactNoticeViewControllerButtonTag_SelectAll:
//        {            
//            [self onSelectAll];
//            break;
//        }
        case WCTSharedContactNoticeViewControllerButtonTag_Download:
        {
            
            NSArray *selectedGuids = [[self multiSelectCardIDSet] allObjects];
            if([selectedGuids count]==0)
            {
                [WCToastController showMessageToastFromSuperView:self.view withMessage:WCTNoticeFlowControllerString_NoSelection position:PPToastPositionCenter];
                return;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                
                //過濾已下載
                NSMutableArray *undownloadedGuid = [NSMutableArray array];
                for (NSString *guid in selectedGuids)
                {
                    if ([self contactDownloadStatusWithCardID:guid]!=WCTCompanyCardModelDownloadStatus_Done)
                    {
                        [undownloadedGuid addObject:guid];
                    }
                }


                //////////////////////////////////////////////////
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    
                    if ([undownloadedGuid count]==0)
                    {
                        [WCToastController showMessageToastFromSuperView:self.view withMessage:WCTNoticeFlowControllerString_AlreadyDownloaded position:PPToastPositionCenter];
                        return;
                    }
                    //////////////////////////////////////////////////
                    if([self.delegate respondsToSelector:@selector(sharedContactNoticeViewController:requestDownloadWithGuids:)])
                    {
                        [self.delegate sharedContactNoticeViewController:self requestDownloadWithGuids:undownloadedGuid];
                    }
                });
            });

            
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTableViewController protocol


//==============================================================================
//
//==============================================================================
- (void)tableViewdidClickCheckButtonWithCell:(WCCardHolderCell *)cell
{
    NSIndexPath *indexPath = [self.tableView indexPathForCell:cell];
    
    [self.tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    //////////////////////////////////////////////////
    [self onDidSelectCellWithIndexPath:indexPath];

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    WCCardHolderCell *cell = (WCCardHolderCell *)[super tableView:tableView cellForRowAtIndexPath:indexPath];
    
    if([self contactDownloadStatusWithCardID:cell.cardID]==WCTCompanyCardModelDownloadStatus_Done)
    {
        [cell.additionButton setImageWithName:ButtonImageNameDownloaded];
    }
    else
    {
        [cell.additionButton setImageWithName:ButtonImageNameNeedDownload];
    }
    return cell;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    //////////////////////////////////////////////////
    [self onDidSelectCellWithIndexPath:indexPath];
    
    [self updateSelectedLabelWithCount:[self.multiSelectCardIDSet count]];

}



@end
