//
//  WCTCRMExportResultViewController.m
//  Pods
//
//  Created by sanhue on 2016/12/20.
//
//

#import "WCTCRMExportResultViewController.h"

//define
#import "WCAppearanceDefine.h"
#import "WCTNoticeFlowController+ResourceDefine.h"

//category
#import "NSDate+Format.h"

//model
#import "PPSectionModel.h"

//view
#import "PPNavigationBarView.h"
#import "PPButton.h"

//controller
#import "PPSectionController.h"
#import "WCTRestClientController.h"

typedef NS_ENUM(NSInteger, WCTCRMExportResultViewControllerButtonTag)
{
    WCTCRMExportResultViewControllerButtonTag_Back = 0,
};

typedef NS_ENUM(NSInteger, WCTCRMExportResultViewControllerRowID)
{
    WCTCRMExportResultViewControllerRowID_Success = 0,
    WCTCRMExportResultViewControllerRowID_Failed,
};


NSInteger const WCTCRMExportResultViewControllerTitleFontSize = 16;
NSInteger const WCTCRMExportResultViewControllerContentFontSize = 16;

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTCRMExportResultViewController () <PPButtonDelegate, UITableViewDataSource, UITableViewDelegate>

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;

@property (nonatomic, retain) PPTableView *ppTableView;
@property (nonatomic, retain) PPAutoResizedLabel *noticeTimeLabel;

@property (nonatomic, retain) PPSectionController *sectionController;
@property (nonatomic, retain) NSArray *layoutConstraints;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTCRMExportResultViewController






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.sectionController = [[[PPSectionController alloc] init] autorelease];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    self.sectionController = nil;
    self.noticeInfo = nil;
    self.titleString = nil;
    
    [self removeMainUI];
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareData];
    [self prepareMainUI];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCTCRMExportResultViewControllerButtonTag_Back
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    
    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        [self.ppNavigationBarView.titleLabel setText:self.titleString];
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }

    //////////////////////////////////////////////////
    self.ppTableView = [[[PPTableView alloc] init] autorelease];
    
    if (self.ppTableView)
    {
        [self.ppTableView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.ppTableView setDelegate:self];
        [self.ppTableView setDataSource:self];
        
        [self.ppTableView setBackgroundColor:WCAppearanceDefine_SectionHeaderBGColor];
        self.ppTableView.separatorStyle = UITableViewCellSeparatorStyleSingleLine;
        self.ppTableView.scrollEnabled = NO;
        
        [self.view addSubview:self.ppTableView];
        //////////////////////////////////////////////////
        
        self.noticeTimeLabel = [[[PPAutoResizedLabel alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, 50)] autorelease];
        [self.noticeTimeLabel setContentInsets:UIEdgeInsetsMake(5, 15, 5, 5)];
        [self.noticeTimeLabel setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
        
        [self.ppTableView setTableFooterView:self.noticeTimeLabel];
    }
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];

}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    
    [self.noticeTimeLabel removeFromSuperview];
    self.noticeTimeLabel = nil;
    
    [self.ppTableView removeFromSuperview];
    self.ppTableView = nil;
    //////////////////////////////////////////////////
    
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppButtonBack = nil;
    
    self.ppNavigationBarView = nil;

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"tableView":self.ppTableView};
    NSDictionary *metrics = nil;//@{@"<#viewName#>":<#viewInstance#>};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[tableView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[tableView]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare data


//==============================================================================
//
//==============================================================================
- (void)prepareData
{
    if (self.noticeInfo==nil)
    {
        return ;
    }
    
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{

        // 設為已讀
        NSError *error = nil;
        [[WCTRestClientController shareRestClientController] noticeContentWithGuid:self.noticeInfo.guid error:&error];

        NSArray *sectionData = nil;
        
        PPSectionModel *sectionModel = [[PPSectionModel alloc] init];
        
        if(sectionModel)
        {
            sectionModel.title = [self.noticeInfo localizedNoticeTitle];
            sectionData = @[sectionModel];
            
            //////////////////////////////////////////////////
            PPRowModel *rowModel = nil;
            if (self.showSuccessInfo)
            {
                rowModel = [PPRowModel rowModelWithRow:WCTCRMExportResultViewControllerRowID_Success
                                                              text:[self.noticeInfo CRMExportSuccessString]
                                                        detailText:nil
                                                            object:nil];
                if(rowModel)
                {
                    [sectionModel.rowModels addObject:rowModel];
                }
            }
            
            //////////////////////////////////////////////////
            NSNumber *failedNumber = [self.noticeInfo CRMExportFailedNumber];
            
            rowModel = [PPRowModel rowModelWithRow:WCTCRMExportResultViewControllerRowID_Failed
                                                          text:[self.noticeInfo CRMExportFailedString]
                                                    detailText:nil
                                                        object:failedNumber];
            if(rowModel)
            {
                [sectionModel.rowModels addObject:rowModel];
            }
        }
        
        [sectionModel release];
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            [blockSelf setSectionData:sectionData reload:YES];
        });
    });

}


//==============================================================================
//
//==============================================================================
- (void)setSectionData:(NSArray*)sectionData reload:(BOOL)reload
{
    [self.sectionController replaceSectionModels:sectionData forSearching:NO];
    
    if(reload)
    {
        [self.ppTableView reloadData];
        
        self.noticeTimeLabel.text = [self.noticeInfo.notifyTime stringWithFormat:NSDateFormat_Second];
        [self.ppTableView setTableFooterView:self.noticeTimeLabel];
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTCRMExportResultViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.sectionController numberOfRowsInSection:section forSearching:NO];
}


//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Cell"];
    
    if (cell==nil)
    {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"Cell"] autorelease];
    }
    
    [cell setUserInteractionEnabled:YES];

    [cell.textLabel setFont:[UIFont systemFontOfSize:WCTCRMExportResultViewControllerContentFontSize]];
    cell.accessoryType = UITableViewCellAccessoryNone;

    cell.selectionStyle = UITableViewCellSelectionStyleBlue;
    cell.selectedBackgroundView = [[[UIView alloc] init] autorelease];
    cell.selectedBackgroundView.backgroundColor = WCAppearanceDefine_CellHighlightedBGColor;
    

    //////////////////////////////////////////////////
    PPRowModel *rowModel = [self.sectionController rowModelAtIndexPath:indexPath forSearching:NO];
    NSInteger failedListCount = [[rowModel object] integerValue];

    if (rowModel)
    {
        if (failedListCount>0 &&
            rowModel.row==WCTCRMExportResultViewControllerRowID_Failed)
        {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        else
        {
            [cell setUserInteractionEnabled:NO];
        }
        cell.textLabel.text = rowModel.text;
    }
    return cell;
}


//==============================================================================
//
//==============================================================================
- (nullable NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return [self.sectionController titleForHeaderInSection:section forSearching:NO];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (nullable UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PPSectionHeaderView *sectionHeaderView = [self.sectionController viewForHeaderInSection:section forSearching:NO];
    sectionHeaderView.gap = 15;
    [sectionHeaderView setBackgroundColor:WCAppearanceDefine_SectionHeaderBGColor];
    [sectionHeaderView.textLabel setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
    [sectionHeaderView.textLabel setFont:[UIFont systemFontOfSize:WCTCRMExportResultViewControllerTitleFontSize]];
    return sectionHeaderView;
}


//==============================================================================
//
//==============================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    if([self.delegate respondsToSelector:@selector(crmExportResultViewController:didClickFailedWithNoticeInfo:)])
    {
        PPRowModel *rowModel = [self.sectionController copyRowModelAtIndexPath:indexPath forSearching:NO];
        NSInteger failedListCount = [rowModel.object integerValue];
        
        if (failedListCount>0 &&
            rowModel.row==WCTCRMExportResultViewControllerRowID_Failed)
        {
            [self.delegate crmExportResultViewController:self didClickFailedWithNoticeInfo:self.noticeInfo];
        }
        
        [rowModel release];
    }
}




@end
