//
//  WCTLoginTextFieldButtonTableViewCell.m
//  
//
//  Created by Howard on 2016/8/11.
//
//

#import "WCTLoginTextFieldButtonTableViewCell.h"

#import "WCTLoginViewController+ResourceDefine.h"
#import "WCTLoginViewController+ParameterDefine.h"

@implementation WCTLoginTextFieldButtonTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        _textFieldButtonView = [[PPTextFieldButtonView alloc] init];
        
        if(_textFieldButtonView!=nil)
        {
            _textFieldButtonView.ppButtonDetail.tag = WCTLoginViewControllerButtonTag_DropServerList;
            [_textFieldButtonView.ppButtonDetail setImageWithName:ImageNameWCTLoginViewControllerButtonDrop];
            
            [self.contentView addSubview:_textFieldButtonView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_textFieldButtonView release];
    _textFieldButtonView = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of subView

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    _textFieldButtonView.frame = CGRectMake(self.textFieldButtoViewContentInset.left,
                                            self.textFieldButtoViewContentInset.top,
                                            self.contentView.bounds.size.width-self.textFieldButtoViewContentInset.left-self.textFieldButtoViewContentInset.right,
                                            self.contentView.bounds.size.height-self.textFieldButtoViewContentInset.top-self.textFieldButtoViewContentInset.bottom);
}

@end
