//
//  WCTAccountRelationModel.m
//  Pods
//
//  Created by AndrewLai on 2016/4/26.
//
//

#import "WCTAccountRelationModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountRelationModel Implementation

@implementation WCTAccountRelationModel





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_guid release];
    _guid = nil;
    
    [_name release];
    _name = nil;
    
    [_email release];
    _email = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Class Method


//==============================================================================
//
//==============================================================================
+ (WCTAccountRelationModel *)accountRelationModelWithGuid:(NSString *)guid
                                                     name:(NSString *)name
                                                    email:(NSString *)email
                                        shareContactCount:(NSUInteger)shareContactCount
                                                 relation:(WCTAccountRelationModel_Relation)relation
                                       isOutgoingEmployee:(BOOL)isOutgoingEmployee
                                         isLimitedAccount:(BOOL)isLimitedAccount
{
    WCTAccountRelationModel *relationModel = [[[WCTAccountRelationModel alloc] init] autorelease];
    if (relationModel!=nil)
    {
        relationModel.guid              = guid;
        relationModel.name              = name;
        relationModel.email             = email;
        relationModel.relation          = relation;
        relationModel.shareContactCount = shareContactCount;
        relationModel.isOutgoingEmployee = isOutgoingEmployee;
        relationModel.isLimitedAccount  = isLimitedAccount;
    }
    
    return relationModel;
}


//================================================================================
//
//================================================================================
+ (WCTAccountRelationModel *)accountRelationModelWithGuid:(NSString *)guid
                                                     name:(NSString *)name
                                                    email:(NSString *)email
                                        shareContactCount:(NSUInteger)shareContactCount
                                                 relation:(WCTAccountRelationModel_Relation)relation
                                       isOutgoingEmployee:(BOOL)isOutgoingEmployee
{
    return [self accountRelationModelWithGuid:guid
                                         name:name
                                        email:email
                            shareContactCount:shareContactCount
                                     relation:relation
                           isOutgoingEmployee:NO
                             isLimitedAccount:NO];
}


//================================================================================
//
//================================================================================
+ (WCTAccountRelationModel *)accountRelationModelWithGuid:(NSString *)guid
                                                     name:(NSString *)name
                                                    email:(NSString *)email
                                        shareContactCount:(NSUInteger)shareContactCount
                                                 relation:(WCTAccountRelationModel_Relation)relation
{
    return [self accountRelationModelWithGuid:guid
                                         name:name
                                        email:email
                            shareContactCount:shareContactCount
                                     relation:relation
                           isOutgoingEmployee:NO];
}
@end
